/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.dao.DeferredProcessInstanceCleanable;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.ProcessCleanUpRunnable;
import org.apache.ode.bpel.engine.migration.MigrationHandler;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEngine;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.DebuggerContext;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class BpelServerImpl
implements BpelServer,
Scheduler.JobProcessor {
    private static final Log __log = LogFactory.getLog(BpelServerImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static Long __processMaxAge;
    public static final String DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED_NAME = "org.apache.ode.disable.deferredProcessInstanceCleanup";
    private static boolean DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED;
    private final Set<BpelProcess> _registeredProcesses = new HashSet<BpelProcess>();
    private State _state = State.SHUTDOWN;
    private final Contexts _contexts = new Contexts();
    private Properties _configProperties;
    private DehydrationPolicy _dehydrationPolicy;
    private boolean _hydrationLazy;
    private int _hydrationLazyMinimumSize;
    BpelEngineImpl _engine;
    protected BpelDatabase _db;
    private ReadWriteLock _mngmtLock = new ReentrantReadWriteLock();

    public Contexts getContexts() {
        return this._contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.INIT, State.RUNNING)) {
                __log.debug((Object)"start() ignored -- already started");
                return;
            }
            __log.debug((Object)"BPEL SERVER starting.");
            new MigrationHandler(this._contexts).migrate(this._registeredProcesses);
            this._state = State.RUNNING;
            __log.info((Object)__msgs.msgServerStarted());
            if (this._dehydrationPolicy != null) {
                Thread thread = new Thread((Runnable)new ProcessDefReaper(), "Dehydrator");
                thread.setDaemon(true);
                thread.start();
            }
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void registerExternalVariableEngine(ExternalVariableModule externalVariableModule) {
        this._contexts.externalVariableEngines.put(externalVariableModule.getName(), externalVariableModule);
    }

    public void registerBpelEventListener(BpelEventListener bpelEventListener) {
        bpelEventListener.startup(this._configProperties);
        this._contexts.eventListeners.add(bpelEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBpelEventListener(BpelEventListener bpelEventListener) {
        try {
            bpelEventListener.shutdown();
        }
        catch (Exception exception) {
            __log.warn((Object)("Stopping BPEL event listener " + bpelEventListener.getClass().getName() + " failed, nevertheless it has been unregistered."), (Throwable)exception);
        }
        finally {
            this._contexts.eventListeners.remove(bpelEventListener);
        }
    }

    private void unregisterBpelEventListeners() {
        for (BpelEventListener bpelEventListener : this._contexts.eventListeners) {
            this.unregisterBpelEventListener(bpelEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.RUNNING, State.INIT)) {
                __log.debug((Object)"stop() ignored -- already stopped");
                return;
            }
            __log.debug((Object)"BPEL SERVER STOPPING");
            this._contexts.scheduler.stop();
            this._engine = null;
            this._state = State.INIT;
            __log.info((Object)__msgs.msgServerStopped());
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.SHUTDOWN, State.INIT)) {
                return;
            }
            __log.debug((Object)"BPEL SERVER initializing ");
            this._db = new BpelDatabase(this._contexts.dao, this._contexts.scheduler);
            this._state = State.INIT;
            this._engine = this.createBpelEngineImpl(this._contexts);
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    protected BpelEngineImpl createBpelEngineImpl(Contexts contexts) {
        return new BpelEngineImpl(contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            this.stop();
            this.unregisterBpelEventListeners();
            this._db = null;
            this._engine = null;
            this._state = State.SHUTDOWN;
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpelEngine getEngine() {
        boolean bl = false;
        this._mngmtLock.readLock().lock();
        try {
            this._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean bl) {
                    BpelServerImpl.this._mngmtLock.readLock().unlock();
                }

                public void beforeCompletion() {
                }
            });
            bl = true;
        }
        finally {
            if (!bl) {
                this._mngmtLock.readLock().unlock();
            }
        }
        return this._engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ProcessConf processConf) {
        if (processConf == null) {
            throw new NullPointerException("must specify non-null process configuration.");
        }
        __log.debug((Object)("register: " + processConf.getProcessId()));
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            __log.debug((Object)"register(...) interrupted.", (Throwable)interruptedException);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            if (this._engine.isProcessRegistered(processConf.getProcessId())) {
                __log.debug((Object)("skipping doRegister" + processConf.getProcessId() + ") -- process is already registered"));
                return;
            }
            __log.debug((Object)("Registering process " + processConf.getProcessId() + " with server."));
            BpelProcess bpelProcess = this.createBpelProcess(processConf);
            this._engine.registerProcess(bpelProcess);
            this._registeredProcesses.add(bpelProcess);
            if (!this.isLazyHydratable(bpelProcess)) {
                bpelProcess.hydrate();
            } else {
                this._engine.setProcessSize(bpelProcess.getPID(), false);
            }
            __log.info((Object)__msgs.msgProcessRegistered(processConf.getProcessId()));
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    private boolean isLazyHydratable(BpelProcess bpelProcess) {
        if (bpelProcess.isHydrationLazySet()) {
            return bpelProcess.isHydrationLazy();
        }
        if (!this._hydrationLazy) {
            return false;
        }
        return bpelProcess.getEstimatedHydratedSize() < (long)this._hydrationLazyMinimumSize;
    }

    protected BpelProcess createBpelProcess(ProcessConf processConf) {
        return new BpelProcess(processConf);
    }

    public void unregister(QName qName) throws BpelEngineException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("unregister: " + qName));
        }
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            __log.debug((Object)"unregister() interrupted.", (Throwable)interruptedException);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            BpelProcess bpelProcess = null;
            if (this._engine != null && (bpelProcess = this._engine.unregisterProcess(qName)) != null) {
                this._registeredProcesses.remove(bpelProcess);
                XslTransformHandler.getInstance().clearXSLSheets(bpelProcess.getProcessType());
                __log.info((Object)__msgs.msgProcessUnregistered(qName));
            }
        }
        catch (Exception exception) {
            __log.error((Object)__msgs.msgProcessUnregisterFailed(qName), (Throwable)exception);
            throw new BpelEngineException((Throwable)exception);
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._contexts.globalInterceptors.add(messageExchangeInterceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._contexts.globalInterceptors.remove(messageExchangeInterceptor);
    }

    private boolean checkState(State state, State state2) {
        if (this._state == state) {
            return true;
        }
        if (this._state == state2) {
            return false;
        }
        return false;
    }

    protected boolean deleteProcessDAO(final QName qName, boolean bl) {
        try {
            if (bl) {
                return this.deleteProcessDAO(this._contexts.inMemDao.getConnection(), qName);
            }
            return this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    return BpelServerImpl.this.deleteProcessDAO(bpelDAOConnection, qName);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private boolean deleteProcessDAO(BpelDAOConnection bpelDAOConnection, QName qName) {
        ProcessDAO processDAO = bpelDAOConnection.getProcess(qName);
        if (processDAO != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Deleting only the process " + qName + "..."));
            }
            processDAO.deleteProcessAndRoutes();
            if (__log.isInfoEnabled()) {
                __log.info((Object)("Deleted only the process " + qName + "."));
            }
            if (processDAO instanceof DeferredProcessInstanceCleanable && !DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED) {
                this._engine._contexts.scheduler.scheduleMapSerializableRunnable((Scheduler.MapSerializableRunnable)new ProcessCleanUpRunnable(((DeferredProcessInstanceCleanable)processDAO).getId()), new Date());
            } else if (processDAO instanceof DeferredProcessInstanceCleanable) {
                ((DeferredProcessInstanceCleanable)processDAO).deleteInstances(Integer.MAX_VALUE);
            }
            return true;
        }
        return false;
    }

    public void onScheduledJob(Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        this.getEngine().onScheduledJob(jobInfo);
    }

    public void setDehydrationPolicy(DehydrationPolicy dehydrationPolicy) {
        this._dehydrationPolicy = dehydrationPolicy;
    }

    public void setConfigProperties(Properties properties) {
        this._configProperties = properties;
    }

    public void setMessageExchangeContext(MessageExchangeContext messageExchangeContext) throws BpelEngineException {
        this._contexts.mexContext = messageExchangeContext;
    }

    public void setScheduler(Scheduler scheduler) throws BpelEngineException {
        this._contexts.scheduler = scheduler;
    }

    public void setEndpointReferenceContext(EndpointReferenceContext endpointReferenceContext) throws BpelEngineException {
        this._contexts.eprContext = endpointReferenceContext;
    }

    public void setDaoConnectionFactory(BpelDAOConnectionFactory bpelDAOConnectionFactory) throws BpelEngineException {
        this._contexts.dao = bpelDAOConnectionFactory;
    }

    public void setInMemDaoConnectionFactory(BpelDAOConnectionFactory bpelDAOConnectionFactory) {
        this._contexts.inMemDao = bpelDAOConnectionFactory;
    }

    public void setBindingContext(BindingContext bindingContext) {
        this._contexts.bindingContext = bindingContext;
    }

    public DebuggerContext getDebugger(QName qName) throws BpelEngineException {
        return this._engine._activeProcesses.get((Object)qName)._debugger;
    }

    public boolean hasActiveInstances(QName qName) {
        BpelProcess bpelProcess = this._engine.getProcess(qName);
        return bpelProcess != null ? bpelProcess.hasActiveInstances() : false;
    }

    public void setHydrationLazy(boolean bl) {
        this._hydrationLazy = bl;
    }

    public void setProcessThrottledMaximumSize(long l) {
        this._engine.setProcessThrottledMaximumSize(l);
    }

    public void setProcessThrottledMaximumCount(int n) {
        this._engine.setProcessThrottledMaximumCount(n);
    }

    public void setHydrationLazyMinimumSize(int n) {
        this._hydrationLazyMinimumSize = n;
    }

    public void setInstanceThrottledMaximumCount(int n) {
        this._engine.setInstanceThrottledMaximumCount(n);
    }

    public void cleanupProcess(ProcessConf processConf) throws BpelEngineException {
        if (processConf != null) {
            this.deleteProcessDAO(processConf.getProcessId(), processConf.isTransient());
        }
    }

    static {
        DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED = Boolean.getBoolean(DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED_NAME);
        try {
            String string = System.getProperty("ode.process.maxage");
            if (string != null && string.length() > 0) {
                __processMaxAge = Long.valueOf(string);
                __log.info((Object)("Process definition max age adjusted. Max age = " + __processMaxAge + "ms."));
            }
        }
        catch (Throwable throwable) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Could not parse ode.process.maxage environment variable.", throwable);
            }
            __log.info((Object)"Could not parse ode.process.maxage environment variable; reaping disabled.");
        }
    }

    public static class PolledRunnableProcessor
    implements Scheduler.JobProcessor {
        private ExecutorService _polledRunnableExec;
        private Contexts _contexts;
        private final Map<String, PolledRunnableResults> resultsByJobId = new HashMap<String, PolledRunnableResults>();

        public void setContexts(Contexts contexts) {
            this._contexts = contexts;
        }

        public void setPolledRunnableExecutorService(ExecutorService executorService) {
            this._polledRunnableExec = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScheduledJob(final Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
            JOB_STATUS jOB_STATUS = JOB_STATUS.PENDING;
            Exception exception = null;
            boolean bl = false;
            Map<String, PolledRunnableResults> map = this.resultsByJobId;
            synchronized (map) {
                PolledRunnableResults polledRunnableResults = this.resultsByJobId.get(jobInfo.jobName);
                if (polledRunnableResults != null) {
                    jOB_STATUS = polledRunnableResults._status;
                    exception = polledRunnableResults._exception;
                }
                if (jOB_STATUS == JOB_STATUS.COMPLETED) {
                    this.resultsByJobId.remove(jobInfo.jobName);
                    jobInfo.jobDetail.put("runnable_status", JOB_STATUS.COMPLETED);
                    return;
                }
                if (jOB_STATUS == JOB_STATUS.PENDING || jOB_STATUS == JOB_STATUS.FAILED) {
                    this.resultsByJobId.put(jobInfo.jobName, new PolledRunnableResults(JOB_STATUS.IN_PROGRESS, null));
                    bl = true;
                }
            }
            if (bl) {
                this._polledRunnableExec.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Scheduler.MapSerializableRunnable mapSerializableRunnable = (Scheduler.MapSerializableRunnable)jobInfo.jobDetail.get("runnable");
                            mapSerializableRunnable.restoreFromDetailsMap(jobInfo.jobDetail);
                            if (mapSerializableRunnable instanceof ContextsAware) {
                                ((ContextsAware)mapSerializableRunnable).setContexts(PolledRunnableProcessor.this._contexts);
                            }
                            mapSerializableRunnable.run();
                            Map map = PolledRunnableProcessor.this.resultsByJobId;
                            synchronized (map) {
                                PolledRunnableProcessor.this.resultsByJobId.put(jobInfo.jobName, new PolledRunnableResults(JOB_STATUS.COMPLETED, null));
                            }
                        }
                        catch (Exception exception) {
                            __log.error((Object)"", (Throwable)exception);
                            Map map = PolledRunnableProcessor.this.resultsByJobId;
                            synchronized (map) {
                                PolledRunnableProcessor.this.resultsByJobId.put(jobInfo.jobName, new PolledRunnableResults(JOB_STATUS.FAILED, exception));
                            }
                        }
                    }
                });
            }
            jobInfo.jobDetail.put("runnable_status", JOB_STATUS.IN_PROGRESS);
            if (exception != null) {
                throw new Scheduler.JobProcessorException((Throwable)exception, true);
            }
        }

        private class PolledRunnableResults {
            private JOB_STATUS _status = JOB_STATUS.PENDING;
            private Exception _exception;

            public PolledRunnableResults(JOB_STATUS jOB_STATUS, Exception exception) {
                this._status = jOB_STATUS;
                this._exception = exception;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum JOB_STATUS {
            PENDING,
            IN_PROGRESS,
            FAILED,
            COMPLETED;

        }
    }

    public static interface ContextsAware {
        public void setContexts(Contexts var1);
    }

    private class ProcessDefReaper
    implements Runnable {
        private ProcessDefReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            __log.debug((Object)"Starting process definition reaper thread.");
            long l = 10000L;
            try {
                block5: while (true) {
                    Thread.sleep(l);
                    BpelServerImpl.this._mngmtLock.writeLock().lockInterruptibly();
                    try {
                        __log.debug((Object)("Kicking reaper, OProcess instances: " + OProcess.instanceCount));
                        ArrayList<BpelProcess> arrayList = new ArrayList<BpelProcess>(BpelServerImpl.this._registeredProcesses);
                        CollectionsX.remove_if(arrayList, (MemberOfFunction)new MemberOfFunction<BpelProcess>(){

                            public boolean isMember(BpelProcess bpelProcess) {
                                return !bpelProcess.hintIsHydrated();
                            }
                        });
                        List<BpelProcess> list = BpelServerImpl.this._dehydrationPolicy.markForDehydration(arrayList);
                        Iterator<BpelProcess> iterator = list.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block5;
                            BpelProcess bpelProcess = iterator.next();
                            __log.debug((Object)("Dehydrating process " + bpelProcess.getPID()));
                            bpelProcess.dehydrate();
                        }
                    }
                    finally {
                        BpelServerImpl.this._mngmtLock.writeLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                __log.info((Object)interruptedException);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SHUTDOWN,
        INIT,
        RUNNING;

    }
}

