/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BrokeredMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.OutstandingRequestManager;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CorrelationSetInstance;
import org.apache.ode.bpel.runtime.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.ObjectPrinter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelRuntimeContextImpl
implements BpelRuntimeContext {
    private static final Log __log = LogFactory.getLog(BpelRuntimeContextImpl.class);
    private ProcessInstanceDAO _dao;
    private final Long _iid;
    protected JacobVPU _vpu;
    protected ExecutionQueueImpl _soup;
    private MyRoleMessageExchangeImpl _instantiatingMessageExchange;
    private OutstandingRequestManager _outstandingRequests;
    private BpelProcess _bpelProcess;
    private long _maxReductionTimeMs = 2000000L;

    public BpelRuntimeContextImpl(BpelProcess bpelProcess, ProcessInstanceDAO processInstanceDAO, PROCESS pROCESS, MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        this._bpelProcess = bpelProcess;
        this._dao = processInstanceDAO;
        this._iid = processInstanceDAO.getInstanceId();
        this._instantiatingMessageExchange = myRoleMessageExchangeImpl;
        this._vpu = new JacobVPU();
        this._vpu.registerExtension(BpelRuntimeContext.class, (Object)this);
        this._soup = new ExecutionQueueImpl(null);
        this._soup.setReplacementMap(this._bpelProcess.getReplacementMap(processInstanceDAO.getProcess().getProcessId()));
        this._outstandingRequests = new OutstandingRequestManager();
        this._vpu.setContext((ExecutionQueue)this._soup);
        if (bpelProcess.isInMemory()) {
            ProcessInstanceDaoImpl processInstanceDaoImpl = (ProcessInstanceDaoImpl)this._dao;
            if (processInstanceDaoImpl.getSoup() != null) {
                this._soup = (ExecutionQueueImpl)processInstanceDaoImpl.getSoup();
                this._outstandingRequests = (OutstandingRequestManager)this._soup.getGlobalData();
                this._vpu.setContext((ExecutionQueue)this._soup);
            }
        } else {
            byte[] byArray = processInstanceDAO.getExecutionState();
            if (byArray != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    this._soup.read((InputStream)byteArrayInputStream);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                this._outstandingRequests = (OutstandingRequestManager)this._soup.getGlobalData();
            }
        }
        if (pROCESS != null) {
            this._vpu.inject((JacobRunnable)pROCESS);
        }
        if (BpelProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("BpelRuntimeContextImpl created for instance " + this._iid + ". INDEXED STATE=" + this._soup.getIndex()));
        }
    }

    @Override
    public Long getPid() {
        return this._iid;
    }

    @Override
    public long genId() {
        return this._dao.genMonotonic();
    }

    @Override
    public boolean isCorrelationInitialized(CorrelationSetInstance correlationSetInstance) {
        ScopeDAO scopeDAO = this._dao.getScope(correlationSetInstance.scopeInstance);
        CorrelationSetDAO correlationSetDAO = scopeDAO.getCorrelationSet(correlationSetInstance.declaration.name);
        return correlationSetDAO.getValue() != null;
    }

    @Override
    public boolean isVariableInitialized(VariableInstance variableInstance) {
        ScopeDAO scopeDAO = this._dao.getScope(variableInstance.scopeInstance);
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variableInstance.declaration.name);
        return !xmlDataDAO.isNull();
    }

    @Override
    public boolean isPartnerRoleEndpointInitialized(PartnerLinkInstance partnerLinkInstance) {
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLinkInstance);
        return partnerLinkDAO.getPartnerEPR() != null || this._bpelProcess.getInitialPartnerRoleEPR(partnerLinkInstance.partnerLink) != null;
    }

    @Override
    public void completedFault(FaultData faultData) {
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("ProcessImpl completed with fault '" + faultData.getFaultName() + "'"));
        }
        this._dao.setFault(faultData.getFaultName(), faultData.getExplanation(), faultData.getFaultLineNo(), faultData.getActivityId(), faultData.getFaultMessage());
        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
        processInstanceStateChangeEvent.setOldState(this._dao.getState());
        this._dao.setState((short)40);
        processInstanceStateChangeEvent.setNewState((short)40);
        this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        this.sendEvent((ProcessInstanceEvent)new ProcessCompletionEvent(faultData.getFaultName()));
        this._dao.finishCompletion();
        this.faultOutstandingMessageExchanges(faultData);
        this._bpelProcess._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean bl) {
            }

            public void beforeCompletion() {
                BpelRuntimeContextImpl.this._dao.delete(BpelRuntimeContextImpl.this._bpelProcess.getCleanupCategories(false));
            }
        });
    }

    @Override
    public void completedOk() {
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("ProcessImpl " + this._bpelProcess.getPID() + " completed OK."));
        }
        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
        processInstanceStateChangeEvent.setOldState(this._dao.getState());
        this._dao.setState((short)30);
        processInstanceStateChangeEvent.setNewState((short)30);
        this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        this.sendEvent((ProcessInstanceEvent)new ProcessCompletionEvent(null));
        this._dao.finishCompletion();
        this.completeOutstandingMessageExchanges();
        this._bpelProcess._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean bl) {
            }

            public void beforeCompletion() {
                BpelRuntimeContextImpl.this._dao.delete(BpelRuntimeContextImpl.this._bpelProcess.getCleanupCategories(true));
            }
        });
    }

    @Override
    public Long createScopeInstance(Long l, OScope oScope) {
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"createScopeInstance", (Object[])new Object[]{"parentScopeId", l, "scope", oScope}));
        }
        ScopeDAO scopeDAO = null;
        if (l != null) {
            scopeDAO = this._dao.getScope(l);
        }
        ScopeDAO scopeDAO2 = this._dao.createScope(scopeDAO, oScope.name, oScope.getId());
        return scopeDAO2.getScopeInstanceId();
    }

    @Override
    public void initializePartnerLinks(Long l, Collection<OPartnerLink> collection) {
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"initializeEndpointReferences", (Object[])new Object[]{"parentScopeId", l, "partnerLinks", collection}));
        }
        ScopeDAO scopeDAO = this._dao.getScope(l);
        for (OPartnerLink oPartnerLink : collection) {
            PartnerLinkDAO partnerLinkDAO = scopeDAO.createPartnerLink(oPartnerLink.getId(), oPartnerLink.name, oPartnerLink.myRoleName, oPartnerLink.partnerRoleName);
            if (!oPartnerLink.hasMyRole()) continue;
            partnerLinkDAO.setMySessionId(new GUID().toString());
        }
    }

    @Override
    public void select(PickResponseChannel pickResponseChannel, Date date, boolean bl, Selector[] selectorArray) throws FaultException {
        Selector selector;
        String string;
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"select", (Object[])new Object[]{"pickResponseChannel", pickResponseChannel, "timeout", date, "createInstance", bl, "selectors", selectorArray}));
        }
        ProcessDAO processDAO = this._dao.getProcess();
        if (this._dao.getState() == 0) {
            assert (bl);
            string = new ProcessInstanceStateChangeEvent();
            string.setOldState((short)0);
            this._dao.setState((short)10);
            string.setNewState((short)10);
            this.sendEvent((ProcessInstanceEvent)string);
        }
        string = pickResponseChannel.export();
        ArrayList<CorrelatorDAO> arrayList = new ArrayList<CorrelatorDAO>(selectorArray.length);
        Selector[] selectorArray2 = selectorArray;
        int n = selectorArray2.length;
        for (int i = 0; i < n; ++i) {
            selector = selectorArray2[i];
            String string2 = BpelProcess.genCorrelatorId(selector.plinkInstance.partnerLink, selector.opName);
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": USING CORRELATOR " + string2));
            }
            arrayList.add(processDAO.getCorrelator(string2));
        }
        int n2 = this._outstandingRequests.findConflict(selectorArray);
        if (n2 != -1) {
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnConflictingReceive, selectorArray[n2].toString());
        }
        this._outstandingRequests.register(string, selectorArray);
        if (this._instantiatingMessageExchange != null && this._dao.getState() == 10) {
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": CHECKING for NEW INSTANCE match"));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                CorrelatorDAO correlatorDAO = (CorrelatorDAO)arrayList.get(n);
                if (!correlatorDAO.equals(this._dao.getInstantiatingCorrelator())) continue;
                this.inputMsgMatch(string, n, this._instantiatingMessageExchange);
                if (BpelProcess.__log.isDebugEnabled()) {
                    BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": FOUND match for NEW instance mexRef=" + this._instantiatingMessageExchange));
                }
                return;
            }
        }
        if (date != null) {
            this.registerTimer(pickResponseChannel, date);
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + "REGISTERED TIMEOUT for " + date));
            }
        }
        for (n = 0; n < selectorArray.length; ++n) {
            CorrelatorDAO correlatorDAO = (CorrelatorDAO)arrayList.get(n);
            selector = selectorArray[n];
            correlatorDAO.addRoute(pickResponseChannel.export(), this._dao, n, selector.correlationKeySet, selector.route);
            this.scheduleCorrelatorMatcher(correlatorDAO.getCorrelatorId(), selector.correlationKeySet);
            if (!BpelProcess.__log.isDebugEnabled()) continue;
            BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": ADDED ROUTE " + correlatorDAO.getCorrelatorId() + ": " + selector.correlationKeySet + " --> " + this._dao.getInstanceId()));
        }
    }

    @Override
    public CorrelationKey readCorrelation(CorrelationSetInstance correlationSetInstance) {
        ScopeDAO scopeDAO = this._dao.getScope(correlationSetInstance.scopeInstance);
        CorrelationSetDAO correlationSetDAO = scopeDAO.getCorrelationSet(correlationSetInstance.declaration.name);
        return correlationSetDAO.getValue();
    }

    @Override
    public Element fetchPartnerRoleEndpointReferenceData(PartnerLinkInstance partnerLinkInstance) throws FaultException {
        EndpointReference endpointReference;
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLinkInstance);
        Element element = partnerLinkDAO.getPartnerEPR();
        if (element == null && (endpointReference = this._bpelProcess.getInitialPartnerRoleEPR(partnerLinkInstance.partnerLink)) != null) {
            element = endpointReference.toXML().getDocumentElement();
        }
        if (element == null) {
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnUninitializedPartnerRole);
        }
        return element;
    }

    @Override
    public Element fetchMyRoleEndpointReferenceData(PartnerLinkInstance partnerLinkInstance) {
        return this._bpelProcess.getInitialMyRoleEPR(partnerLinkInstance.partnerLink).toXML().getDocumentElement();
    }

    private PartnerLinkDAO fetchPartnerLinkDAO(PartnerLinkInstance partnerLinkInstance) {
        ScopeDAO scopeDAO = this._dao.getScope(partnerLinkInstance.scopeInstanceId);
        return scopeDAO.getPartnerLink(partnerLinkInstance.partnerLink.getId());
    }

    @Override
    public String readProperty(VariableInstance variableInstance, OProcess.OProperty oProperty) throws FaultException {
        Node node = this.readVariable(variableInstance.scopeInstance, variableInstance.declaration.name, false);
        OProcess.OPropertyAlias oPropertyAlias = oProperty.getAlias(variableInstance.declaration.type);
        String string = this._bpelProcess.extractProperty((Element)node, oPropertyAlias, variableInstance.declaration.getDescription());
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)("readPropertyAlias(variable=" + variableInstance + ", alias=" + oPropertyAlias + ") = " + string.toString()));
        }
        return string;
    }

    @Override
    public void writeEndpointReference(PartnerLinkInstance partnerLinkInstance, Element element) throws FaultException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Writing endpoint reference " + partnerLinkInstance.partnerLink.getName() + " with value " + DOMUtils.domToString((Node)element)));
        }
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLinkInstance);
        partnerLinkDAO.setPartnerEPR(element);
    }

    public String fetchEndpointSessionId(PartnerLinkInstance partnerLinkInstance, boolean bl) throws FaultException {
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLinkInstance);
        return bl ? partnerLinkDAO.getMySessionId() : partnerLinkDAO.getPartnerSessionId();
    }

    @Override
    public Node convertEndpointReference(Element element, Node node) {
        QName qName = node.getNodeType() == 3 ? new QName(Namespaces.XML_SCHEMA, "string") : new QName(node.getNamespaceURI(), node.getLocalName());
        return this._bpelProcess._engine._contexts.eprContext.convertEndpoint(qName, element).toXML();
    }

    @Override
    public Node readVariable(Long l, String string, boolean bl) throws FaultException {
        ScopeDAO scopeDAO = this._dao.getScope(l);
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(string);
        return xmlDataDAO == null || xmlDataDAO.isNull() ? null : xmlDataDAO.get();
    }

    @Override
    public Node writeVariable(VariableInstance variableInstance, Node node) {
        ScopeDAO scopeDAO = this._dao.getScope(variableInstance.scopeInstance);
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variableInstance.declaration.name);
        xmlDataDAO.set(node);
        this.writeProperties(variableInstance, node, xmlDataDAO);
        return xmlDataDAO.get();
    }

    @Override
    public void cancelOutstandingRequests(String string) {
        this._outstandingRequests.cancel(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void reply(PartnerLinkInstance var1_1, String var2_2, String var3_3, Element var4_4, QName var5_5) throws FaultException {
        block12: {
            block11: {
                var6_6 = this._outstandingRequests.release(var1_1, var2_2, var3_3);
                if (var6_6 == null) {
                    throw new FaultException(this._bpelProcess.getOProcess().constants.qnMissingRequest);
                }
                var7_7 = new ProcessMessageExchangeEvent();
                var7_7.setMexId(var3_3);
                var7_7.setOperation(var2_2);
                var7_7.setPortType(var1_1.partnerLink.myRolePortType.getQName());
                var8_8 = this._dao.getConnection().getMessageExchange(var6_6);
                var9_9 = var8_8.createMessage(var1_1.partnerLink.getMyRoleOperation(var2_2).getOutput().getMessage().getQName());
                this.buildOutgoingMessage(var9_9, var4_4);
                var10_10 = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, var8_8);
                this._bpelProcess.initMyRoleMex(var10_10);
                var10_10.setResponse(new MessageImpl(var9_9));
                if (var5_5 != null) {
                    var8_8.setStatus(MessageExchange.Status.FAULT.toString());
                    var8_8.setFault(var5_5);
                    var7_7.setAspect((short)2);
                } else {
                    var8_8.setStatus(MessageExchange.Status.RESPONSE.toString());
                    var7_7.setAspect((short)1);
                }
                if (var8_8.getPipedMessageExchangeId() == null) break block11;
                var11_11 = (PartnerRoleMessageExchange)this._bpelProcess.getEngine().getMessageExchange(var8_8.getPipedMessageExchangeId());
                if (BpelProcess.__log.isDebugEnabled()) {
                    BpelRuntimeContextImpl.__log.debug((Object)("Replying to a p2p mex, myrole " + var10_10 + " - partnerole " + var11_11));
                }
                try {
                    switch (8.$SwitchMap$org$apache$ode$bpel$iapi$MessageExchange$Status[var10_10.getStatus().ordinal()]) {
                        case 1: {
                            var11_11.replyWithFailure(MessageExchange.FailureType.OTHER, "operation failed", null);
                            ** break;
                        }
                        case 2: {
                            var12_12 = var11_11.createMessage(var11_11.getOperation().getFault(var10_10.getFault().getLocalPart()).getMessage().getQName());
                            var12_12.setMessage(var10_10.getResponse().getMessage());
                            var11_11.replyWithFault(var10_10.getFault(), var12_12);
                            ** break;
                        }
                        case 3: {
                            var13_13 = var11_11.createMessage(var11_11.getOperation().getOutput().getMessage().getQName());
                            var13_13.setMessage(var10_10.getResponse().getMessage());
                            var11_11.reply(var13_13);
                            ** break;
                        }
                        default: {
                            BpelRuntimeContextImpl.__log.warn((Object)("Unexpected state: " + var10_10.getStatus()));
                        }
                    }
                }
                catch (Throwable var14_14) {
                    var8_8.release(this._bpelProcess.isCleanupCategoryEnabled(var10_10.getStatus() == MessageExchange.Status.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                    throw var14_14;
                }
lbl45:
                // 4 sources

                var8_8.release(this._bpelProcess.isCleanupCategoryEnabled(var10_10.getStatus() == MessageExchange.Status.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                break block12;
            }
            this._bpelProcess._engine._contexts.mexContext.onAsyncReply((MyRoleMessageExchange)var10_10);
        }
        this.sendEvent((ProcessInstanceEvent)var7_7);
    }

    @Override
    public void writeCorrelation(CorrelationSetInstance correlationSetInstance, CorrelationKey correlationKey) {
        ScopeDAO scopeDAO = this._dao.getScope(correlationSetInstance.scopeInstance);
        CorrelationSetDAO correlationSetDAO = scopeDAO.getCorrelationSet(correlationSetInstance.declaration.name);
        QName[] qNameArray = new QName[correlationSetInstance.declaration.properties.size()];
        for (int i = 0; i < correlationSetInstance.declaration.properties.size(); ++i) {
            OProcess.OProperty oProperty = (OProcess.OProperty)correlationSetInstance.declaration.properties.get(i);
            qNameArray[i] = oProperty.name;
        }
        correlationSetDAO.setValue(qNameArray, correlationKey);
        CorrelationSetWriteEvent correlationSetWriteEvent = new CorrelationSetWriteEvent(correlationSetInstance.declaration.name, correlationKey);
        correlationSetWriteEvent.setScopeId(correlationSetInstance.scopeInstance);
        this.sendEvent((ProcessInstanceEvent)correlationSetWriteEvent);
    }

    public void initializeCorrelation(CorrelationSetInstance correlationSetInstance, VariableInstance variableInstance) throws FaultException {
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("Initializing correlation set " + correlationSetInstance.declaration.name));
        }
        if (this.isCorrelationInitialized(correlationSetInstance)) {
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("OCorrelation set " + correlationSetInstance + " is already set: ignoring"));
            }
            return;
        }
        String[] stringArray = new String[correlationSetInstance.declaration.properties.size()];
        String[] stringArray2 = new String[correlationSetInstance.declaration.properties.size()];
        for (int i = 0; i < correlationSetInstance.declaration.properties.size(); ++i) {
            OProcess.OProperty oProperty = (OProcess.OProperty)correlationSetInstance.declaration.properties.get(i);
            stringArray2[i] = this.readProperty(variableInstance, oProperty);
            stringArray[i] = oProperty.name.toString();
        }
        CorrelationKey correlationKey = new CorrelationKey(correlationSetInstance.declaration.name, stringArray2);
        this.writeCorrelation(correlationSetInstance, correlationKey);
    }

    @Override
    public ExpressionLanguageRuntimeRegistry getExpLangRuntime() {
        return this._bpelProcess._expLangRuntimeRegistry;
    }

    @Override
    public void terminate() {
        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
        processInstanceStateChangeEvent.setOldState(this._dao.getState());
        this._dao.setState((short)60);
        processInstanceStateChangeEvent.setNewState((short)60);
        this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        this.sendEvent((ProcessInstanceEvent)new ProcessTerminationEvent());
        this._dao.finishCompletion();
        this.failOutstandingMessageExchanges();
    }

    @Override
    public void registerTimer(TimerResponseChannel timerResponseChannel, Date date) {
        WorkEvent workEvent = new WorkEvent();
        workEvent.setIID(this._dao.getInstanceId());
        workEvent.setChannel(timerResponseChannel.export());
        workEvent.setType(WorkEvent.Type.TIMER);
        workEvent.setInMem(this._bpelProcess.isInMemory());
        this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), date);
    }

    private void scheduleCorrelatorMatcher(String string, CorrelationKeySet correlationKeySet) {
        WorkEvent workEvent = new WorkEvent();
        workEvent.setIID(this._dao.getInstanceId());
        workEvent.setType(WorkEvent.Type.MATCHER);
        workEvent.setCorrelatorId(string);
        workEvent.setCorrelationKeySet(correlationKeySet);
        workEvent.setInMem(this._bpelProcess.isInMemory());
        this._bpelProcess._engine._contexts.scheduler.scheduleVolatileJob(true, workEvent.getDetail());
    }

    @Override
    public String invoke(int n, PartnerLinkInstance partnerLinkInstance, Operation operation, Element element, InvokeResponseChannel invokeResponseChannel) throws FaultException {
        EndpointReference endpointReference;
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLinkInstance);
        Element element2 = partnerLinkDAO.getPartnerEPR();
        if (element2 == null) {
            endpointReference = this._bpelProcess.getInitialPartnerRoleEPR(partnerLinkInstance.partnerLink);
            if (endpointReference == null) {
                throw new FaultException(partnerLinkInstance.partnerLink.getOwner().constants.qnUninitializedPartnerRole);
            }
        } else {
            endpointReference = this._bpelProcess._engine._contexts.eprContext.resolveEndpointReference(element2);
        }
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("INVOKING PARTNER: partnerLink=" + partnerLinkInstance + ", op=" + operation.getName() + " channel=" + invokeResponseChannel + ")"));
        }
        ProcessMessageExchangeEvent processMessageExchangeEvent = new ProcessMessageExchangeEvent();
        processMessageExchangeEvent.setOperation(operation.getName());
        processMessageExchangeEvent.setPortType(partnerLinkInstance.partnerLink.partnerRolePortType.getQName());
        processMessageExchangeEvent.setAspect((short)3);
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().createMessageExchange('P');
        messageExchangeDAO.setStatus(MessageExchange.Status.NEW.toString());
        messageExchangeDAO.setOperation(operation.getName());
        messageExchangeDAO.setPortType(partnerLinkInstance.partnerLink.partnerRolePortType.getQName());
        messageExchangeDAO.setPartnerLinkModelId(partnerLinkInstance.partnerLink.getId());
        messageExchangeDAO.setPartnerLink(partnerLinkDAO);
        messageExchangeDAO.setProcess(this._dao.getProcess());
        messageExchangeDAO.setInstance(this._dao);
        messageExchangeDAO.setPattern((operation.getOutput() != null ? MessageExchange.MessageExchangePattern.REQUEST_RESPONSE : MessageExchange.MessageExchangePattern.REQUEST_ONLY).toString());
        messageExchangeDAO.setChannel(invokeResponseChannel == null ? null : invokeResponseChannel.export());
        String string = partnerLinkDAO.getMySessionId();
        String string2 = partnerLinkDAO.getPartnerSessionId();
        if (string != null) {
            messageExchangeDAO.setProperty("org.apache.ode.bpel.myRoleSessionId", string);
        }
        if (string2 != null) {
            messageExchangeDAO.setProperty("org.apache.ode.bpel.partnerRoleSessionId", string2);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INVOKE PARTNER (SEP): sessionId=" + string + " partnerSessionId=" + string2));
        }
        MessageDAO messageDAO = messageExchangeDAO.createMessage(operation.getInput().getMessage().getQName());
        messageExchangeDAO.setRequest(messageDAO);
        messageDAO.setType(operation.getInput().getMessage().getQName());
        this.buildOutgoingMessage(messageDAO, element);
        EndpointReference endpointReference2 = partnerLinkInstance.partnerLink.hasMyRole() ? this._bpelProcess.getInitialMyRoleEPR(partnerLinkInstance.partnerLink) : null;
        PartnerRoleMessageExchangeImpl partnerRoleMessageExchangeImpl = this.createPartnerRoleMessageExchangeImpl(messageExchangeDAO, partnerLinkInstance, operation, endpointReference, endpointReference2);
        partnerRoleMessageExchangeImpl.setProperty("activityId", "" + n);
        List<BpelProcess> list = null;
        Endpoint endpoint = this._bpelProcess.getInitialPartnerRoleEndpoint(partnerLinkInstance.partnerLink);
        if (endpoint != null) {
            list = this._bpelProcess.getEngine().route(endpoint.serviceName, partnerRoleMessageExchangeImpl.getRequest());
        }
        if (list != null && !list.isEmpty()) {
            MyRoleMessageExchange myRoleMessageExchange = this._bpelProcess.getEngine().createMessageExchange(partnerRoleMessageExchangeImpl.getMessageExchangeId(), endpoint.serviceName, operation.getName(), partnerRoleMessageExchangeImpl.getMessageExchangeId());
            if (myRoleMessageExchange instanceof BrokeredMyRoleMessageExchangeImpl) {
                partnerRoleMessageExchangeImpl.setSubscriberCount(((BrokeredMyRoleMessageExchangeImpl)myRoleMessageExchange).getSubscriberCount());
            }
            if (BpelProcess.__log.isDebugEnabled()) {
                __log.debug((Object)("Invoking in a p2p interaction, partnerrole " + partnerRoleMessageExchangeImpl + " - myrole " + myRoleMessageExchange));
            }
            Message message = myRoleMessageExchange.createMessage(operation.getInput().getMessage().getQName());
            message.setMessage(element);
            ((MessageImpl)message)._dao.setHeader(messageDAO.getHeader());
            if (BpelProcess.__log.isDebugEnabled()) {
                __log.debug((Object)("Setting myRoleMex session ids for p2p interaction, mySession " + string2 + " - partnerSess " + string));
            }
            if (string2 != null) {
                myRoleMessageExchange.setProperty("org.apache.ode.bpel.myRoleSessionId", string2);
            }
            if (string != null) {
                myRoleMessageExchange.setProperty("org.apache.ode.bpel.partnerRoleSessionId", string);
            }
            partnerRoleMessageExchangeImpl.setStatus(MessageExchange.Status.REQUEST);
            myRoleMessageExchange.invoke(message);
            partnerRoleMessageExchangeImpl.replyAsync();
        } else if (endpointReference != null) {
            messageExchangeDAO.setEPR(endpointReference.toXML().getDocumentElement());
            partnerRoleMessageExchangeImpl.setStatus(MessageExchange.Status.REQUEST);
            this.scheduleInvokeCheck(partnerRoleMessageExchangeImpl, partnerLinkInstance.partnerLink);
            this._bpelProcess._engine._contexts.mexContext.invokePartner((PartnerRoleMessageExchange)partnerRoleMessageExchangeImpl);
        } else {
            __log.error((Object)("Couldn't find endpoint for partner EPR " + DOMUtils.domToString((Node)element2)));
            partnerRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.UNKNOWN_ENDPOINT, "UnknownEndpoint", element2);
        }
        processMessageExchangeEvent.setMexId(messageExchangeDAO.getMessageExchangeId());
        this.sendEvent((ProcessInstanceEvent)processMessageExchangeEvent);
        if (messageExchangeDAO.getPattern().equals(MessageExchange.MessageExchangePattern.REQUEST_ONLY.toString())) {
            messageExchangeDAO.setStatus(MessageExchange.Status.ASYNC.toString());
            boolean bl = partnerRoleMessageExchangeImpl.getStatus() != MessageExchange.Status.FAILURE && partnerRoleMessageExchangeImpl.getStatus() != MessageExchange.Status.FAULT;
            messageExchangeDAO.release(this._bpelProcess.isCleanupCategoryEnabled(bl, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        }
        switch (partnerRoleMessageExchangeImpl.getStatus()) {
            case NEW: {
                throw new AssertionError((Object)"Impossible!");
            }
            case ASYNC: {
                break;
            }
            case FAILURE: 
            case FAULT: 
            case RESPONSE: {
                this.invocationResponse(partnerRoleMessageExchangeImpl);
                break;
            }
            default: {
                __log.error((Object)("Partner did not acknowledge message exchange: " + partnerRoleMessageExchangeImpl));
                partnerRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.NO_RESPONSE, "Partner did not acknowledge.", null);
                this.invocationResponse(partnerRoleMessageExchangeImpl);
            }
        }
        return messageExchangeDAO.getMessageExchangeId();
    }

    protected PartnerRoleMessageExchangeImpl createPartnerRoleMessageExchangeImpl(MessageExchangeDAO messageExchangeDAO, PartnerLinkInstance partnerLinkInstance, Operation operation, EndpointReference endpointReference, EndpointReference endpointReference2) {
        return new PartnerRoleMessageExchangeImpl(this.getBpelProcess().getEngine(), messageExchangeDAO, partnerLinkInstance.partnerLink.partnerRolePortType, operation, endpointReference, endpointReference2, this.getBpelProcess().getPartnerRoleChannel(partnerLinkInstance.partnerLink));
    }

    protected BpelProcess getBpelProcess() {
        return this._bpelProcess;
    }

    private void scheduleInvokeCheck(PartnerRoleMessageExchangeImpl partnerRoleMessageExchangeImpl, OPartnerLink oPartnerLink) {
        boolean bl;
        boolean bl2 = bl = partnerRoleMessageExchangeImpl.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (!this._bpelProcess.isInMemory() && bl) {
            WorkEvent workEvent = new WorkEvent();
            workEvent.setMexId(partnerRoleMessageExchangeImpl.getMessageExchangeId());
            workEvent.setProcessId(this._bpelProcess.getPID());
            workEvent.setInMem(false);
            workEvent.setType(WorkEvent.Type.INVOKE_CHECK);
            long l = (long)((double)this.getBpelProcess().getTimeout(oPartnerLink) * 1.5);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Creating invocation check event in " + l + "ms for mexid " + partnerRoleMessageExchangeImpl.getMessageExchangeId()));
            }
            Date date = new Date(System.currentTimeMillis() + l);
            String string = this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), date);
            partnerRoleMessageExchangeImpl.setProperty("invokeCheckJobId", string);
        }
    }

    private void buildOutgoingMessage(MessageDAO messageDAO, Element element) {
        if (element == null) {
            return;
        }
        Document document = DOMUtils.newDocument();
        Element element2 = document.createElement("header");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3;
            if (nodeList.item(i).getNodeType() != 1 || (element3 = (Element)nodeList.item(i)).getAttribute("headerPart") == null || element3.getAttribute("headerPart").length() <= 0) continue;
            element2.appendChild(document.importNode(element3, true));
            element.removeChild(element3);
        }
        messageDAO.setData(element);
        messageDAO.setHeader(element2);
    }

    void execute() {
        long l = System.currentTimeMillis() + this._maxReductionTimeMs;
        boolean bl = true;
        while (ProcessState.canExecute((short)this._dao.getState()) && System.currentTimeMillis() < l && bl) {
            bl = this._vpu.execute();
        }
        this._dao.setLastActiveTime(new Date());
        if (!ProcessState.isFinished((short)this._dao.getState())) {
            Object object;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Setting execution state on instance " + this._iid));
            }
            this._soup.setGlobalData((Serializable)this._outstandingRequests);
            if (this._bpelProcess.isInMemory()) {
                ((ProcessInstanceDaoImpl)this._dao).setSoup(this._soup);
            } else {
                object = new ByteArrayOutputStream(10000);
                try {
                    this._soup.write((OutputStream)object);
                    ((ByteArrayOutputStream)object).close();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                this._dao.setExecutionState(((ByteArrayOutputStream)object).toByteArray());
            }
            if (ProcessState.canExecute((short)this._dao.getState()) && bl) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MaxTime exceeded for instance # " + this._iid));
                }
                try {
                    object = new WorkEvent();
                    ((WorkEvent)object).setIID(this._iid);
                    ((WorkEvent)object).setType(WorkEvent.Type.RESUME);
                    ((WorkEvent)object).setInMem(this._bpelProcess.isInMemory());
                    if (this._bpelProcess.isInMemory()) {
                        this._bpelProcess._engine._contexts.scheduler.scheduleVolatileJob(true, ((WorkEvent)object).getDetail());
                    } else {
                        this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(((WorkEvent)object).getDetail(), new Date());
                    }
                }
                catch (ContextException contextException) {
                    __log.error((Object)"Failed to schedule resume task.", (Throwable)contextException);
                    throw new BpelEngineException((Throwable)contextException);
                }
            }
        }
    }

    void inputMsgMatch(final String string, final int n, MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        String string2;
        if (this._dao.getState() == 10) {
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)"INPUTMSGMATCH: Changing process instance state from ready to active");
            }
            this._dao.setState((short)20);
            string2 = new ProcessInstanceStateChangeEvent();
            string2.setOldState((short)10);
            string2.setNewState((short)20);
            this.sendEvent((ProcessInstanceEvent)string2);
        }
        this._outstandingRequests.associate(string, myRoleMessageExchangeImpl.getMessageExchangeId());
        string2 = myRoleMessageExchangeImpl.getMessageExchangeId();
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            public void run() {
                PickResponseChannel pickResponseChannel = (PickResponseChannel)3.importChannel((String)string, PickResponseChannel.class);
                pickResponseChannel.onRequestRcvd(n, string2);
            }
        });
    }

    void timerEvent(final String string) {
        this._dao.getProcess().removeRoutes(string, this._dao);
        this._outstandingRequests.cancel(string);
        if (ProcessState.isFinished((short)this._dao.getState())) {
            return;
        }
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = -7767141033611036745L;

            public void run() {
                TimerResponseChannel timerResponseChannel = (TimerResponseChannel)4.importChannel((String)string, TimerResponseChannel.class);
                timerResponseChannel.onTimeout();
            }
        });
        this.execute();
    }

    @Override
    public void cancel(TimerResponseChannel timerResponseChannel) {
        final String string = timerResponseChannel.export();
        this._dao.getProcess().removeRoutes(string, this._dao);
        this._outstandingRequests.cancel(string);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 6157913683737696396L;

            public void run() {
                TimerResponseChannel timerResponseChannel = (TimerResponseChannel)5.importChannel((String)string, TimerResponseChannel.class);
                timerResponseChannel.onCancel();
            }
        });
    }

    void invocationResponse(PartnerRoleMessageExchangeImpl partnerRoleMessageExchangeImpl) {
        this.invocationResponse(partnerRoleMessageExchangeImpl.getDAO().getMessageExchangeId(), partnerRoleMessageExchangeImpl.getDAO().getChannel());
    }

    void invocationResponse(final String string, final String string2) {
        if (string2 == null) {
            throw new NullPointerException("Null responseChannelId");
        }
        if (string == null) {
            throw new NullPointerException("Null mexId");
        }
        if (BpelProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("Invoking message response for mexid " + string + " and channel " + string2));
        }
        this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
            private static final long serialVersionUID = -1095444335740879981L;

            public void run() {
                ((BpelRuntimeContextImpl)this.getBpelRuntimeContext()).invocationResponse2(string, (InvokeResponseChannel)6.importChannel((String)string2, InvokeResponseChannel.class));
            }
        });
    }

    private void invocationResponse2(String string, InvokeResponseChannel invokeResponseChannel) {
        __log.debug((Object)"Triggering response");
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        ProcessMessageExchangeEvent processMessageExchangeEvent = new ProcessMessageExchangeEvent();
        processMessageExchangeEvent.setPortType(messageExchangeDAO.getPortType());
        processMessageExchangeEvent.setMexId(string);
        processMessageExchangeEvent.setOperation(messageExchangeDAO.getOperation());
        MessageExchange.Status status = MessageExchange.Status.valueOf((String)messageExchangeDAO.getStatus());
        switch (status) {
            case FAULT: {
                processMessageExchangeEvent.setAspect((short)5);
                invokeResponseChannel.onFault();
                break;
            }
            case RESPONSE: {
                processMessageExchangeEvent.setAspect((short)4);
                invokeResponseChannel.onResponse();
                break;
            }
            case FAILURE: {
                processMessageExchangeEvent.setAspect((short)6);
                invokeResponseChannel.onFailure();
                break;
            }
            default: {
                __log.error((Object)("Invalid response state for mex " + string + ": " + status));
            }
        }
        this.sendEvent((ProcessInstanceEvent)processMessageExchangeEvent);
    }

    @Override
    public void sendEvent(ProcessInstanceEvent processInstanceEvent) {
        processInstanceEvent.setProcessId(this._dao.getProcess().getProcessId());
        processInstanceEvent.setProcessName(this._dao.getProcess().getType());
        processInstanceEvent.setProcessInstanceId(this._dao.getInstanceId());
        this._bpelProcess._debugger.onEvent((BpelEvent)processInstanceEvent);
        List list = null;
        if (processInstanceEvent instanceof ScopeEvent) {
            list = ((ScopeEvent)processInstanceEvent).getParentScopesNames();
        }
        this._bpelProcess.saveEvent(processInstanceEvent, this._dao, list);
    }

    private void writeProperties(VariableInstance variableInstance, Node node, XmlDataDAO xmlDataDAO) {
        if (variableInstance.declaration.type instanceof OMessageVarType) {
            for (OProcess.OProperty oProperty : variableInstance.declaration.getOwner().properties) {
                OProcess.OPropertyAlias oPropertyAlias = oProperty.getAlias(variableInstance.declaration.type);
                if (oPropertyAlias == null) continue;
                try {
                    String string = this._bpelProcess.extractProperty((Element)node, oPropertyAlias, variableInstance.declaration.getDescription());
                    if (string == null) continue;
                    xmlDataDAO.setProperty(oProperty.name.toString(), string);
                }
                catch (FaultException faultException) {
                    if (!__log.isDebugEnabled()) continue;
                    __log.debug((Object)("Couldn't extract property '" + oProperty.toString() + "' in property pre-extraction: " + faultException.toString()));
                }
            }
        }
    }

    private void completeOutstandingMessageExchanges() {
        String[] stringArray;
        block4: for (String string : stringArray = this._outstandingRequests.releaseAll()) {
            MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
            if (messageExchangeDAO == null) continue;
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, messageExchangeDAO);
            switch (myRoleMessageExchangeImpl.getStatus()) {
                case RESPONSE: 
                case ASYNC: {
                    myRoleMessageExchangeImpl.setStatus(MessageExchange.Status.COMPLETED_OK);
                    continue block4;
                }
                case REQUEST: {
                    if (myRoleMessageExchangeImpl.getPattern().equals((Object)MessageExchange.MessageExchangePattern.REQUEST_ONLY)) {
                        myRoleMessageExchangeImpl.setStatus(MessageExchange.Status.COMPLETED_OK);
                        continue block4;
                    }
                }
                default: {
                    myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.OTHER, "No response.", null);
                    this._bpelProcess._engine._contexts.mexContext.onAsyncReply((MyRoleMessageExchange)myRoleMessageExchangeImpl);
                    myRoleMessageExchangeImpl.release(this._bpelProcess.isCleanupCategoryEnabled(true, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                }
            }
        }
    }

    private void faultOutstandingMessageExchanges(FaultData faultData) {
        String[] stringArray;
        for (String string : stringArray = this._outstandingRequests.releaseAll()) {
            MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
            if (messageExchangeDAO == null) continue;
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, messageExchangeDAO);
            this._bpelProcess.initMyRoleMex(myRoleMessageExchangeImpl);
            Message message = myRoleMessageExchangeImpl.createMessage(faultData.getFaultName());
            if (faultData.getFaultMessage() != null) {
                message.setMessage(faultData.getFaultMessage());
            }
            myRoleMessageExchangeImpl.setResponse(message);
            myRoleMessageExchangeImpl.setFault(faultData.getFaultName(), message);
            myRoleMessageExchangeImpl.setFaultExplanation(faultData.getExplanation());
            this._bpelProcess._engine._contexts.mexContext.onAsyncReply((MyRoleMessageExchange)myRoleMessageExchangeImpl);
        }
    }

    private void failOutstandingMessageExchanges() {
        String[] stringArray;
        for (String string : stringArray = this._outstandingRequests.releaseAll()) {
            MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
            if (messageExchangeDAO == null) continue;
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, messageExchangeDAO);
            this._bpelProcess.initMyRoleMex(myRoleMessageExchangeImpl);
            myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.OTHER, "No response.", null);
            this._bpelProcess._engine._contexts.mexContext.onAsyncReply((MyRoleMessageExchange)myRoleMessageExchangeImpl);
        }
    }

    @Override
    public Element getPartnerResponse(String string) {
        return this.mergeHeaders(this._getPartnerResponse(string));
    }

    @Override
    public Element getMyRequest(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            String string2 = "Engine requested non-existent message exchange: " + string;
            __log.fatal((Object)string2);
            throw new BpelEngineException(string2);
        }
        if (messageExchangeDAO.getDirection() != 'M') {
            String string3 = "Engine requested my-role request for a partner-role mex: " + string;
            __log.fatal((Object)string3);
            throw new BpelEngineException(string3);
        }
        MessageExchange.Status status = MessageExchange.Status.valueOf((String)messageExchangeDAO.getStatus());
        switch (status) {
            case ASYNC: 
            case REQUEST: 
            case COMPLETED_OK: {
                MessageDAO messageDAO = messageExchangeDAO.getRequest();
                if (messageDAO == null) {
                    String string4 = "Engine requested request for message exchange that did not have one: " + string;
                    __log.fatal((Object)string4);
                    throw new BpelEngineException(string4);
                }
                return this.mergeHeaders(messageDAO);
            }
        }
        String string5 = "Engine requested response while the message exchange " + string + " was in the state " + status;
        __log.fatal((Object)string5);
        throw new BpelEngineException(string5);
    }

    private Element mergeHeaders(MessageDAO messageDAO) {
        if (messageDAO == null) {
            return null;
        }
        Element element = messageDAO.getData();
        if (messageDAO.getHeader() != null) {
            Object object;
            if (element == null) {
                object = DOMUtils.newDocument();
                element = object.createElement("message");
                object.appendChild(element);
            }
            object = messageDAO.getHeader().getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                if (object.item(i).getNodeType() != 1) continue;
                Element element2 = (Element)object.item(i);
                element2.setAttribute("headerPart", "true");
                element.appendChild(element.getOwnerDocument().importNode(element2, true));
            }
        }
        return element;
    }

    @Override
    public QName getPartnerFault(String string) {
        MessageExchangeDAO messageExchangeDAO = this._getPartnerResponse(string).getMessageExchange();
        return messageExchangeDAO.getFault();
    }

    @Override
    public QName getPartnerResponseType(String string) {
        return this._getPartnerResponse(string).getType();
    }

    @Override
    public String getPartnerFaultExplanation(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        return messageExchangeDAO != null ? messageExchangeDAO.getFaultExplanation() : null;
    }

    private MessageDAO _getPartnerResponse(String string) {
        MessageDAO messageDAO;
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            String string2 = "Engine requested non-existent message exchange: " + string;
            __log.fatal((Object)string2);
            throw new BpelEngineException(string2);
        }
        if (messageExchangeDAO.getDirection() != 'P') {
            String string3 = "Engine requested partner response for a my-role mex: " + string;
            __log.fatal((Object)string3);
            throw new BpelEngineException(string3);
        }
        MessageExchange.Status status = MessageExchange.Status.valueOf((String)messageExchangeDAO.getStatus());
        switch (status) {
            case FAULT: 
            case RESPONSE: {
                messageDAO = messageExchangeDAO.getResponse();
                if (messageDAO != null) break;
                String string4 = "Engine requested response for message exchange that did not have one: " + string;
                __log.fatal((Object)string4);
                throw new BpelEngineException(string4);
            }
            case FAILURE: {
                messageDAO = messageExchangeDAO.getResponse();
                break;
            }
            default: {
                String string5 = "Engine requested response while the message exchange " + string + " was in the state " + status;
                __log.fatal((Object)string5);
                throw new BpelEngineException(string5);
            }
        }
        return messageDAO;
    }

    @Override
    public void releasePartnerMex(String string, boolean bl) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        messageExchangeDAO.release(this._bpelProcess.isCleanupCategoryEnabled(bl, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        String string2 = messageExchangeDAO.getProperty("invokeCheckJobId");
        if (string2 != null) {
            this._bpelProcess._engine._contexts.scheduler.cancelJob(string2);
        }
    }

    @Override
    public Element getSourceEPR(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        String string2 = messageExchangeDAO.getProperty("org.apache.ode.bpel.partnerRoleEPR");
        if (string2 == null) {
            return null;
        }
        try {
            Element element = DOMUtils.stringToDOM((String)string2);
            return element;
        }
        catch (Exception exception) {
            __log.error((Object)("Invalid value for SEP property org.apache.ode.bpel.partnerRoleEPR: " + string2));
            return null;
        }
    }

    @Override
    public String getSourceSessionId(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        return messageExchangeDAO.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
    }

    @Override
    public void registerActivityForRecovery(ActivityRecoveryChannel activityRecoveryChannel, long l, String string, Date date, Element element, String[] stringArray, int n) {
        if (string == null) {
            string = "Unspecified";
        }
        if (date == null) {
            date = new Date();
        }
        __log.info((Object)("ActivityRecovery: Registering activity " + l + ", failure reason: " + string + " on channel " + activityRecoveryChannel.export()));
        this._dao.createActivityRecovery(activityRecoveryChannel.export(), (long)((int)l), string, date, element, stringArray, n);
        String[] stringArray2 = this._outstandingRequests.releaseAll();
        if (stringArray2 != null) {
            for (String string2 : stringArray2) {
                MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string2);
                if (messageExchangeDAO == null) continue;
                MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, messageExchangeDAO);
                this._bpelProcess.initMyRoleMex(myRoleMessageExchangeImpl);
                myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.OTHER, string, element);
            }
        }
    }

    @Override
    public void unregisterActivityForRecovery(ActivityRecoveryChannel activityRecoveryChannel) {
        this._dao.deleteActivityRecovery(activityRecoveryChannel.export());
    }

    @Override
    public void recoverActivity(final String string, final long l, final String string2, final FaultData faultData) {
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            public void run() {
                ActivityRecoveryChannel activityRecoveryChannel = (ActivityRecoveryChannel)7.importChannel((String)string, ActivityRecoveryChannel.class);
                __log.info((Object)("ActivityRecovery: Recovering activity " + l + " with action " + string2 + " on channel " + activityRecoveryChannel));
                if (activityRecoveryChannel != null) {
                    if ("cancel".equals(string2)) {
                        activityRecoveryChannel.cancel();
                    } else if ("retry".equals(string2)) {
                        activityRecoveryChannel.retry();
                    } else if ("fault".equals(string2)) {
                        activityRecoveryChannel.fault(faultData);
                    }
                }
            }
        });
        this.execute();
    }

    @Override
    public String fetchMySessionId(PartnerLinkInstance partnerLinkInstance) {
        String string = this.fetchPartnerLinkDAO(partnerLinkInstance).getMySessionId();
        assert (string != null) : "Session ID should always be set!";
        return string;
    }

    @Override
    public String fetchPartnersSessionId(PartnerLinkInstance partnerLinkInstance) {
        return this.fetchPartnerLinkDAO(partnerLinkInstance).getPartnerSessionId();
    }

    @Override
    public void initializePartnersSessionId(PartnerLinkInstance partnerLinkInstance, String string) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("initializing partner " + partnerLinkInstance + "  sessionId to " + string));
        }
        this.fetchPartnerLinkDAO(partnerLinkInstance).setPartnerSessionId(string);
    }

    public void matcherEvent(String string, CorrelationKeySet correlationKeySet) {
        CorrelatorDAO correlatorDAO;
        List list;
        if (BpelProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("MatcherEvent handling: correlatorId=" + string + ", ckeySet=" + correlationKeySet));
        }
        if ((list = (correlatorDAO = this._dao.getProcess().getCorrelator(string)).findRoute(correlationKeySet)) == null || list.size() == 0) {
            __log.debug((Object)"MatcherEvent handling: nothing to do, route no longer in DB");
            return;
        }
        MessageExchangeDAO messageExchangeDAO = correlatorDAO.dequeueMessage(correlationKeySet);
        if (messageExchangeDAO != null) {
            __log.debug((Object)"MatcherEvent handling: found matching message in DB (i.e. message arrived before <receive>)");
            HashSet<String> hashSet = new HashSet<String>();
            for (MessageRouteDAO object : list) {
                hashSet.add(object.getGroupId());
                if (BpelProcess.__log.isDebugEnabled()) {
                    BpelProcess.__log.debug((Object)("SELECT: " + object.getGroupId() + ": matched to MESSAGE " + messageExchangeDAO + " on CKEYSET " + correlationKeySet));
                }
                MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, messageExchangeDAO);
                this.inputMsgMatch(object.getGroupId(), object.getIndex(), myRoleMessageExchangeImpl);
                this.execute();
            }
            for (String string2 : hashSet) {
                correlatorDAO.removeRoutes(string2, this._dao);
            }
            if (this._dao.getState() != 50) {
                messageExchangeDAO.release(true);
            }
        } else {
            __log.debug((Object)"MatcherEvent handling: nothing to do, no matching message in DB");
        }
    }

    @Override
    public Node readExtVar(OScope.Variable variable, Node node) throws ExternalVariableModuleException {
        ExternalVariableModule.Value value = this._bpelProcess.getEVM().read(variable, node, this._iid);
        return value.value;
    }

    @Override
    public BpelRuntimeContext.ValueReferencePair writeExtVar(OScope.Variable variable, Node node, Node node2) throws ExternalVariableModuleException {
        BpelRuntimeContext.ValueReferencePair valueReferencePair = new BpelRuntimeContext.ValueReferencePair();
        ExternalVariableModule.Value value = this._bpelProcess.getEVM().write(variable, node, node2, this._iid);
        valueReferencePair.reference = value.locator.reference;
        valueReferencePair.value = value.value;
        return valueReferencePair;
    }

    @Override
    public URI getBaseResourceURI() {
        return this._bpelProcess.getBaseResourceURI();
    }

    @Override
    public Node getProcessProperty(QName qName) {
        return this._bpelProcess.getProcessProperty(qName);
    }

    @Override
    public QName getProcessQName() {
        return this._bpelProcess.getProcessType();
    }
}

