/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.agents.memory.SizingAgent;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.InterceptorContextImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.NStateLatch;
import org.apache.ode.bpel.engine.PartnerLinkMyRoleImpl;
import org.apache.ode.bpel.engine.PartnerLinkPartnerRoleImpl;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.engine.ReplacementMapImpl;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.engine.extvar.ExternalVariableManager;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.intercept.InstanceCountThrottler;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.bpel.runtime.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.bpel.runtime.PropertyAliasEvaluationContext;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelProcess {
    static final Log __log = LogFactory.getLog(BpelProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private volatile Map<OPartnerLink, PartnerLinkPartnerRoleImpl> _partnerRoles;
    private volatile Map<OPartnerLink, PartnerLinkMyRoleImpl> _myRoles;
    private volatile Map<PartnerLinkMyRoleImpl, Endpoint> _endpointToMyRoleMap;
    private SharedEndpoints _sharedEps;
    private Map<Endpoint, EndpointReference> _myEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, EndpointReference> _partnerEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, PartnerRoleChannel> _partnerChannels = new HashMap<Endpoint, PartnerRoleChannel>();
    final QName _pid;
    private volatile OProcess _oprocess;
    private boolean _hydratedOnce = false;
    private volatile long _lastUsed;
    BpelEngineImpl _engine;
    DebuggerSupport _debugger;
    ExpressionLanguageRuntimeRegistry _expLangRuntimeRegistry;
    private ReplacementMap _replacementMap;
    final ProcessConf _pconf;
    private final List<MessageExchangeInterceptor> _mexInterceptors = new ArrayList<MessageExchangeInterceptor>();
    private HydrationLatch _hydrationLatch;
    private ExternalVariableConf _extVarConf;
    private ExternalVariableManager _evm;
    public static final QName PROP_PATH = new QName("PATH");
    public static final QName PROP_SVG = new QName("SVG");
    public static final QName PROP_LAZY_HYDRATE = new QName("process.hydration.lazy");
    public static final QName PROP_MAX_INSTANCES = new QName("process.instance.throttled.maximum.count");
    private static final int PROCESS_MEMORY_TO_SERIALIZED_SIZE_RATIO = 5;

    public BpelProcess(ProcessConf processConf) {
        this._pid = processConf.getProcessId();
        this._pconf = processConf;
        this._hydrationLatch = new HydrationLatch();
    }

    public URI getBaseResourceURI() {
        return this._pconf.getBaseURI();
    }

    void initExternalVariables() {
        List list = this._pconf.getExtensionElement(ExternalVariableConf.EXTVARCONF_ELEMENT);
        this._extVarConf = new ExternalVariableConf(list);
        this._evm = new ExternalVariableManager(this._pid, this._extVarConf, this._engine._contexts.externalVariableEngines, this._oprocess);
    }

    public String toString() {
        return "BpelProcess[" + this._pid + "]";
    }

    public ExternalVariableManager getEVM() {
        return this._evm;
    }

    public void recoverActivity(ProcessInstanceDAO processInstanceDAO, String string, long l, String string2, FaultData faultData) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Recovering activity in process " + processInstanceDAO.getInstanceId() + " with action " + string2));
        }
        this.markused();
        BpelRuntimeContextImpl bpelRuntimeContextImpl = this.createRuntimeContext(processInstanceDAO, null, null);
        bpelRuntimeContextImpl.recoverActivity(string, l, string2, faultData);
    }

    protected DebuggerSupport createDebuggerSupport() {
        return new DebuggerSupport(this);
    }

    protected DebuggerSupport getDebuggerSupport() {
        return this._debugger;
    }

    static String generateMessageExchangeIdentifier(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('.');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeProcess(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        boolean bl = false;
        try {
            this._hydrationLatch.latch(1);
            List<PartnerLinkMyRoleImpl> list = this.getMyRolesForService(myRoleMessageExchangeImpl.getServiceName());
            if (list.isEmpty()) {
                String string = __msgs.msgMyRoleRoutingFailure(myRoleMessageExchangeImpl.getMessageExchangeId());
                __log.error((Object)string);
                myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.UNKNOWN_ENDPOINT, string, null);
                return;
            }
            myRoleMessageExchangeImpl.getDAO().setProcess(this.getProcessDAO());
            if (!this.processInterceptors(myRoleMessageExchangeImpl, InterceptorInvoker.__onProcessInvoked)) {
                __log.debug((Object)("Aborting processing of mex " + myRoleMessageExchangeImpl + " due to interceptors."));
                return;
            }
            this.markused();
            List<PartnerLinkMyRoleImpl.RoutingInfo> list2 = null;
            for (PartnerLinkMyRoleImpl partnerLinkMyRoleImpl : list) {
                list2 = partnerLinkMyRoleImpl.findRoute(myRoleMessageExchangeImpl);
                boolean bl2 = partnerLinkMyRoleImpl.isCreateInstance(myRoleMessageExchangeImpl);
                if (myRoleMessageExchangeImpl.getStatus() != MessageExchange.Status.FAILURE) {
                    for (PartnerLinkMyRoleImpl.RoutingInfo routingInfo : list2) {
                        if (routingInfo.messageRoute == null && bl2) {
                            partnerLinkMyRoleImpl.invokeNewInstance(myRoleMessageExchangeImpl, routingInfo);
                            bl = true;
                            continue;
                        }
                        if (routingInfo.messageRoute == null) continue;
                        partnerLinkMyRoleImpl.invokeInstance(myRoleMessageExchangeImpl, routingInfo);
                        bl = true;
                    }
                }
                if (!bl) continue;
                break;
            }
            if (!bl) {
                list.get(list.size() - 1).noRoutingMatch(myRoleMessageExchangeImpl, list2);
            }
            if (myRoleMessageExchangeImpl.getStatus() == MessageExchange.Status.REQUEST) {
                myRoleMessageExchangeImpl.setStatus(MessageExchange.Status.ASYNC);
            }
            this.markused();
        }
        finally {
            this._hydrationLatch.release(1);
        }
        if (myRoleMessageExchangeImpl.getPattern().equals((Object)MessageExchange.MessageExchangePattern.REQUEST_ONLY) && bl) {
            myRoleMessageExchangeImpl.release();
        }
    }

    private List<PartnerLinkMyRoleImpl> getMyRolesForService(QName qName) {
        ArrayList<PartnerLinkMyRoleImpl> arrayList = new ArrayList<PartnerLinkMyRoleImpl>(5);
        for (Map.Entry<PartnerLinkMyRoleImpl, Endpoint> entry : this.getEndpointToMyRoleMap().entrySet()) {
            if (!entry.getValue().serviceName.equals(qName)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    void initMyRoleMex(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        this.markused();
        PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = null;
        for (Map.Entry<PartnerLinkMyRoleImpl, Endpoint> entry : this.getEndpointToMyRoleMap().entrySet()) {
            if (!entry.getValue().serviceName.equals(myRoleMessageExchangeImpl.getServiceName())) continue;
            partnerLinkMyRoleImpl = entry.getKey();
            break;
        }
        if (partnerLinkMyRoleImpl != null) {
            myRoleMessageExchangeImpl.setPortOp(partnerLinkMyRoleImpl._plinkDef.myRolePortType, partnerLinkMyRoleImpl._plinkDef.getMyRoleOperation(myRoleMessageExchangeImpl.getOperationName()));
        } else {
            __log.warn((Object)("Couldn't find endpoint from service " + myRoleMessageExchangeImpl.getServiceName() + " when initializing a myRole mex."));
        }
    }

    String extractProperty(Element element, OProcess.OPropertyAlias oPropertyAlias, String string) throws FaultException {
        this.markused();
        PropertyAliasEvaluationContext propertyAliasEvaluationContext = new PropertyAliasEvaluationContext(element, oPropertyAlias);
        Node node = propertyAliasEvaluationContext.getRootNode();
        if (oPropertyAlias.location != null) {
            try {
                node = this._expLangRuntimeRegistry.evaluateNode(oPropertyAlias.location, propertyAliasEvaluationContext);
            }
            catch (EvaluationException evaluationException) {
                throw new FaultException(this.getOProcess().constants.qnSelectionFailure, oPropertyAlias.getDescription());
            }
        }
        if (node == null) {
            String string2 = __msgs.msgPropertyAliasReturnedNullSet(oPropertyAlias.getDescription(), string);
            if (__log.isErrorEnabled()) {
                __log.error((Object)string2);
            }
            throw new FaultException(this.getOProcess().constants.qnSelectionFailure, string2);
        }
        if (node.getNodeType() == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                stringBuffer.append(node2.getNodeValue());
            }
            return stringBuffer.toString();
        }
        if (node.getNodeType() == 3) {
            return ((Text)node).getWholeText();
        }
        return null;
    }

    static QName getElementNameForPart(OMessageVarType.Part part) {
        return part.type instanceof OElementVarType ? ((OElementVarType)part.type).elementType : new QName(null, part.name);
    }

    public boolean processInterceptors(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl, InterceptorInvoker interceptorInvoker) {
        InterceptorContextImpl interceptorContextImpl = new InterceptorContextImpl(this._engine._contexts.dao.getConnection(), this.getProcessDAO(), this._pconf, this._engine, this);
        for (MessageExchangeInterceptor messageExchangeInterceptor : this._mexInterceptors) {
            if (myRoleMessageExchangeImpl.processInterceptor(messageExchangeInterceptor, myRoleMessageExchangeImpl, interceptorContextImpl, interceptorInvoker)) continue;
            return false;
        }
        for (MessageExchangeInterceptor messageExchangeInterceptor : this.getEngine().getGlobalInterceptors()) {
            if (myRoleMessageExchangeImpl.processInterceptor(messageExchangeInterceptor, myRoleMessageExchangeImpl, interceptorContextImpl, interceptorInvoker)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleWorkEvent(Map<String, Object> map) {
        try {
            WorkEvent workEvent;
            this._hydrationLatch.latch(1);
            this.markused();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)ObjectPrinter.stringifyMethodEnter((String)"handleWorkEvent", (Object[])new Object[]{"jobData", map}));
            }
            if ((workEvent = new WorkEvent(map)).getType().equals((Object)WorkEvent.Type.INVOKE_INTERNAL)) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("InvokeInternal event for mexid " + workEvent.getMexId()));
                }
                MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = (MyRoleMessageExchangeImpl)this._engine.getMessageExchange(workEvent.getMexId());
                this.invokeProcess(myRoleMessageExchangeImpl);
                return;
            }
            ProcessInstanceDAO processInstanceDAO = this.getProcessDAO().getInstance(workEvent.getIID());
            if (processInstanceDAO == null) {
                if (!__log.isDebugEnabled()) return;
                __log.debug((Object)("handleWorkEvent: no ProcessInstance found with iid " + workEvent.getIID() + "; ignoring."));
                return;
            }
            BpelRuntimeContextImpl bpelRuntimeContextImpl = this.createRuntimeContext(processInstanceDAO, null, null);
            switch (workEvent.getType()) {
                case TIMER: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("handleWorkEvent: TimerWork event for process instance " + bpelRuntimeContextImpl));
                    }
                    bpelRuntimeContextImpl.timerEvent(workEvent.getChannel());
                    return;
                }
                case RESUME: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("handleWorkEvent: ResumeWork event for iid " + workEvent.getIID()));
                    }
                    bpelRuntimeContextImpl.execute();
                    return;
                }
                case INVOKE_RESPONSE: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("InvokeResponse event for iid " + workEvent.getIID()));
                    }
                    bpelRuntimeContextImpl.invocationResponse(workEvent.getMexId(), workEvent.getChannel());
                    bpelRuntimeContextImpl.execute();
                    return;
                }
                case MATCHER: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Matcher event for iid " + workEvent.getIID()));
                    }
                    if (processInstanceDAO.getState() != 30 && processInstanceDAO.getState() != 40) {
                        bpelRuntimeContextImpl.matcherEvent(workEvent.getCorrelatorId(), workEvent.getCorrelationKeySet());
                        return;
                    }
                    __log.debug((Object)"A matcher event was aborted. The process is already completed.");
                    return;
                }
            }
            return;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private void setRoles(OProcess oProcess) {
        OPartnerLink oPartnerLink;
        this._partnerRoles = new HashMap<OPartnerLink, PartnerLinkPartnerRoleImpl>();
        this._myRoles = new HashMap<OPartnerLink, PartnerLinkMyRoleImpl>();
        this._endpointToMyRoleMap = new HashMap<PartnerLinkMyRoleImpl, Endpoint>();
        HashMap hashMap = new HashMap();
        for (Map.Entry object : this._pconf.getProvideEndpoints().entrySet()) {
            oPartnerLink = oProcess.getPartnerLink((String)object.getKey());
            if (oPartnerLink == null) {
                String string = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)object.getKey();
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            hashMap.put(oPartnerLink, object.getValue());
        }
        for (Map.Entry entry : this._pconf.getInvokeEndpoints().entrySet()) {
            oPartnerLink = oProcess.getPartnerLink((String)entry.getKey());
            if (oPartnerLink == null) {
                String string = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)entry.getKey();
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            __log.debug((Object)("Processing <invoke> element for process " + this._pid + ": partnerlink " + (String)entry.getKey() + " --> " + entry.getValue()));
        }
        for (OPartnerLink oPartnerLink2 : oProcess.getAllPartnerLinks()) {
            PartnerLinkRoleImpl partnerLinkRoleImpl;
            if (oPartnerLink2.hasMyRole()) {
                oPartnerLink = (Endpoint)hashMap.get(oPartnerLink2);
                if (oPartnerLink == null) {
                    throw new IllegalArgumentException("No service name for myRole plink " + oPartnerLink2.getName());
                }
                partnerLinkRoleImpl = new PartnerLinkMyRoleImpl(this, oPartnerLink2, (Endpoint)oPartnerLink);
                this._myRoles.put(oPartnerLink2, (PartnerLinkMyRoleImpl)partnerLinkRoleImpl);
                this._endpointToMyRoleMap.put((PartnerLinkMyRoleImpl)partnerLinkRoleImpl, (Endpoint)oPartnerLink);
            }
            if (!oPartnerLink2.hasPartnerRole()) continue;
            oPartnerLink = (Endpoint)this._pconf.getInvokeEndpoints().get(oPartnerLink2.getName());
            if (oPartnerLink == null && oPartnerLink2.initializePartnerRole) {
                throw new IllegalArgumentException(oPartnerLink2.getName() + " must be bound to an endpoint in deploy.xml");
            }
            partnerLinkRoleImpl = new PartnerLinkPartnerRoleImpl(this, oPartnerLink2, (Endpoint)oPartnerLink);
            this._partnerRoles.put(oPartnerLink2, (PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl);
        }
    }

    protected ProcessDAO getProcessDAO() {
        return this._pconf.isTransient() ? this._engine._contexts.inMemDao.getConnection().getProcess(this._pid) : this.getEngine()._contexts.dao.getConnection().getProcess(this._pid);
    }

    static String genCorrelatorId(OPartnerLink oPartnerLink, String string) {
        return oPartnerLink.getName() + "." + string;
    }

    private OProcess deserializeCompiledProcess(InputStream inputStream) throws Exception {
        Serializer serializer = new Serializer(inputStream);
        OProcess oProcess = serializer.readOProcess();
        return oProcess;
    }

    public Set<Endpoint> getServiceNames() {
        HashSet<Endpoint> hashSet = new HashSet<Endpoint>();
        for (Endpoint endpoint : this._pconf.getProvideEndpoints().values()) {
            hashSet.add(endpoint);
        }
        return hashSet;
    }

    void activate(BpelEngineImpl bpelEngineImpl) {
        this._engine = bpelEngineImpl;
        this._sharedEps = this._engine.getSharedEndpoints();
        this._debugger = this.createDebuggerSupport();
        if (this.getInstanceMaximumCount() < Integer.MAX_VALUE) {
            this.registerMessageExchangeInterceptor(new InstanceCountThrottler());
        }
        __log.debug((Object)("Activating " + this._pid));
        for (Map.Entry entry : this._pconf.getProvideEndpoints().entrySet()) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            EndpointReference endpointReference = null;
            if (this.isShareable(endpoint)) {
                endpointReference = this._sharedEps.getEndpointReference(endpoint);
                if (endpointReference == null) {
                    endpointReference = this._engine._contexts.bindingContext.activateMyRoleEndpoint(this._pid, endpoint);
                    this._sharedEps.addEndpoint(endpoint, endpointReference);
                    __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + endpointReference));
                }
                this._sharedEps.incrementReferenceCount(endpoint);
            } else {
                endpointReference = this._engine._contexts.bindingContext.activateMyRoleEndpoint(this._pid, endpoint);
                __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + endpointReference));
            }
            this._myEprs.put(endpoint, endpointReference);
        }
        __log.debug((Object)("Activated " + this._pid));
        this.markused();
    }

    void deactivate() {
        for (Endpoint endpoint : this._myEprs.keySet()) {
            if (this.isShareable(endpoint)) {
                __log.debug((Object)("deactivating shared endpoint " + endpoint));
                if (this._sharedEps.decrementReferenceCount(endpoint)) continue;
                this._engine._contexts.bindingContext.deactivateMyRoleEndpoint(endpoint);
                this._sharedEps.removeEndpoint(endpoint);
                continue;
            }
            __log.debug((Object)("deactivating non-shared endpoint " + endpoint));
            this._engine._contexts.bindingContext.deactivateMyRoleEndpoint(endpoint);
        }
    }

    private boolean isShareable(Endpoint endpoint) {
        return this._pconf.isSharedService(endpoint.serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EndpointReference getInitialPartnerRoleEPR(OPartnerLink oPartnerLink) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(oPartnerLink);
            if (partnerLinkPartnerRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + oPartnerLink);
            }
            EndpointReference endpointReference = partnerLinkPartnerRoleImpl.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint getInitialPartnerRoleEndpoint(OPartnerLink oPartnerLink) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(oPartnerLink);
            if (partnerLinkPartnerRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + oPartnerLink);
            }
            Endpoint endpoint = partnerLinkPartnerRoleImpl._initialPartner;
            return endpoint;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EndpointReference getInitialMyRoleEPR(OPartnerLink oPartnerLink) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = this._myRoles.get(oPartnerLink);
            if (partnerLinkMyRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + oPartnerLink);
            }
            EndpointReference endpointReference = partnerLinkMyRoleImpl.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public QName getPID() {
        return this._pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartnerRoleChannel getPartnerRoleChannel(OPartnerLink oPartnerLink) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(oPartnerLink);
            if (partnerLinkPartnerRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + oPartnerLink);
            }
            PartnerRoleChannel partnerRoleChannel = partnerLinkPartnerRoleImpl._channel;
            return partnerRoleChannel;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public void saveEvent(ProcessInstanceEvent processInstanceEvent, ProcessInstanceDAO processInstanceDAO) {
        this.saveEvent(processInstanceEvent, processInstanceDAO, null);
    }

    public void saveEvent(ProcessInstanceEvent processInstanceEvent, ProcessInstanceDAO processInstanceDAO, List<String> list) {
        this.markused();
        if (this._pconf.isEventEnabled(list, processInstanceEvent.getType())) {
            this._engine.fireEvent((BpelEvent)processInstanceEvent);
            if (processInstanceDAO != null) {
                processInstanceDAO.insertBpelEvent(processInstanceEvent);
            } else {
                __log.debug((Object)"Couldn't find instance to save event, no event generated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dehydrate() {
        try {
            this._hydrationLatch.latch(0);
        }
        finally {
            this._hydrationLatch.release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hydrate() {
        try {
            this._hydrationLatch.latch(1);
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProcess getOProcess() {
        try {
            this._hydrationLatch.latch(1);
            OProcess oProcess = this._oprocess;
            return oProcess;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PartnerLinkMyRoleImpl, Endpoint> getEndpointToMyRoleMap() {
        try {
            this._hydrationLatch.latch(1);
            Map<PartnerLinkMyRoleImpl, Endpoint> map = this._endpointToMyRoleMap;
            return map;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public ReplacementMap getReplacementMap(QName qName) {
        try {
            this._hydrationLatch.latch(1);
            if (qName.equals(this._pid)) {
                ReplacementMap replacementMap = this._replacementMap;
                return replacementMap;
            }
            OProcess oProcess = this._engine.getOProcess(qName);
            if (oProcess == null) {
                String string = "The process " + this._pid + " is not available anymore.";
                __log.error((Object)string);
                throw new InvalidProcessException(string, 1);
            }
            this.registerExprLang(oProcess);
            ReplacementMapImpl replacementMapImpl = new ReplacementMapImpl(oProcess);
            return replacementMapImpl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    protected BpelEngineImpl getEngine() {
        return this._engine;
    }

    public boolean isInMemory() {
        return this._pconf.isTransient();
    }

    public long getLastUsed() {
        return this._lastUsed;
    }

    QName getProcessType() {
        return this._pconf.getType();
    }

    public boolean hintIsHydrated() {
        return this._oprocess != null;
    }

    private final void markused() {
        this._lastUsed = System.currentTimeMillis();
    }

    protected BpelRuntimeContextImpl createRuntimeContext(ProcessInstanceDAO processInstanceDAO, PROCESS pROCESS, MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        return new BpelRuntimeContextImpl(this, processInstanceDAO, pROCESS, myRoleMessageExchangeImpl);
    }

    private void bounceProcessDAOInMemory(BpelDAOConnection bpelDAOConnection, QName qName, long l, OProcess oProcess) {
        if (__log.isInfoEnabled()) {
            __log.info((Object)("Creating new process DAO[mem] for " + qName + " (guid=" + oProcess.guid + ")."));
        }
        this.createProcessDAO(bpelDAOConnection, qName, l, oProcess);
    }

    private void bounceProcessDAOInDB(BpelDAOConnection bpelDAOConnection, QName qName, long l, OProcess oProcess) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creating new process DAO for " + qName + " (guid=" + oProcess.guid + ")..."));
        }
        this.createProcessDAO(bpelDAOConnection, qName, l, oProcess);
        if (__log.isInfoEnabled()) {
            __log.info((Object)("Created new process DAO for " + qName + " (guid=" + oProcess.guid + ")."));
        }
    }

    public int getInstanceInUseCount() {
        return this.hintIsHydrated() ? this._hydrationLatch.getDepth(1) : 0;
    }

    private void createProcessDAO(BpelDAOConnection bpelDAOConnection, QName qName, long l, OProcess oProcess) {
        try {
            boolean bl = true;
            ProcessDAO processDAO = bpelDAOConnection.getProcess(qName);
            if (processDAO != null) {
                __log.debug((Object)("Found ProcessDAO for " + qName + " with GUID " + processDAO.getGuid()));
                if (oProcess.guid == null) {
                    bl = false;
                } else if (processDAO.getGuid().equals(oProcess.guid)) {
                    bl = false;
                }
            }
            if (bl) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Creating process DAO for " + qName + " (guid=" + oProcess.guid + ")"));
                }
                ProcessDAO processDAO2 = bpelDAOConnection.createProcess(qName, oProcess.getQName(), oProcess.guid, (long)((int)l));
                for (String string : oProcess.getCorrelators()) {
                    processDAO2.addCorrelator(string);
                }
                if (__log.isInfoEnabled()) {
                    __log.info((Object)("Created new process DAO for " + qName + " (guid=" + oProcess.guid + ")"));
                }
            }
        }
        catch (BpelEngineException bpelEngineException) {
            throw bpelEngineException;
        }
        catch (Exception exception) {
            __log.error((Object)"DbError", (Throwable)exception);
            throw new BpelEngineException("DbError", (Throwable)exception);
        }
    }

    private void registerExprLang(OProcess oProcess) {
        for (OExpressionLanguage oExpressionLanguage : oProcess.expressionLanguages) {
            try {
                this._expLangRuntimeRegistry.registerRuntime(oExpressionLanguage);
            }
            catch (ConfigurationException configurationException) {
                String string = __msgs.msgExpLangRegistrationError(oExpressionLanguage.expressionLanguageUri, oExpressionLanguage.properties);
                __log.error((Object)string, (Throwable)configurationException);
                throw new BpelEngineException(string, (Throwable)configurationException);
            }
        }
    }

    public boolean isCleanupCategoryEnabled(boolean bl, ProcessConf.CLEANUP_CATEGORY cLEANUP_CATEGORY) {
        return this._pconf.isCleanupCategoryEnabled(bl, cLEANUP_CATEGORY);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean bl) {
        return this._pconf.getCleanupCategories(bl);
    }

    public Node getProcessProperty(QName qName) {
        Map map = this._pconf.getProcessProperties();
        if (map != null) {
            return (Node)map.get(qName);
        }
        return null;
    }

    public ProcessConf getConf() {
        return this._pconf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveInstances() {
        try {
            this._hydrationLatch.latch(1);
            if (this.isInMemory() || this._engine._contexts.scheduler.isTransacted()) {
                boolean bl = this.hasActiveInstances(this.getProcessDAO());
                return bl;
            }
            boolean bl = (Boolean)this._engine._contexts.scheduler.execTransaction((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return BpelProcess.this.hasActiveInstances(BpelProcess.this.getProcessDAO());
                }
            });
            return bl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private boolean hasActiveInstances(ProcessDAO processDAO) {
        return processDAO.getNumInstances() > 0;
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._mexInterceptors.add(messageExchangeInterceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._mexInterceptors.remove(messageExchangeInterceptor);
    }

    public long sizeOf() {
        long l = SizingAgent.deepSizeOf((Object)this);
        if (l == 0L) {
            l = this.getEstimatedHydratedSize();
        }
        for (EndpointReference endpointReference : this._myEprs.values()) {
            l += this._engine._contexts.bindingContext.calculateSizeofService(endpointReference);
        }
        return l;
    }

    public String getProcessProperty(QName qName, String string) {
        Text text = (Text)this.getProcessProperty(qName);
        if (text == null) {
            return string;
        }
        String string2 = text.getWholeText();
        return string2 == null ? string : string2;
    }

    public boolean isHydrationLazy() {
        return Boolean.valueOf(this.getProcessProperty(PROP_LAZY_HYDRATE, "true"));
    }

    public boolean isHydrationLazySet() {
        return this.getProcessProperty(PROP_LAZY_HYDRATE) != null;
    }

    public int getInstanceMaximumCount() {
        return Integer.valueOf(this.getProcessProperty(PROP_MAX_INSTANCES, Integer.toString(this._engine.getInstanceThrottledMaximumCount())));
    }

    public long getEstimatedHydratedSize() {
        return this._pconf.getCBPFileSize() * 5L;
    }

    public long getTimeout(OPartnerLink oPartnerLink) {
        long l;
        block3: {
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(oPartnerLink);
            l = 120000L;
            String string = (String)this._pconf.getEndpointProperties(partnerLinkPartnerRoleImpl._initialEPR).get("mex.timeout");
            if (string != null) {
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!__log.isWarnEnabled()) break block3;
                    __log.warn((Object)("Mal-formatted Property: [mex.timeout=" + string + "] Default value (" + l + ") will be used"));
                }
            }
        }
        return l;
    }

    private class HydrationLatch
    extends NStateLatch {
        HydrationLatch() {
            super(new Runnable[2]);
            this._transitions[0] = new Runnable(){

                public void run() {
                    HydrationLatch.this.doDehydrate();
                }
            };
            this._transitions[1] = new Runnable(){

                public void run() {
                    HydrationLatch.this.doHydrate();
                }
            };
        }

        private void doDehydrate() {
            if (BpelProcess.this._oprocess != null) {
                BpelProcess.this._oprocess.dehydrate();
                BpelProcess.this._oprocess = null;
            }
            if (BpelProcess.this._myRoles != null) {
                BpelProcess.this._myRoles.clear();
            }
            if (BpelProcess.this._endpointToMyRoleMap != null) {
                BpelProcess.this._endpointToMyRoleMap.clear();
            }
            if (BpelProcess.this._partnerRoles != null) {
                BpelProcess.this._partnerRoles.clear();
            }
            BpelProcess.this._replacementMap = null;
            BpelProcess.this._expLangRuntimeRegistry = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHydrate() {
            BpelProcess.this.markused();
            __log.debug((Object)("Rehydrating process " + BpelProcess.this._pconf.getProcessId()));
            try {
                Iterator iterator = BpelProcess.this._pconf.getCBPInputStream();
                try {
                    BpelProcess.this._oprocess = BpelProcess.this.deserializeCompiledProcess((InputStream)((Object)iterator));
                }
                finally {
                    ((InputStream)((Object)iterator)).close();
                }
            }
            catch (Exception exception) {
                String string = "The process " + BpelProcess.this._pid + " is no longer available.";
                __log.error((Object)string, (Throwable)exception);
                throw new BpelEngineException(string, (Throwable)exception);
            }
            if (BpelProcess.this._partnerRoles == null) {
                BpelProcess.this._partnerRoles = new HashMap();
            }
            if (BpelProcess.this._myRoles == null) {
                BpelProcess.this._myRoles = new HashMap();
            }
            if (BpelProcess.this._endpointToMyRoleMap == null) {
                BpelProcess.this._endpointToMyRoleMap = new HashMap();
            }
            if (BpelProcess.this._myEprs == null) {
                BpelProcess.this._myEprs = new HashMap();
            }
            if (BpelProcess.this._partnerChannels == null) {
                BpelProcess.this._partnerChannels = new HashMap();
            }
            if (BpelProcess.this._partnerEprs == null) {
                BpelProcess.this._partnerEprs = new HashMap();
            }
            BpelProcess.this._replacementMap = new ReplacementMapImpl(BpelProcess.this._oprocess);
            BpelProcess.this._expLangRuntimeRegistry = new ExpressionLanguageRuntimeRegistry();
            BpelProcess.this.registerExprLang(BpelProcess.this._oprocess);
            BpelProcess.this.setRoles(BpelProcess.this._oprocess);
            BpelProcess.this.initExternalVariables();
            if (!BpelProcess.this._hydratedOnce) {
                for (PartnerLinkRoleImpl partnerLinkRoleImpl : BpelProcess.this._partnerRoles.values()) {
                    PartnerRoleChannel partnerRoleChannel;
                    if (((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner == null) continue;
                    ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._channel = partnerRoleChannel = BpelProcess.this._engine._contexts.bindingContext.createPartnerRoleChannel(BpelProcess.this._pid, ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._plinkDef.partnerRolePortType, ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner);
                    BpelProcess.this._partnerChannels.put(((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner, ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._channel);
                    EndpointReference endpointReference = partnerRoleChannel.getInitialEndpointReference();
                    if (endpointReference != null) {
                        ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialEPR = endpointReference;
                        BpelProcess.this._partnerEprs.put(((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner, endpointReference);
                    }
                    __log.debug((Object)("Activated " + BpelProcess.this._pid + " partnerrole " + partnerLinkRoleImpl.getPartnerLinkName() + ": EPR is " + ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialEPR));
                }
                BpelProcess.this._engine.setProcessSize(BpelProcess.this._pid, true);
                BpelProcess.this._hydratedOnce = true;
            }
            for (PartnerLinkRoleImpl partnerLinkRoleImpl : BpelProcess.this._myRoles.values()) {
                ((PartnerLinkMyRoleImpl)partnerLinkRoleImpl)._initialEPR = (EndpointReference)BpelProcess.this._myEprs.get(((PartnerLinkMyRoleImpl)partnerLinkRoleImpl)._endpoint);
            }
            for (PartnerLinkRoleImpl partnerLinkRoleImpl : BpelProcess.this._partnerRoles.values()) {
                ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._channel = (PartnerRoleChannel)BpelProcess.this._partnerChannels.get(((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner);
                if (BpelProcess.this._partnerEprs.get(((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner) == null) continue;
                ((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialEPR = (EndpointReference)BpelProcess.this._partnerEprs.get(((PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl)._initialPartner);
            }
            if (BpelProcess.this.isInMemory()) {
                BpelProcess.this.createProcessDAO(BpelProcess.this._engine._contexts.inMemDao.getConnection(), BpelProcess.this._pid, BpelProcess.this._pconf.getVersion(), BpelProcess.this._oprocess);
            } else if (BpelProcess.this._engine._contexts.scheduler.isTransacted()) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Creating new process DAO for " + BpelProcess.this._pid + " (guid=" + ((BpelProcess)BpelProcess.this)._oprocess.guid + ")..."));
                }
                BpelProcess.this.createProcessDAO(BpelProcess.this._engine._contexts.dao.getConnection(), BpelProcess.this._pid, BpelProcess.this._pconf.getVersion(), BpelProcess.this._oprocess);
                if (__log.isInfoEnabled()) {
                    __log.info((Object)("Created new process DAO for " + BpelProcess.this._pid + " (guid=" + ((BpelProcess)BpelProcess.this)._oprocess.guid + ")."));
                }
            } else {
                try {
                    BpelProcess.this._engine._contexts.scheduler.execTransaction((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            BpelProcess.this.bounceProcessDAOInDB(BpelProcess.this._engine._contexts.dao.getConnection(), BpelProcess.this._pid, BpelProcess.this._pconf.getVersion(), BpelProcess.this._oprocess);
                            return null;
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }
}

