/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BrokeredMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.InstanceLockManager;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.BpelEngine;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.intercept.ProcessCountThrottler;
import org.apache.ode.bpel.intercept.ProcessSizeThrottler;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelEngineImpl
implements BpelEngine {
    private static final Log __log = LogFactory.getLog(BpelEngineImpl.class);
    private Random _random = new Random(System.currentTimeMillis());
    private static double _delayMean = 0.0;
    private static final Messages __msgs;
    private static final double PROCESS_OVERHEAD_MEMORY_FACTOR = 1.2;
    final HashMap<QName, BpelProcess> _activeProcesses = new HashMap();
    private final HashMap<Endpoint, List<BpelProcess>> _serviceMap = new HashMap();
    private SharedEndpoints _sharedEps;
    private final InstanceLockManager _instanceLockManager = new InstanceLockManager();
    final Contexts _contexts;
    private final Map<QName, Long> _hydratedSizes = new HashMap<QName, Long>();
    private final Map<QName, Long> _unhydratedSizes = new HashMap<QName, Long>();
    private long _processThrottledMaximumSize = Long.MAX_VALUE;
    private int _processThrottledMaximumCount = Integer.MAX_VALUE;
    private int _instanceThrottledMaximumCount = Integer.MAX_VALUE;
    private boolean _hydrationThrottled = false;

    public BpelEngineImpl(Contexts contexts) {
        this._contexts = contexts;
        this._sharedEps = new SharedEndpoints();
        this._sharedEps.init();
    }

    public SharedEndpoints getSharedEndpoints() {
        return this._sharedEps;
    }

    public MyRoleMessageExchange createMessageExchange(String string, QName qName, String string2, String string3) throws BpelEngineException {
        List<BpelProcess> list = this.route(qName, null);
        if (list == null || list.size() == 0) {
            throw new BpelEngineException("NoSuchService: " + qName);
        }
        if (list.size() == 1) {
            BpelProcess bpelProcess = list.get(0);
            return this.createNewMyRoleMex(bpelProcess, string, qName, string2, string3);
        }
        BpelProcess bpelProcess = list.get(0);
        ArrayList<MyRoleMessageExchange> arrayList = new ArrayList<MyRoleMessageExchange>();
        for (BpelProcess bpelProcess2 : list) {
            arrayList.add(this.createNewMyRoleMex(bpelProcess2, string, qName, string2, string3));
        }
        return this.createNewMyRoleMex(bpelProcess, arrayList);
    }

    private MyRoleMessageExchange createNewMyRoleMex(BpelProcess bpelProcess, String string, QName qName, String string2, String string3) {
        MessageExchangeDAO messageExchangeDAO = bpelProcess == null || bpelProcess.isInMemory() ? this._contexts.inMemDao.getConnection().createMessageExchange('M') : this._contexts.dao.getConnection().createMessageExchange('M');
        messageExchangeDAO.setCorrelationId(string);
        messageExchangeDAO.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.UKNOWN_ENDPOINT.toString());
        messageExchangeDAO.setPattern(MessageExchange.MessageExchangePattern.UNKNOWN.toString());
        messageExchangeDAO.setCallee(qName);
        messageExchangeDAO.setStatus(MessageExchange.Status.NEW.toString());
        messageExchangeDAO.setOperation(string2);
        messageExchangeDAO.setPipedMessageExchangeId(string3);
        MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = new MyRoleMessageExchangeImpl(bpelProcess, this, messageExchangeDAO);
        if (bpelProcess != null) {
            bpelProcess.initMyRoleMex(myRoleMessageExchangeImpl);
        }
        return myRoleMessageExchangeImpl;
    }

    private MyRoleMessageExchange createNewMyRoleMex(BpelProcess bpelProcess, List<MyRoleMessageExchange> list) throws BpelEngineException {
        MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = (MyRoleMessageExchangeImpl)list.get(0);
        MessageExchangeDAO messageExchangeDAO = myRoleMessageExchangeImpl.getDAO();
        return new BrokeredMyRoleMessageExchangeImpl(bpelProcess, this, list, messageExchangeDAO, myRoleMessageExchangeImpl);
    }

    public MyRoleMessageExchange createMessageExchange(String string, QName qName, String string2) {
        return this.createMessageExchange(string, qName, string2, null);
    }

    private void setMessageExchangeProcess(String string, ProcessDAO processDAO) {
        MessageExchangeDAO messageExchangeDAO = this._contexts.inMemDao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            messageExchangeDAO = this._contexts.dao.getConnection().getMessageExchange(string);
        }
        if (messageExchangeDAO != null) {
            messageExchangeDAO.setProcess(processDAO);
        }
    }

    public MessageExchange getMessageExchange(String string) {
        MessageExchangeImpl messageExchangeImpl;
        MessageExchangeDAO messageExchangeDAO = this._contexts.inMemDao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            messageExchangeDAO = this._contexts.dao.getConnection().getMessageExchange(string);
        }
        if (messageExchangeDAO == null) {
            return null;
        }
        ProcessDAO processDAO = messageExchangeDAO.getProcess();
        BpelProcess bpelProcess = processDAO == null ? null : this._activeProcesses.get(processDAO.getProcessId());
        switch (messageExchangeDAO.getDirection()) {
            case 'P': {
                if (bpelProcess == null) {
                    String string2 = __msgs.msgProcessNotActive(processDAO.getProcessId());
                    __log.error((Object)string2);
                    throw new BpelEngineException(string2);
                }
                OPartnerLink oPartnerLink = (OPartnerLink)bpelProcess.getOProcess().getChild(messageExchangeDAO.getPartnerLinkModelId());
                PortType portType = oPartnerLink.partnerRolePortType;
                Operation operation = oPartnerLink.getPartnerRoleOperation(messageExchangeDAO.getOperation());
                messageExchangeImpl = this.createPartnerRoleMessageExchangeImpl(messageExchangeDAO, portType, operation, oPartnerLink, bpelProcess);
                break;
            }
            case 'M': {
                OPartnerLink oPartnerLink;
                messageExchangeImpl = new MyRoleMessageExchangeImpl(bpelProcess, this, messageExchangeDAO);
                if (bpelProcess == null || (oPartnerLink = (OPartnerLink)bpelProcess.getOProcess().getChild(messageExchangeDAO.getPartnerLinkModelId())) == null) break;
                PortType portType = oPartnerLink.myRolePortType;
                Operation operation = oPartnerLink.getMyRoleOperation(messageExchangeDAO.getOperation());
                messageExchangeImpl.setPortOp(portType, operation);
                break;
            }
            default: {
                String string3 = "BpelEngineImpl: internal error, invalid MexDAO direction: " + string;
                __log.fatal((Object)string3);
                throw new BpelEngineException(string3);
            }
        }
        return messageExchangeImpl;
    }

    protected PartnerRoleMessageExchangeImpl createPartnerRoleMessageExchangeImpl(MessageExchangeDAO messageExchangeDAO, PortType portType, Operation operation, OPartnerLink oPartnerLink, BpelProcess bpelProcess) {
        return new PartnerRoleMessageExchangeImpl(this, messageExchangeDAO, portType, operation, null, oPartnerLink.hasMyRole() ? bpelProcess.getInitialMyRoleEPR(oPartnerLink) : null, bpelProcess.getPartnerRoleChannel(oPartnerLink));
    }

    BpelProcess unregisterProcess(QName qName) {
        BpelProcess bpelProcess = this._activeProcesses.remove(qName);
        __log.debug((Object)("Unregister process: serviceId=" + qName + ", process=" + bpelProcess));
        if (bpelProcess != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Deactivating process " + bpelProcess.getPID()));
            }
            for (Map.Entry<Endpoint, List<BpelProcess>> entry : this._serviceMap.entrySet()) {
                Iterator<BpelProcess> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    BpelProcess bpelProcess2 = iterator.next();
                    if (!bpelProcess2.getPID().equals(qName)) continue;
                    iterator.remove();
                }
            }
            bpelProcess.deactivate();
            bpelProcess.dehydrate();
            this._hydratedSizes.remove(bpelProcess.getPID());
        }
        return bpelProcess;
    }

    boolean isProcessRegistered(QName qName) {
        return this._activeProcesses.containsKey(qName);
    }

    public BpelProcess getProcess(QName qName) {
        return this._activeProcesses.get(qName);
    }

    void registerProcess(BpelProcess bpelProcess) {
        this._activeProcesses.put(bpelProcess.getPID(), bpelProcess);
        for (Endpoint endpoint : bpelProcess.getServiceNames()) {
            __log.debug((Object)("Register process: serviceId=" + endpoint + ", process=" + bpelProcess));
            List<BpelProcess> list = this._serviceMap.get(endpoint);
            if (list == null) {
                list = new ArrayList<BpelProcess>();
                this._serviceMap.put(endpoint, list);
            }
            Iterator<BpelProcess> iterator = list.iterator();
            while (iterator.hasNext()) {
                BpelProcess bpelProcess2 = iterator.next();
                __log.debug((Object)("cached version " + bpelProcess2.getPID() + " vs registering version " + bpelProcess.getPID()));
                if (!bpelProcess2.getProcessType().equals(bpelProcess.getProcessType())) continue;
                iterator.remove();
                bpelProcess2.deactivate();
            }
            list.add(bpelProcess);
        }
        bpelProcess.activate(this);
    }

    List<BpelProcess> route(QName qName, Message message) {
        List<BpelProcess> list = null;
        for (Endpoint endpoint : this._serviceMap.keySet()) {
            if (!endpoint.serviceName.equals(qName)) continue;
            list = this._serviceMap.get(endpoint);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Routed: svcQname " + qName + " --> " + list));
        }
        return list;
    }

    OProcess getOProcess(QName qName) {
        BpelProcess bpelProcess = this._activeProcesses.get(qName);
        if (bpelProcess == null) {
            return null;
        }
        return bpelProcess.getOProcess();
    }

    public void onScheduledJob(Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        final WorkEvent workEvent = new WorkEvent(jobInfo.jobDetail);
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("[JOB] onScheduledJob " + jobInfo + "" + workEvent.getIID()));
        }
        try {
            this._instanceLockManager.lock(workEvent.getIID(), 1, TimeUnit.MICROSECONDS);
            this._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean bl) {
                    BpelEngineImpl.this._instanceLockManager.unlock(workEvent.getIID());
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (InterruptedException interruptedException) {
            __log.debug((Object)("Thread interrupted, job will be rescheduled: " + jobInfo));
            throw new Scheduler.JobProcessorException(true);
        }
        catch (InstanceLockManager.TimeoutException timeoutException) {
            __log.debug((Object)("Instance " + workEvent.getIID() + " is busy, rescheduling job."));
            this._contexts.scheduler.schedulePersistedJob(jobInfo.jobDetail, new Date(System.currentTimeMillis() + Math.min(this.randomExp(1000.0), 10000L)));
            return;
        }
        BpelProcess bpelProcess = null;
        try {
            Object object;
            if (workEvent.getProcessId() != null) {
                bpelProcess = this._activeProcesses.get(workEvent.getProcessId());
            } else {
                object = workEvent.isInMem() ? this._contexts.inMemDao.getConnection().getInstance(workEvent.getIID()) : this._contexts.dao.getConnection().getInstance(workEvent.getIID());
                if (object == null) {
                    __log.debug((Object)__msgs.msgScheduledJobReferencesUnknownInstance(workEvent.getIID()));
                    return;
                }
                ProcessDAO processDAO = object.getProcess();
                bpelProcess = this._activeProcesses.get(processDAO.getProcessId());
            }
            if (bpelProcess == null) {
                __log.debug((Object)("Process " + workEvent.getProcessId() + " can't be found, job abandoned."));
                return;
            }
            if (workEvent.getType().equals((Object)WorkEvent.Type.INVOKE_CHECK)) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("handleWorkEvent: InvokeCheck event for mexid " + workEvent.getMexId()));
                }
                this.sendPartnerRoleFailure(workEvent, MessageExchange.FailureType.COMMUNICATION_ERROR);
                return;
            }
            if (workEvent.getType().equals((Object)WorkEvent.Type.INVOKE_INTERNAL)) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("handleWorkEvent: InvokeInternal event for mexid " + workEvent.getMexId()));
                }
                this.setMessageExchangeProcess(workEvent.getMexId(), bpelProcess.getProcessDAO());
                object = (MyRoleMessageExchangeImpl)this.getMessageExchange(workEvent.getMexId());
                if (!bpelProcess.processInterceptors((MyRoleMessageExchangeImpl)object, InterceptorInvoker.__onJobScheduled)) {
                    boolean bl = Boolean.valueOf(((MessageExchangeImpl)object).getProperty("isTwoWay"));
                    if (bl) {
                        String string = ((MessageExchangeImpl)object).getProperty("causeCode");
                        ((MessageExchangeImpl)object).getDAO().setProcess(bpelProcess.getProcessDAO());
                        this.sendMyRoleFault(bpelProcess, workEvent, string != null ? Integer.valueOf(string) : 0);
                        return;
                    }
                    throw new Scheduler.JobProcessorException(this.checkRetry(jobInfo, null));
                }
            }
            bpelProcess.handleWorkEvent(jobInfo.jobDetail);
            this.debuggingDelay();
        }
        catch (BpelEngineException bpelEngineException) {
            __log.error((Object)__msgs.msgScheduledJobFailed(workEvent.getDetail()), (Throwable)bpelEngineException);
            throw new Scheduler.JobProcessorException((Throwable)bpelEngineException, this.checkRetry(jobInfo, bpelEngineException));
        }
        catch (ContextException contextException) {
            __log.error((Object)__msgs.msgScheduledJobFailed(workEvent.getDetail()), (Throwable)contextException);
            throw new Scheduler.JobProcessorException((Throwable)contextException, this.checkRetry(jobInfo, contextException));
        }
        catch (InvalidProcessException invalidProcessException) {
            __log.error((Object)__msgs.msgScheduledJobFailed(workEvent.getDetail()), (Throwable)invalidProcessException);
            this.sendMyRoleFault(bpelProcess, workEvent, invalidProcessException.getCauseCode());
        }
        catch (RuntimeException runtimeException) {
            __log.error((Object)__msgs.msgScheduledJobFailed(workEvent.getDetail()), (Throwable)runtimeException);
            throw new Scheduler.JobProcessorException((Throwable)runtimeException, this.checkRetry(jobInfo, runtimeException));
        }
        catch (Throwable throwable) {
            __log.error((Object)__msgs.msgScheduledJobFailed(workEvent.getDetail()), throwable);
            throw new Scheduler.JobProcessorException(false);
        }
    }

    private boolean checkRetry(Scheduler.JobInfo jobInfo, Throwable throwable) {
        __log.error((Object)("Job could not be completed after " + jobInfo.retryCount + " retries: " + jobInfo), throwable);
        return jobInfo.jobDetail.get("inmem") == null;
    }

    private void debuggingDelay() {
        if (_delayMean != 0.0) {
            try {
                long l = this.randomExp(_delayMean);
                __log.warn((Object)("Debugging delay has been activated; delaying transaction for " + l + "ms."));
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long randomExp(double d) {
        double d2 = this._random.nextDouble();
        long l = (long)(-Math.log(d2) * d);
        return l;
    }

    void fireEvent(BpelEvent bpelEvent) {
        for (BpelEventListener bpelEventListener : this._contexts.eventListeners) {
            bpelEventListener.onEvent(bpelEvent);
        }
    }

    List<MessageExchangeInterceptor> getGlobalInterceptors() {
        return this._contexts.globalInterceptors;
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._contexts.globalInterceptors.add(messageExchangeInterceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._contexts.globalInterceptors.remove(messageExchangeInterceptor);
    }

    public void unregisterMessageExchangeInterceptor(Class clazz) {
        MessageExchangeInterceptor messageExchangeInterceptor = null;
        for (MessageExchangeInterceptor messageExchangeInterceptor2 : this._contexts.globalInterceptors) {
            if (!messageExchangeInterceptor2.getClass().isAssignableFrom(clazz)) continue;
            messageExchangeInterceptor = messageExchangeInterceptor2;
            break;
        }
        if (messageExchangeInterceptor != null) {
            this._contexts.globalInterceptors.remove(messageExchangeInterceptor);
        }
    }

    public long getTotalBpelFootprint() {
        long l = 0L;
        for (BpelProcess bpelProcess : this._activeProcesses.values()) {
            Long l2 = this._hydratedSizes.get(bpelProcess.getPID());
            if (l2 == null) {
                l2 = this._unhydratedSizes.get(bpelProcess.getPID());
            }
            if (l2 == null || l2 <= 0L) continue;
            l += l2.longValue();
        }
        return l;
    }

    public long getHydratedFootprint() {
        long l = 0L;
        for (BpelProcess bpelProcess : this._activeProcesses.values()) {
            if (!bpelProcess.hintIsHydrated()) continue;
            Long l2 = this._hydratedSizes.get(bpelProcess.getPID());
            if (l2 == null) {
                l2 = this._unhydratedSizes.get(bpelProcess.getPID());
            }
            if (l2 == null || l2 <= 0L) continue;
            l += l2.longValue();
        }
        return l;
    }

    public long getHydratedProcessSize(QName qName) {
        return this.getHydratedProcessSize(this._activeProcesses.get(qName));
    }

    private long getHydratedProcessSize(BpelProcess bpelProcess) {
        long l = 0L;
        if (!bpelProcess.hintIsHydrated()) {
            Long l2 = this._hydratedSizes.get(bpelProcess.getPID());
            if (l2 == null) {
                l2 = this._unhydratedSizes.get(bpelProcess.getPID());
            }
            if (l2 != null && l2 > 0L) {
                l = l2;
            }
        }
        return this.getHydratedProcessSize(l);
    }

    private long getHydratedProcessSize(long l) {
        long l2 = (long)((double)(this.getHydratedFootprint() + l) * 1.2);
        return l2;
    }

    public int getHydratedProcessCount(QName qName) {
        int n = 0;
        for (BpelProcess bpelProcess : this._activeProcesses.values()) {
            if (!bpelProcess.hintIsHydrated() && !bpelProcess.getPID().equals(qName)) continue;
            ++n;
        }
        return n;
    }

    public void setInstanceThrottledMaximumCount(int n) {
        this._instanceThrottledMaximumCount = n;
    }

    public int getInstanceThrottledMaximumCount() {
        return this._instanceThrottledMaximumCount;
    }

    public void setProcessThrottledMaximumCount(int n) {
        this._processThrottledMaximumCount = n;
        if (n < Integer.MAX_VALUE) {
            this.registerMessageExchangeInterceptor(new ProcessCountThrottler());
        } else {
            this.unregisterMessageExchangeInterceptor(ProcessCountThrottler.class);
        }
    }

    public int getProcessThrottledMaximumCount() {
        return this._processThrottledMaximumCount;
    }

    public void setProcessThrottledMaximumSize(long l) {
        this._processThrottledMaximumSize = l;
        if (l < Long.MAX_VALUE) {
            this.registerMessageExchangeInterceptor(new ProcessSizeThrottler());
        } else {
            this.unregisterMessageExchangeInterceptor(ProcessSizeThrottler.class);
        }
    }

    public long getProcessThrottledMaximumSize() {
        return this._processThrottledMaximumSize;
    }

    public void setProcessSize(QName qName, boolean bl) {
        BpelProcess bpelProcess = this._activeProcesses.get(qName);
        long l = bpelProcess.sizeOf();
        if (bl) {
            this._hydratedSizes.put(bpelProcess.getPID(), new Long(l));
            this._unhydratedSizes.remove(bpelProcess.getPID());
        } else {
            this._hydratedSizes.remove(bpelProcess.getPID());
            this._unhydratedSizes.put(bpelProcess.getPID(), new Long(l));
        }
    }

    public boolean dehydrateLastUnusedProcess() {
        BpelProcess bpelProcess = null;
        long l = Long.MAX_VALUE;
        for (BpelProcess bpelProcess2 : this._activeProcesses.values()) {
            if (!bpelProcess2.hintIsHydrated() || bpelProcess2.getLastUsed() >= l || bpelProcess2.getInstanceInUseCount() != 0) continue;
            l = bpelProcess2.getLastUsed();
            bpelProcess = bpelProcess2;
        }
        if (bpelProcess != null) {
            bpelProcess.dehydrate();
            return true;
        }
        return false;
    }

    public void sendMyRoleFault(BpelProcess bpelProcess, WorkEvent workEvent, int n) {
        MessageExchange messageExchange = this.getMessageExchange(workEvent.getMexId());
        if (!(messageExchange instanceof MyRoleMessageExchange)) {
            return;
        }
        QName qName = null;
        OConstants oConstants = bpelProcess.getOProcess().constants;
        if (oConstants != null) {
            Document document = DOMUtils.newDocument();
            Element element = document.createElementNS(Namespaces.SOAP_ENV_NS, "Fault");
            Element element2 = document.createElementNS(Namespaces.ODE_EXTENSION_NS, "fault");
            element.appendChild(element2);
            switch (n) {
                case 3: {
                    qName = oConstants.qnTooManyProcesses;
                    element2.setTextContent("The total number of processes in use is over the limit.");
                    break;
                }
                case 4: {
                    qName = oConstants.qnTooHugeProcesses;
                    element2.setTextContent("The total size of processes in use is over the limit");
                    break;
                }
                case 2: {
                    qName = oConstants.qnTooManyInstances;
                    element2.setTextContent("No more instances of the process allowed at start at this time.");
                    break;
                }
                case 1: {
                    for (BpelProcess bpelProcess2 : this._activeProcesses.values()) {
                        if (!bpelProcess2.getConf().getState().equals((Object)ProcessState.ACTIVE) || !bpelProcess2.getConf().getType().equals(bpelProcess.getConf().getType())) continue;
                        workEvent.setProcessId(bpelProcess2._pid);
                        ((MyRoleMessageExchangeImpl)messageExchange)._process = bpelProcess2;
                        bpelProcess.handleWorkEvent(workEvent.getDetail());
                        return;
                    }
                    qName = oConstants.qnRetiredProcess;
                    element2.setTextContent("The process you're trying to instantiate has been retired.");
                    break;
                }
                default: {
                    qName = oConstants.qnUnknownFault;
                }
            }
            MexDaoUtil.setFaulted((MessageExchangeImpl)messageExchange, qName, element);
        }
    }

    private void sendPartnerRoleFailure(WorkEvent workEvent, MessageExchange.FailureType failureType) {
        MessageExchange messageExchange = this.getMessageExchange(workEvent.getMexId());
        if (messageExchange instanceof PartnerRoleMessageExchange && (messageExchange.getStatus() == MessageExchange.Status.ASYNC || messageExchange.getStatus() == MessageExchange.Status.REQUEST)) {
            String string = "No response received for invoke (mexId=" + workEvent.getMexId() + "), forcing it into a failed state.";
            if (__log.isDebugEnabled()) {
                __log.debug((Object)string);
            }
            MexDaoUtil.setFailure((PartnerRoleMessageExchangeImpl)messageExchange, failureType, string, null);
        }
    }

    static {
        try {
            String string = System.getenv("ODE_DEBUG_TX_DELAY");
            if (string != null && string.length() > 0) {
                _delayMean = Double.valueOf(string);
                __log.info((Object)("Stochastic debugging delay activated. Delay (Mean)=" + _delayMean + "ms."));
            }
        }
        catch (Throwable throwable) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Could not read ODE_DEBUG_TX_DELAY environment variable; assuming 0 (mean) delay", throwable);
            }
            __log.info((Object)"Could not read ODE_DEBUG_TX_DELAY environment variable; assuming 0 (mean) delay");
        }
        __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    }
}

