/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.fs.FileUtils;

public class XslRuntimeUriResolver
implements URIResolver {
    private static final Log __log = LogFactory.getLog(XslRuntimeUriResolver.class);
    private OXPath10Expression _expr;
    private final URI _baseResourceURI;

    public XslRuntimeUriResolver(OXPath10Expression oXPath10Expression, URI uRI) {
        this._expr = oXPath10Expression;
        this._baseResourceURI = uRI;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        URI uRI;
        try {
            uRI = new URI(FileUtils.encodePath((String)string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        OXslSheet oXslSheet = this._expr.getXslSheet(uRI);
        String string3 = oXslSheet != null ? oXslSheet.sheetBody : this.getResourceAsString(uRI);
        if (string3 != null) {
            return new StreamSource(new StringReader(string3));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceAsString(URI uRI) {
        block16: {
            String string;
            URI uRI2 = this._baseResourceURI.resolve(uRI);
            InputStream inputStream = null;
            try {
                File file = new File(uRI2);
                if (!file.exists()) {
                    String string2 = null;
                    return string2;
                }
                inputStream = new FileInputStream(file);
                string = new String(StreamUtils.read((InputStream)inputStream));
            }
            catch (IOException iOException) {
                __log.info((Object)("Couldn't load XSL resource " + uRI));
                break block16;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            return string;
        }
        return null;
    }
}

