/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.runtime;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.YearMonthDurationValue;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.runtime.XslRuntimeUriResolver;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.URITemplate;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);
    private EvaluationContext _ectx;
    private OXPath20ExpressionBPEL20 _oxpath;

    public JaxpFunctionResolver(EvaluationContext evaluationContext, OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20) {
        this._ectx = evaluationContext;
        this._oxpath = oXPath20ExpressionBPEL20;
    }

    public XPathFunction resolveFunction(QName qName, int n) {
        __log.debug((Object)("Resolving function " + qName));
        if (qName.getNamespaceURI() == null) {
            throw new NullPointerException("Undeclared namespace for " + qName);
        }
        if (qName.getNamespaceURI().equals(Namespaces.WS_BPEL_20_NS) || qName.getNamespaceURI().equals(Namespaces.WSBPEL2_0_FINAL_EXEC)) {
            String string = qName.getLocalPart();
            if ("getVariableData".equals(string)) {
                return new GetVariableData();
            }
            if ("getVariableProperty".equals(string)) {
                return new GetVariableProperty();
            }
            if ("getLinkStatus".equals(string)) {
                return new GetLinkStatus();
            }
            if ("doXslTransform".equals(string)) {
                return new DoXslTransform();
            }
            throw new NullPointerException("Unknown BPEL function: " + qName);
        }
        if (qName.getNamespaceURI().equals(Namespaces.ODE_EXTENSION_NS)) {
            String string = qName.getLocalPart();
            if ("split-to-elements".equals(string) || "splitToElements".equals(string)) {
                return new SplitToElements();
            }
            if ("combine-url".equals(string) || "combineUrl".equals(string)) {
                return new CombineUrl();
            }
            if ("compose-url".equals(string) || "composeUrl".equals(string)) {
                return new ComposeUrl();
            }
            if ("expand-template".equals(string) || "expandTemplate".equals(string)) {
                return new ComposeUrl(true, "expandTemplateInvalidSource");
            }
            if ("dom-to-string".equals(string) || "domToString".equals(string)) {
                return new DomToString();
            }
            if ("insert-after".equals(string)) {
                return new InsertAfter();
            }
            if ("insert-as-first-into".equals(string)) {
                return new InsertAsFirstInto();
            }
            if ("insert-as-last-into".equals(string)) {
                return new InsertAsLastInto();
            }
            if ("insert-before".equals(string)) {
                return new InsertBefore();
            }
            if ("delete".equals(string)) {
                return new Delete();
            }
            if ("rename".equals(string)) {
                return new Rename();
            }
            if ("process-property".equals(string)) {
                return new ProcessProperty();
            }
        } else if (qName.getNamespaceURI().equals(Namespaces.DEPRECATED_XDT_NS)) {
            String string = qName.getLocalPart();
            if ("dayTimeDuration".equals(string)) {
                return new DayTimeDuration();
            }
            if ("yearMonthDuration".equals(string)) {
                return new YearMonthDuration();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        public static String extractString(Object object) throws IllegalArgumentException {
            String string = null;
            try {
                Node node = null;
                if (object instanceof List) {
                    List list = (List)object;
                    if (list.size() != 1) {
                        throw new IllegalArgumentException("Parameter MUST point to a string, single element or text node.");
                    }
                    node = (Node)list.get(0);
                } else if (object instanceof NodeWrapper) {
                    node = (Node)((NodeWrapper)object).getUnderlyingNode();
                } else if (object instanceof Node) {
                    node = (Node)object;
                } else {
                    string = (String)object;
                }
                if (string == null) {
                    if (1 == node.getNodeType()) {
                        string = node.getTextContent().trim();
                    } else if (3 == node.getNodeType()) {
                        string = ((Text)node).getWholeText().trim();
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Parameter MUST point to a string, single element or text node.", classCastException);
            }
            return string;
        }

        public static int extractInteger(Object object) throws IllegalArgumentException {
            try {
                return Integer.parseInt(Helper.extractString(object));
            }
            catch (ClassCastException classCastException) {
                try {
                    return (int)((IntegerValue)object).longValue();
                }
                catch (XPathException xPathException) {
                    throw new IllegalArgumentException("Parameter MUST point to an integer, single element or text node.", xPathException);
                }
                catch (ClassCastException classCastException2) {
                    throw new IllegalArgumentException("Parameter MUST point to an integer, single element or text node.", classCastException2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Parameter MUST point to an integer, single element or text node.", numberFormatException);
            }
        }

        public static Map<String, String> extractNameValueMap(Element element) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getNodeType() != 1) continue;
                hashMap.put(node.getLocalName(), DOMUtils.getTextContent((Node)node));
            }
            return hashMap;
        }

        public static Map<String, String> buildNameValueMap(List list) {
            return Helper.buildNameValueMap(list, 0);
        }

        public static Map<String, String> buildNameValueMap(List list, int n) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = n; i < list.size(); i += 2) {
                hashMap.put(Helper.extractString(list.get(i)), Helper.extractString(list.get(i + 1)));
            }
            return hashMap;
        }
    }

    public class YearMonthDuration
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "yearMonthDurationPropertyInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("yearMonthDuration call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            String string = null;
            Element element = null;
            try {
                if (list.get(0) instanceof List) {
                    List list2 = (List)list.get(0);
                    if (list2.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:yearMonthDuration function MUST be passed a single element node."));
                    }
                    if (list2.get(0) instanceof Element) {
                        element = (Element)list2.get(0);
                    } else if (list2.get(0) instanceof String) {
                        string = (String)list2.get(0);
                    }
                } else if (list.get(0) instanceof NodeWrapper) {
                    element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                } else if (list.get(0) instanceof Element) {
                    element = (Element)list.get(0);
                } else if (list.get(0) instanceof String) {
                    string = (String)list.get(0);
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                if (string == null && element != null) {
                    string = element.getTextContent();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:yearMonthDuration function MUST be passed a single element node."));
            }
            return YearMonthDurationValue.makeYearMonthDurationValue(string);
        }
    }

    public class DayTimeDuration
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "dayTimeDurationPropertyInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("dayTimeDuration call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            String string = null;
            Element element = null;
            try {
                if (list.get(0) instanceof List) {
                    List list2 = (List)list.get(0);
                    if (list2.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:dayTimeDuration function MUST be passed a single element node."));
                    }
                    if (list2.get(0) instanceof Element) {
                        element = (Element)list2.get(0);
                    } else if (list2.get(0) instanceof String) {
                        string = (String)list2.get(0);
                    }
                } else if (list.get(0) instanceof NodeWrapper) {
                    element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                } else if (list.get(0) instanceof Element) {
                    element = (Element)list.get(0);
                } else if (list.get(0) instanceof String) {
                    string = (String)list.get(0);
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                if (string == null && element != null) {
                    string = element.getTextContent();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:dayTimeDuration function MUST be passed a single element node."));
            }
            return DayTimeDurationValue.makeDayTimeDurationValue(string);
        }
    }

    public class ProcessProperty
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "processPropertyInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("process-property call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            QName qName = null;
            Element element = null;
            try {
                if (list.get(0) instanceof List) {
                    List list2 = (List)list.get(0);
                    if (list2.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:process-property function MUST be passed a single element node."));
                    }
                    if (list2.get(0) instanceof Element) {
                        element = (Element)list2.get(0);
                    } else if (list2.get(0) instanceof String) {
                        qName = new QName((String)list2.get(0));
                    }
                } else if (list.get(0) instanceof NodeWrapper) {
                    element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                } else if (list.get(0) instanceof Element) {
                    element = (Element)list.get(0);
                } else if (list.get(0) instanceof QNameValue) {
                    QNameValue qNameValue = (QNameValue)list.get(0);
                    qName = new QName(qNameValue.getNamespaceURI(), qNameValue.getLocalName(), qNameValue.getPrefix());
                } else if (list.get(0) instanceof String) {
                    String string = (String)list.get(0);
                    if (string.indexOf(":") > 0) {
                        String string2 = string.substring(0, string.indexOf(":"));
                        String string3 = string.substring(string.indexOf(":") + 1);
                        String string4 = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.namespaceCtx.getNamespaceURI(string2);
                        qName = new QName(string4, string3, string2);
                    } else {
                        qName = new QName(string);
                    }
                } else if (list.get(0) instanceof QName) {
                    qName = (QName)list.get(0);
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                if (qName == null && element != null) {
                    qName = new QName(element.getTextContent());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:process-property function MUST be passed a single element node."));
            }
            return JaxpFunctionResolver.this._ectx.getPropertyValue(qName);
        }
    }

    public class Rename
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            Element element;
            Object object;
            Object object2;
            Element element2;
            Object object3;
            if (list.size() < 2) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "renameInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("rename call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            QName qName = null;
            QName qName2 = null;
            try {
                if (list.get(0) instanceof List) {
                    object3 = (List)list.get(0);
                    if (object3.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:rename function MUST be passed a single element node."));
                    }
                    element2 = (Element)object3.get(0);
                } else if (list.get(0) instanceof NodeWrapper) {
                    element2 = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                } else if (list.get(0) instanceof Element) {
                    element2 = (Element)list.get(0);
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                object3 = null;
                object2 = null;
                String string = null;
                if (list.get(1) instanceof QNameValue) {
                    object = (QNameValue)list.get(1);
                    object2 = object.getNamespaceURI();
                    object3 = object.getLocalName();
                    string = object.getPrefix();
                } else if (list.get(1) instanceof List) {
                    object = (List)list.get(1);
                    if (object.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:rename function MUST be passed a single element node."));
                    }
                    element = (Element)object.get(0);
                    object2 = element.getNamespaceURI();
                    object3 = element.getLocalName();
                    string = element.getPrefix();
                } else if (list.get(1) instanceof NodeWrapper) {
                    object = (Element)((NodeWrapper)list.get(1)).getUnderlyingNode();
                    object2 = object.getNamespaceURI();
                    object3 = object.getLocalName();
                    string = object.getPrefix();
                } else if (list.get(1) instanceof Element) {
                    object = (Element)list.get(1);
                    object2 = object.getNamespaceURI();
                    object3 = object.getLocalName();
                    string = object.getPrefix();
                } else if (list.get(1) instanceof String) {
                    object = (String)list.get(1);
                    if (((String)object).contains(":")) {
                        int n = ((String)object).indexOf(":");
                        string = ((String)object).substring(0, n);
                        object3 = ((String)object).substring(n + 1);
                    } else {
                        object3 = object;
                    }
                } else if (list.get(1) instanceof QName) {
                    object = (QName)list.get(1);
                    object2 = ((QName)object).getNamespaceURI();
                    object3 = ((QName)object).getLocalPart();
                    string = ((QName)object).getPrefix();
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(1).getClass());
                }
                if (object2 == null) {
                    object2 = element2.lookupNamespaceURI(string);
                }
                qName = new QName((String)object2, (String)object3, string);
                if (list.size() > 2) {
                    if (list.get(2) instanceof QNameValue) {
                        object = (QNameValue)list.get(2);
                        object2 = object.getNamespaceURI();
                        object3 = object.getLocalName();
                        string = object.getPrefix();
                    } else if (list.get(2) instanceof NodeWrapper) {
                        object = (Element)((NodeWrapper)list.get(2)).getUnderlyingNode();
                        object2 = object.getNamespaceURI();
                        object3 = object.getLocalName();
                        string = object.getPrefix();
                    } else if (list.get(2) instanceof Element) {
                        object = (Element)list.get(2);
                        object2 = object.getNamespaceURI();
                        object3 = object.getLocalName();
                        string = object.getPrefix();
                    } else if (list.get(2) instanceof String) {
                        object = (String)list.get(2);
                        if (((String)object).contains(":")) {
                            int n = ((String)object).indexOf(":");
                            string = ((String)object).substring(0, n);
                            object3 = ((String)object).substring(n + 1);
                        } else {
                            object3 = object;
                        }
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + list.get(2).getClass());
                    }
                    if (object2 == null) {
                        object2 = element2.lookupNamespaceURI(string);
                    }
                    qName2 = new QName((String)object2, (String)object3, string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:rename function MUST be passed a single element node."));
            }
            object3 = (Element)element2.getParentNode();
            object2 = object3.getChildNodes();
            int n = 0;
            while (n < object2.getLength() && !object2.item(n++).isSameNode(element2)) {
            }
            object = (Element)object3.cloneNode(true);
            object2 = object.getChildNodes();
            element = element2.getOwnerDocument().createElementNS(qName.getNamespaceURI(), qName.getPrefix() + ":" + qName.getLocalPart());
            Element element3 = (Element)object2.item(n - 1);
            object2 = element3.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                element.appendChild(object2.item(i));
            }
            object.replaceChild(element, element3);
            if (qName2 != null) {
                element.setAttributeNS(Namespaces.XML_INSTANCE, "xsi:type", qName2.getPrefix() + ":" + qName2.getLocalPart());
            }
            return object;
        }
    }

    public class Delete
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            int transformerException;
            Object object2;
            ArrayList<Element> arrayList;
            block16: {
                Object e;
                if (list.size() < 1 || list.size() > 2) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "deleteInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("delete call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                arrayList = new ArrayList<Element>();
                e = list.size() == 2 ? (e = list.get(1)) : list.get(0);
                try {
                    if (e instanceof List) {
                        object2 = (List)e;
                        arrayList.addAll((Collection<Element>)object2);
                        break block16;
                    }
                    if (e instanceof NodeWrapper) {
                        arrayList.add((Element)((NodeWrapper)e).getUnderlyingNode());
                        break block16;
                    }
                    if (e instanceof Element) {
                        arrayList.add((Element)e);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + e.getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + e, (Throwable)illegalArgumentException));
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:delete function MUST be passed a valid element node."));
                }
            }
            object2 = null;
            for (Node object3 : arrayList) {
                if (object2 == null) {
                    object2 = (Element)object3.getParentNode();
                    continue;
                }
                if (object2.isSameNode((Element)object3.getParentNode())) continue;
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:delete function MUST be passed nodes that have the same parent."));
            }
            Object object4 = object2.getChildNodes();
            int[] nArray = new int[arrayList.size()];
            for (int element = 0; element < nArray.length; ++element) {
                for (transformerException = 0; transformerException < object4.getLength(); ++transformerException) {
                    if (!object4.item(transformerException).isSameNode((Node)arrayList.get(element))) continue;
                    nArray[element] = transformerException;
                }
            }
            Element element = (Element)object2.cloneNode(true);
            object4 = element.getChildNodes();
            for (transformerException = 0; transformerException < nArray.length; ++transformerException) {
                Element element2 = (Element)object4.item(nArray[transformerException]);
                element.removeChild(element2);
            }
            if (element.getChildNodes().getLength() == 0) {
                try {
                    element.appendChild(DOMUtils.toDOMDocument((Node)object2).createTextNode(""));
                }
                catch (TransformerException transformerException2) {
                    throw new XPathFunctionException(transformerException2);
                }
            }
            return element;
        }
    }

    public class InsertAsLastInto
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            ArrayList<Object> arrayList;
            Element element;
            Object object;
            block16: {
                if (list.size() != 2) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "insertAsLastIntoInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertAsLastInto call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                try {
                    if (list.get(0) instanceof List) {
                        object = (List)list.get(0);
                        if (object.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsLastInto function MUST be passed a single element node."));
                        }
                        element = (Element)object.get(0);
                    } else if (list.get(0) instanceof NodeWrapper) {
                        element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                    } else if (list.get(0) instanceof Element) {
                        element = (Element)list.get(0);
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                    }
                    if (list.get(1) instanceof List) {
                        arrayList = (ArrayList<Object>)list.get(1);
                        break block16;
                    }
                    if (list.get(1) instanceof NodeWrapper) {
                        object = (Node)((NodeWrapper)list.get(1)).getUnderlyingNode();
                        arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        break block16;
                    }
                    if (list.get(1) instanceof Element) {
                        object = (Node)list.get(1);
                        arrayList = new ArrayList();
                        arrayList.add(object);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsLastInto function MUST be passed a single element node."));
                }
            }
            object = (Element)element.cloneNode(true);
            Document document = object.getOwnerDocument();
            for (int i = 0; i < arrayList.size(); ++i) {
                object.appendChild(document.importNode((Node)arrayList.get(i), true));
            }
            return object;
        }
    }

    public class InsertAsFirstInto
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            ArrayList<Object> arrayList;
            Element element;
            Object object;
            block16: {
                if (list.size() != 2) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "insertAsFirstIntoInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertAsFirstInto call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                try {
                    if (list.get(0) instanceof List) {
                        object = (List)list.get(0);
                        if (object.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsFirstInto function MUST be passed a single element node."));
                        }
                        element = (Element)object.get(0);
                    } else if (list.get(0) instanceof NodeWrapper) {
                        element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                    } else if (list.get(0) instanceof Element) {
                        element = (Element)list.get(0);
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                    }
                    if (list.get(1) instanceof List) {
                        arrayList = (ArrayList<Object>)list.get(1);
                        break block16;
                    }
                    if (list.get(1) instanceof NodeWrapper) {
                        object = (Node)((NodeWrapper)list.get(1)).getUnderlyingNode();
                        arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        break block16;
                    }
                    if (list.get(1) instanceof Element) {
                        object = (Node)list.get(1);
                        arrayList = new ArrayList();
                        arrayList.add(object);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsFirstInto function MUST be passed a single element node."));
                }
            }
            object = (Element)element.cloneNode(true);
            Node node = object.getFirstChild();
            Document document = object.getOwnerDocument();
            for (int i = 0; i < arrayList.size(); ++i) {
                object.insertBefore(document.importNode((Node)arrayList.get(i), true), node);
            }
            return object;
        }
    }

    public class InsertBefore
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            ArrayList<Object> arrayList;
            Element element;
            Object object;
            block18: {
                if (list.size() < 2 || list.size() > 3) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "insertBeforeInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertBefore call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                Object object2 = null;
                Object object3 = null;
                try {
                    if (list.size() == 2) {
                        object2 = list.get(0);
                        object3 = list.get(1);
                    } else {
                        object2 = list.get(1);
                        object3 = list.get(2);
                    }
                    if (object2 instanceof List) {
                        object = (List)object2;
                        element = (Element)object.get(0);
                    } else if (object2 instanceof NodeWrapper) {
                        element = (Element)((NodeWrapper)object2).getUnderlyingNode();
                    } else if (object2 instanceof Element) {
                        element = (Element)object2;
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + object2.getClass());
                    }
                    if (object3 instanceof List) {
                        arrayList = (ArrayList<Object>)object3;
                        break block18;
                    }
                    if (object3 instanceof NodeWrapper) {
                        object = (Node)((NodeWrapper)object3).getUnderlyingNode();
                        arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        break block18;
                    }
                    if (object3 instanceof Element) {
                        object = (Node)object3;
                        arrayList = new ArrayList();
                        arrayList.add(object);
                        break block18;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + object3.getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + object2, (Throwable)illegalArgumentException));
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertBefore function MUST be passed a single element node."));
                }
            }
            object = (Element)element.getParentNode();
            NodeList nodeList = object.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength() && !nodeList.item(n++).isSameNode(element)) {
            }
            Element element2 = (Element)object.cloneNode(true);
            nodeList = element2.getChildNodes();
            Node node = n <= nodeList.getLength() ? nodeList.item(n - 1) : null;
            Document document = element2.getOwnerDocument();
            for (int i = 0; i < arrayList.size(); ++i) {
                element2.insertBefore(document.importNode((Node)arrayList.get(i), true), node);
            }
            return element2;
        }
    }

    public class InsertAfter
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            ArrayList<Object> arrayList;
            Element element;
            Object object;
            block18: {
                if (list.size() < 2 || list.size() > 3) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "insertAfterInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertAfter call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                Object object2 = null;
                Object object3 = null;
                try {
                    if (list.size() == 2) {
                        object2 = list.get(0);
                        object3 = list.get(1);
                    } else {
                        object2 = list.get(1);
                        object3 = list.get(2);
                    }
                    if (object2 instanceof List) {
                        object = (List)object2;
                        element = (Element)object.get(object.size() - 1);
                    } else if (object2 instanceof NodeWrapper) {
                        element = (Element)((NodeWrapper)object2).getUnderlyingNode();
                    } else if (object2 instanceof Element) {
                        element = (Element)object2;
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + object2.getClass());
                    }
                    if (object3 instanceof List) {
                        arrayList = (ArrayList<Object>)object3;
                        break block18;
                    }
                    if (object3 instanceof NodeWrapper) {
                        object = (Node)((NodeWrapper)object3).getUnderlyingNode();
                        arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        break block18;
                    }
                    if (object3 instanceof Element) {
                        object = (Node)object3;
                        arrayList = new ArrayList();
                        arrayList.add(object);
                        break block18;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + object3.getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + object3, (Throwable)illegalArgumentException));
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAfter function MUST be passed a single element node."));
                }
            }
            object = (Element)element.getParentNode();
            NodeList nodeList = object.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength() && !nodeList.item(n++).isSameNode(element)) {
            }
            Element element2 = (Element)object.cloneNode(true);
            nodeList = element2.getChildNodes();
            Node node = n < nodeList.getLength() ? nodeList.item(n) : null;
            Document document = element2.getOwnerDocument();
            for (int i = 0; i < arrayList.size(); ++i) {
                element2.insertBefore(document.importNode((Node)arrayList.get(i), true), node);
            }
            return element2;
        }
    }

    public class InsertInto
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            ArrayList<Object> arrayList;
            int n;
            Element element;
            Object object;
            block16: {
                if (list.size() != 3) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "insertIntoInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertInto call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                try {
                    if (list.get(0) instanceof List) {
                        object = (List)list.get(0);
                        if (object.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertInto function MUST be passed a single element node."));
                        }
                        element = (Element)object.get(0);
                    } else if (list.get(0) instanceof NodeWrapper) {
                        element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                    } else if (list.get(0) instanceof Element) {
                        element = (Element)list.get(0);
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                    }
                    n = Helper.extractInteger(list.get(1));
                    if (list.get(2) instanceof List) {
                        arrayList = (ArrayList<Object>)list.get(2);
                        break block16;
                    }
                    if (list.get(2) instanceof NodeWrapper) {
                        object = (Node)((NodeWrapper)list.get(2)).getUnderlyingNode();
                        arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        break block16;
                    }
                    if (list.get(2) instanceof Element) {
                        object = (Node)list.get(2);
                        arrayList = new ArrayList();
                        arrayList.add(object);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertInto function MUST be passed a single element node."));
                }
            }
            object = (Element)element.cloneNode(true);
            NodeList nodeList = object.getChildNodes();
            int n2 = nodeList.getLength();
            Object object2 = null;
            object2 = n <= 1 ? object.getFirstChild() : (n == n2 ? object.getLastChild() : (n > n2 ? null : nodeList.item(n + 1)));
            for (int i = 0; i < arrayList.size(); ++i) {
                object.insertBefore((Node)arrayList.get(i), (Node)object2);
            }
            return object;
        }
    }

    public static class ComposeUrl
    implements XPathFunction {
        boolean preserveUndefinedVar = false;
        String faultLocalPart = "composeUrlInvalidSource";
        QName faultQName;

        public ComposeUrl() {
            this.faultQName = new QName(Namespaces.ODE_EXTENSION_NS, this.faultLocalPart);
        }

        public ComposeUrl(boolean bl, String string) {
            this.preserveUndefinedVar = bl;
            this.faultLocalPart = string;
            this.faultQName = new QName(Namespaces.ODE_EXTENSION_NS, string);
        }

        public Object evaluate(List list) throws XPathFunctionException {
            Map<String, String> map;
            String string;
            boolean bl;
            if (list.size() == 2) {
                bl = false;
            } else if (list.size() > 2 && list.size() % 2 == 1) {
                bl = true;
            } else {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Illegal Arguments"));
            }
            try {
                string = Helper.extractString(list.get(0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument: URI Template expected. " + list.get(0), (Throwable)illegalArgumentException));
            }
            if (bl) {
                try {
                    map = Helper.buildNameValueMap(list, 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument", (Throwable)illegalArgumentException));
                }
            }
            try {
                Element element = null;
                if (list.get(1) instanceof List) {
                    List list2 = (List)list.get(1);
                    element = (Element)list2.get(0);
                } else if (list.get(1) instanceof Element) {
                    element = (Element)list.get(1);
                }
                map = Helper.extractNameValueMap(element);
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Expected an element similar too: <foo><name1>value1</name1><name2>value2</name2>...</foo>"));
            }
            try {
                if (this.preserveUndefinedVar) {
                    return URITemplate.expandLazily((String)string, map);
                }
                return URITemplate.expand((String)string, map);
            }
            catch (URIException uRIException) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument", (Throwable)uRIException));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument", (Throwable)unsupportedOperationException));
            }
        }
    }

    public static class CombineUrl
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            URL uRL;
            String string;
            String string2;
            QName qName = new QName(Namespaces.ODE_EXTENSION_NS, "combineUrlInvalidSource");
            if (list.size() != 2) {
                throw new XPathFunctionException(new FaultException(qName, "Invalid arguments"));
            }
            try {
                string2 = Helper.extractString(list.get(0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(qName, "Invalid argument: " + list.get(0), (Throwable)illegalArgumentException));
            }
            try {
                string = Helper.extractString(list.get(1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(qName, "Invalid argument: " + list.get(1), (Throwable)illegalArgumentException));
            }
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathFunctionException(new FaultException(qName, "First parameter [" + string2 + "] MUST point to a well-formed URL.", (Throwable)malformedURLException));
            }
            try {
                URL uRL2 = new URL(uRL, string);
                return uRL2.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathFunctionException(new FaultException(qName, malformedURLException.getMessage(), (Throwable)malformedURLException));
            }
        }
    }

    public class SplitToElements
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            String[] stringArray;
            String string;
            if (list.size() <= 2 || list.size() >= 5) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "splitInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("splitToElements call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            try {
                string = Helper.extractString(list.get(0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "splitInvalidSource"), (Throwable)illegalArgumentException));
            }
            String string2 = (String)list.get(1);
            String string3 = (String)list.get(2);
            String string4 = list.size() == 4 ? (String)list.get(3) : null;
            Document document = DOMUtils.newDocument();
            Element element = document.createElement("wrapper");
            document.appendChild(element);
            for (String string5 : stringArray = string.split(string2)) {
                Element element2 = document.createElementNS(string4, string3);
                element2.setTextContent(string5.trim());
                element.appendChild(element2);
            }
            return element;
        }
    }

    public class DomToString
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            Element element;
            Object object;
            block8: {
                if (list.size() != 1) {
                    throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "domToStringInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("domToString call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
                }
                try {
                    if (list.get(0) instanceof List) {
                        object = (List)list.get(0);
                        if (object.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "The bpws:domToString function MUST be passed a single element node."));
                        }
                        element = (Element)object.get(0);
                        break block8;
                    }
                    if (list.get(0) instanceof NodeWrapper) {
                        element = (Element)((NodeWrapper)list.get(0)).getUnderlyingNode();
                        break block8;
                    }
                    if (list.get(0) instanceof Element) {
                        element = (Element)list.get(0);
                        break block8;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + list.get(0).getClass());
                }
                catch (ClassCastException classCastException) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "The bpws:domToString function MUST be passed a single element node."));
                }
            }
            object = DOMUtils.domToString((Node)element);
            return object;
        }
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            Object object;
            Object object2;
            Object object3;
            Element element;
            Object object4;
            if (list.size() < 2 || list.size() % 2 != 0) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "doXslTransformInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            if (!(JaxpFunctionResolver.this._oxpath instanceof OXPath10ExpressionBPEL20)) {
                throw new IllegalStateException("XPath function bpws:doXslTransform not supported in BPEL 1.1!");
            }
            try {
                if (list.get(1) instanceof List) {
                    object4 = (List)list.get(1);
                    if (object4.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
                    }
                    element = (Element)object4.get(0);
                } else {
                    element = list.get(1) instanceof NodeWrapper ? (Element)((NodeWrapper)list.get(1)).getUnderlyingNode() : (Element)list.get(1);
                }
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            try {
                object4 = new URI((String)list.get(0));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathFunctionException("First parameter of the bpws:doXslTransform isn't a valid URI!");
            }
            OXslSheet oXslSheet = JaxpFunctionResolver.this._oxpath.getXslSheet((URI)object4);
            if (oXslSheet == null) {
                throw new XPathFunctionException("Couldn't find the XSL sheet " + list.get(0) + ", process compilation or deployment was probably incomplete!");
            }
            if (!(element instanceof Element)) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            HashMap hashMap = null;
            if (list.size() > 2) {
                hashMap = new HashMap();
                for (int i = 2; i < list.size(); i += 2) {
                    object3 = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.namespaceCtx.derefQName((String)list.get(i));
                    if (list.get(i + 1) instanceof NodeWrapper) {
                        object2 = (Element)((NodeWrapper)list.get(i + 1)).getUnderlyingNode();
                        Document document = DOMUtils.newDocument();
                        document.appendChild(document.importNode((Node)object2, true));
                        object = document;
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Passing parameter " + object3 + " " + DOMUtils.domToString((Node)document)));
                        }
                    } else {
                        object = list.get(i + 1) instanceof List ? ((List)list.get(i + 1)).get(0) : list.get(i + 1);
                    }
                    hashMap.put(object3, object);
                }
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Executing XSL sheet " + list.get(0) + " on element " + DOMUtils.domToString((Node)element)));
            }
            Document document = DOMUtils.newDocument();
            document.appendChild(document.importNode(element, true));
            object3 = new DOMSource(document);
            object2 = new XslRuntimeUriResolver((OXPath10Expression)JaxpFunctionResolver.this._oxpath, JaxpFunctionResolver.this._ectx.getBaseResourceURI());
            XslTransformHandler.getInstance().cacheXSLSheet(JaxpFunctionResolver.this._ectx.getProcessQName(), (URI)object4, oXslSheet.sheetBody, (URIResolver)object2);
            try {
                object = XslTransformHandler.getInstance().transform(JaxpFunctionResolver.this._ectx.getProcessQName(), (URI)object4, (Source)object3, hashMap, (URIResolver)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSubLanguageExecutionFault, exception.toString()));
            }
            if (object instanceof Node) {
                return ((Node)object).getChildNodes();
            }
            return object;
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 2) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "getVariablePropertyInvalidSource"), "Missing required arguments"));
            }
            OScope.Variable variable = (OScope.Variable)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.vars.get(list.get(0));
            OProcess.OProperty oProperty = (OProcess.OProperty)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.properties.get(list.get(1));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("function call:'bpws:getVariableProperty(" + variable + "," + oProperty + ")'"));
            }
            try {
                return JaxpFunctionResolver.this._ectx.readMessageProperty(variable, oProperty);
            }
            catch (FaultException faultException) {
                throw new XPathFunctionException(faultException);
            }
        }
    }

    public class GetVariableData
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            String string = (String)list.get(0);
            String string2 = list.size() > 1 ? (String)list.get(1) : null;
            String string3 = list.size() > 2 ? (String)list.get(2) : null;
            OXPath10Expression.OSigGetVariableData oSigGetVariableData = JaxpFunctionResolver.this._oxpath.resolveGetVariableDataSig(string, string2, string3);
            if (oSigGetVariableData == null) {
                String string4 = "InternalError: Attempt to use an unknown getVariableData signature: " + list;
                if (__log.isFatalEnabled()) {
                    __log.fatal((Object)string4);
                }
                throw new XPathFunctionException(string4);
            }
            try {
                Node node = JaxpFunctionResolver.this._ectx.readVariable(oSigGetVariableData.variable, oSigGetVariableData.part);
                if (oSigGetVariableData.location != null) {
                    node = JaxpFunctionResolver.this._ectx.evaluateQuery(node, oSigGetVariableData.location);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("bpws:getVariableData(" + list + ")' = " + node));
                }
                return node;
            }
            catch (FaultException faultException) {
                __log.error((Object)("bpws:getVariableData(" + list + ") threw FaultException"));
                throw new XPathFunctionException(faultException);
            }
            catch (EvaluationException evaluationException) {
                __log.error((Object)("bpws:getVariableData(" + list + ") threw FaultException"));
                throw new XPathFunctionException(evaluationException);
            }
        }
    }

    public class GetLinkStatus
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "getLinkStatusInvalidSource"), "Illegal Arguments"));
            }
            OLink oLink = (OLink)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.links.get(list.get(0));
            try {
                return JaxpFunctionResolver.this._ectx.isLinkActive(oLink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException faultException) {
                throw new XPathFunctionException(new FaultException(new QName(Namespaces.ODE_EXTENSION_NS, "getLinkStatusInvalidSource"), (Throwable)faultException));
            }
        }
    }
}

