/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OAssign
extends OActivity {
    static final long serialVersionUID = -1L;
    public final List<Copy> copy = new ArrayList<Copy>();

    public OAssign(OProcess oProcess, OActivity oActivity) {
        super(oProcess, oActivity);
    }

    public String toString() {
        return "{OAssign : " + this.name + ", joinCondition=" + this.joinCondition + "}";
    }

    public void dehydrate() {
        super.dehydrate();
        for (Copy copy : this.copy) {
            copy.dehydrate();
        }
    }

    public static class PartnerLinkRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OPartnerLink partnerLink;
        public boolean isMyEndpointReference;

        public PartnerLinkRef(OProcess oProcess) {
            super(oProcess);
        }

        public OScope.Variable getVariable() {
            return null;
        }

        public String toString() {
            return "{PLinkRef " + this.partnerLink + "!" + this.isMyEndpointReference + "}";
        }
    }

    public static class PropertyRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public OProcess.OPropertyAlias propertyAlias;

        public PropertyRef(OProcess oProcess) {
            super(oProcess);
        }

        public OScope.Variable getVariable() {
            return this.variable;
        }

        public String toString() {
            return "{PropRef " + this.variable + "!" + this.propertyAlias + "}";
        }
    }

    public static class VariableRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public OMessageVarType.Part part;
        public OMessageVarType.Part headerPart;
        public OExpression location;

        public VariableRef(OProcess oProcess) {
            super(oProcess);
        }

        public OScope.Variable getVariable() {
            return this.variable;
        }

        public boolean isMessageRef() {
            return this.variable.type instanceof OMessageVarType && this.part == null && this.headerPart == null && this.location == null;
        }

        public boolean isPartRef() {
            return this.variable.type instanceof OMessageVarType && this.part != null && this.location == null;
        }

        public boolean isHeaderRef() {
            return this.variable.type instanceof OMessageVarType && this.headerPart != null && this.location == null;
        }

        public String toString() {
            return "{VarRef " + this.variable + (this.part == null ? "" : "." + this.part.name) + (this.location == null ? "" : this.location.toString()) + "}";
        }
    }

    public static class DirectRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public QName elName;

        public DirectRef(OProcess oProcess) {
            super(oProcess);
        }

        public OScope.Variable getVariable() {
            return this.variable;
        }
    }

    public static class Expression
    extends OBase
    implements RValue {
        private static final long serialVersionUID = 1L;
        public OExpression expression;

        public Expression(OProcess oProcess, OExpression oExpression) {
            super(oProcess);
            this.expression = oExpression;
        }

        public String toString() {
            return this.expression.toString();
        }
    }

    public static class LValueExpression
    extends OBase
    implements LValue {
        private static final long serialVersionUID = 1L;
        public OLValueExpression expression;

        public LValueExpression(OProcess oProcess, OLValueExpression oLValueExpression) {
            super(oProcess);
            this.expression = oLValueExpression;
        }

        public String toString() {
            return this.expression.toString();
        }

        public OScope.Variable getVariable() {
            return this.expression.getVariable();
        }

        public boolean isInsertMissingToData() {
            return this.expression.insertMissingData;
        }

        public void setInsertMissingToData(boolean bl) {
            this.expression.insertMissingData = bl;
        }
    }

    public static class Literal
    extends OBase
    implements RValue {
        private static final long serialVersionUID = 1L;
        public transient String stringLiteral;

        public Literal(OProcess oProcess, Document document) {
            super(oProcess);
            if (document == null) {
                throw new IllegalArgumentException("null xmlLiteral!");
            }
            this.stringLiteral = DOMUtils.domToString((Node)document);
        }

        public String toString() {
            return "{Literal " + this.stringLiteral + "}";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.stringLiteral);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            try {
                this.stringLiteral = (String)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException("XML de-serialization error.").initCause(classNotFoundException);
            }
        }

        public Document getXmlLiteral() throws SAXException, IOException {
            return DOMUtils.stringToDOM((String)this.stringLiteral).getOwnerDocument();
        }
    }

    public static interface RValue {
    }

    public static interface LValue {
        public OScope.Variable getVariable();
    }

    public static class Copy
    extends OBase {
        private static final long serialVersionUID = 1L;
        public LValue to;
        public RValue from;
        public boolean keepSrcElementName;
        public boolean ignoreMissingFromData;
        public boolean ignoreUninitializedFromVariable;
        public boolean insertMissingToData;

        public Copy(OProcess oProcess) {
            super(oProcess);
        }

        public String toString() {
            return "{OCopy " + this.to + "=" + this.from + "}";
        }

        public void dehydrate() {
            super.dehydrate();
            this.to = null;
            this.from = null;
        }
    }
}

