/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockScheduler
implements Scheduler {
    private static final Log __log = LogFactory.getLog(MockScheduler.class);
    private Scheduler.JobProcessor _processor;
    private ExecutorService _executorSvc = Executors.newCachedThreadPool();
    private ThreadLocal<Boolean> _transacted = new ThreadLocal();
    private TransactionManager _txm;
    private Timer _timer = new Timer(false);
    ThreadLocal<List<Scheduler.Synchronizer>> _synchros = new ThreadLocal<List<Scheduler.Synchronizer>>(){

        @Override
        protected List<Scheduler.Synchronizer> initialValue() {
            return new ArrayList<Scheduler.Synchronizer>();
        }
    };

    public MockScheduler() {
        this._transacted.set(false);
    }

    public MockScheduler(TransactionManager transactionManager) {
        this._txm = transactionManager;
        this._transacted.set(false);
    }

    public String schedulePersistedJob(final Map<String, Object> map, final Date date) throws ContextException {
        if (date != null) {
            this.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean bl) {
                    if (!bl) {
                        return;
                    }
                    MockScheduler.this._timer.schedule(new TimerTask(){

                        public void run() {
                            try {
                                MockScheduler.this.execIsolatedTransaction(new Callable(){

                                    public Object call() throws Exception {
                                        Scheduler.JobInfo jobInfo = new Scheduler.JobInfo("volatileJob", map, 0);
                                        MockScheduler.this.doExecute(jobInfo);
                                        return null;
                                    }
                                });
                            }
                            catch (Exception exception) {
                                throw new ContextException("Failure when scheduling a new volatile job.", (Throwable)exception);
                            }
                        }
                    }, date);
                }

                public void beforeCompletion() {
                }
            });
            return null;
        }
        return this.scheduleVolatileJob(true, map);
    }

    public String scheduleVolatileJob(final boolean bl, final Map<String, Object> map) throws ContextException {
        this.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean bl2) {
                if (!bl2) {
                    return;
                }
                try {
                    if (bl) {
                        MockScheduler.this.execIsolatedTransaction(new Callable(){

                            public Object call() throws Exception {
                                Scheduler.JobInfo jobInfo = new Scheduler.JobInfo("volatileJob", map, 0);
                                MockScheduler.this.doExecute(jobInfo);
                                return null;
                            }
                        });
                    } else {
                        Scheduler.JobInfo jobInfo = new Scheduler.JobInfo("volatileJob", map, 0);
                        MockScheduler.this.doExecute(jobInfo);
                    }
                }
                catch (Exception exception) {
                    throw new ContextException("Failure when starting a new volatile job.", (Throwable)exception);
                }
            }

            public void beforeCompletion() {
            }
        });
        return null;
    }

    public String scheduleMapSerializableRunnable(final Scheduler.MapSerializableRunnable mapSerializableRunnable, final Date date) throws ContextException {
        if (date != null) {
            this.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean bl) {
                    if (!bl) {
                        return;
                    }
                    MockScheduler.this._timer.schedule(new TimerTask(){

                        public void run() {
                            mapSerializableRunnable.run();
                        }
                    }, date);
                }

                public void beforeCompletion() {
                }
            });
            return null;
        }
        return this.scheduleVolatileJob(true, new HashMap<String, Object>());
    }

    public void cancelJob(String string) throws ContextException {
    }

    public <T> T execTransaction(Callable<T> callable) throws Exception, ContextException {
        this.beginTransaction();
        try {
            T t = callable.call();
            this.commitTransaction();
            return t;
        }
        catch (Throwable throwable) {
            __log.error((Object)"Caught an exception during transaction", throwable);
            this.rollbackTransaction();
            throw new ContextException("Error in tx", throwable);
        }
    }

    public void setRollbackOnly() throws Exception {
        if (this._txm != null) {
            this._txm.setRollbackOnly();
        }
    }

    public <T> Future<T> execIsolatedTransaction(final Callable<T> callable) throws Exception, ContextException {
        return this._executorSvc.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return MockScheduler.this.execTransaction(callable);
            }
        });
    }

    public boolean isTransacted() {
        if (this._txm != null) {
            try {
                return this._txm.getTransaction() != null;
            }
            catch (SystemException systemException) {
                __log.error((Object)"Exception in mock scheduler isTransacted.", (Throwable)systemException);
                throw new RuntimeException(systemException);
            }
        }
        return this._transacted.get();
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public void registerSynchronizer(final Scheduler.Synchronizer synchronizer) throws ContextException {
        if (this._txm != null) {
            try {
                this._txm.getTransaction().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        synchronizer.beforeCompletion();
                    }

                    public void afterCompletion(int n) {
                        synchronizer.afterCompletion(n == 3);
                    }
                });
            }
            catch (Exception exception) {
                __log.error((Object)"Exception in mock scheduler sync registration.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        } else {
            this._synchros.get().add(synchronizer);
        }
    }

    public void beginTransaction() {
        if (this._txm != null) {
            try {
                this._txm.begin();
            }
            catch (Exception exception) {
                __log.error((Object)"Exception in mock scheduler begin.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        } else {
            this._synchros.get().clear();
        }
        this._transacted.set(Boolean.TRUE);
    }

    public void commitTransaction() {
        if (this._txm != null) {
            try {
                this._txm.commit();
            }
            catch (Exception exception) {
                __log.error((Object)"Exception in mock scheduler commit.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        } else {
            for (Scheduler.Synchronizer synchronizer : this._synchros.get()) {
                try {
                    synchronizer.beforeCompletion();
                }
                catch (Throwable throwable) {}
            }
            for (Scheduler.Synchronizer synchronizer : this._synchros.get()) {
                try {
                    synchronizer.afterCompletion(true);
                }
                catch (Throwable throwable) {}
            }
            this._synchros.get().clear();
        }
        this._transacted.set(Boolean.FALSE);
    }

    public void rollbackTransaction() {
        if (this._txm != null) {
            try {
                this._txm.rollback();
            }
            catch (Exception exception) {
                __log.error((Object)"Exception in mock scheduler rollback.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        } else {
            for (Scheduler.Synchronizer synchronizer : this._synchros.get()) {
                try {
                    synchronizer.beforeCompletion();
                }
                catch (Throwable throwable) {}
            }
            for (Scheduler.Synchronizer synchronizer : this._synchros.get()) {
                try {
                    synchronizer.afterCompletion(false);
                }
                catch (Throwable throwable) {}
            }
            this._synchros.get().clear();
        }
        this._transacted.set(Boolean.FALSE);
    }

    private void doExecute(Scheduler.JobInfo jobInfo) {
        Scheduler.JobProcessor jobProcessor = this._processor;
        if (jobProcessor == null) {
            throw new RuntimeException("No processor.");
        }
        try {
            jobProcessor.onScheduledJob(jobInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("Scheduled transaction failed unexpectedly: transaction will not be retried!.", exception);
        }
    }

    public void setJobProcessor(Scheduler.JobProcessor jobProcessor) throws ContextException {
        this._processor = jobProcessor;
    }

    public void setExecutorSvc(ExecutorService executorService) {
        this._executorSvc = executorService;
    }

    public void setPolledRunnableProcesser(Scheduler.JobProcessor jobProcessor) {
    }
}

