/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.pmapi.ProcessInfoCustomizer;
import org.apache.ode.il.OMUtils;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicService<T> {
    private final Log __log = LogFactory.getLog(this.getClass());
    static final OMFactory OM = OMAbstractFactory.getOMFactory();
    T _service;
    Class<T> _clazz;

    public DynamicService(T t) {
        this._clazz = t.getClass();
        this._service = t;
    }

    public OMElement invoke(String string, OMElement oMElement) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("Invoke: operation " + string + " on " + this._clazz + ":\n" + oMElement));
        }
        String string2 = string;
        try {
            Method method = this.findMethod(string2);
            Object[] objectArray = this.extractParams(method, oMElement);
            Object object = method.invoke(this._service, objectArray);
            OMElement oMElement2 = null;
            if (object != null) {
                oMElement2 = OM.createOMElement(new QName(oMElement.getNamespace().getNamespaceURI(), string2 + "Response"));
                OMElement oMElement3 = DynamicService.convertToOM(object);
                oMElement3 = DynamicService.stripNamespace(oMElement3);
                oMElement2.addChild((OMNode)oMElement3);
            }
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("Response: operation " + string + " on " + this._clazz + ":\n" + oMElement2));
            }
            return oMElement2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Couldn't invoke method named " + string2 + " in management interface!", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Invocation of method " + string2 + " in management interface failed: " + invocationTargetException.getTargetException().getMessage(), invocationTargetException.getTargetException());
        }
    }

    private Object[] extractParams(Method method, OMElement oMElement) {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[method.getParameterTypes().length];
        Iterator iterator = oMElement.getChildElements();
        int n = 0;
        for (Class<?> clazz : classArray) {
            OMElement oMElement2 = (OMElement)iterator.next();
            this.__log.debug((Object)("Extracting param " + clazz + " from " + oMElement2));
            objectArray[n++] = DynamicService.convertFromOM(clazz, oMElement2);
        }
        return objectArray;
    }

    private static Object convertFromOM(Class<?> clazz, OMElement oMElement) {
        if (oMElement == null || oMElement.getText().length() == 0 && !oMElement.getChildElements().hasNext()) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return oMElement.getText();
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return oMElement.getText().equals("true") || oMElement.getText().equals("yes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz.equals(QName.class)) {
            return OMUtils.getTextAsQName(oMElement);
        }
        if (clazz.equals(ProcessInfoCustomizer.class)) {
            return new ProcessInfoCustomizer(oMElement.getText());
        }
        if (Node.class.isAssignableFrom(clazz)) {
            return OMUtils.toDOM(oMElement.getFirstElement());
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Long.parseLong(oMElement.getText());
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Integer.parseInt(oMElement.getText());
        }
        if (clazz.isArray()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = oMElement.getChildElements();
            Class<?> clazz2 = clazz.getComponentType();
            while (iterator.hasNext()) {
                arrayList.add(DynamicService.parseType(clazz2, ((OMElement)iterator.next()).getText()));
            }
            return arrayList.toArray((Object[])Array.newInstance(clazz2, arrayList.size()));
        }
        if (XmlObject.class.isAssignableFrom(clazz)) {
            try {
                Class<?> clazz3 = Class.forName(clazz.getCanonicalName() + ".Factory");
                return clazz3.getMethod("parse", XMLStreamReader.class).invoke((Object)oMElement.getXMLStreamReaderWithoutCaching(), new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Couldn't find class " + clazz.getCanonicalName() + ".Factory to instantiate xml bean", classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Couldn't access class " + clazz.getCanonicalName() + ".Factory to instantiate xml bean", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Couldn't access xml bean parse method on class " + clazz.getCanonicalName() + ".Factory " + "to instantiate xml bean", invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Couldn't find xml bean parse method on class " + clazz.getCanonicalName() + ".Factory " + "to instantiate xml bean", noSuchMethodException);
            }
        }
        throw new RuntimeException("Couldn't use element " + oMElement + " to obtain a management method parameter.");
    }

    private static OMElement convertToOM(Object object) {
        if (object instanceof XmlObject) {
            try {
                return new StAXOMBuilder(((XmlObject)object).newInputStream()).getDocumentElement();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new RuntimeException("Couldn't serialize result to an outgoing messages.", xMLStreamException);
            }
        }
        if (object instanceof List) {
            OMElement oMElement = OM.createOMElement("list", null);
            for (Object e : (List)object) {
                OMElement oMElement2 = OM.createOMElement("element", null);
                oMElement2.setText(e.toString());
                oMElement.addChild((OMNode)oMElement2);
            }
            return oMElement;
        }
        throw new RuntimeException("Couldn't convert object " + object + " into a response element.");
    }

    private static OMElement stripNamespace(OMElement oMElement) {
        OMElement oMElement2 = OM.createOMElement(new QName("", oMElement.getLocalName()));
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement3 = (OMElement)iterator.next();
            oMElement3 = oMElement3.cloneOMElement();
            oMElement2.addChild((OMNode)oMElement3);
        }
        return oMElement2;
    }

    private Method findMethod(String string) {
        for (Method method : this._clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        throw new RuntimeException("Couldn't find any method named " + string + " in interface " + this._clazz.getName());
    }

    private static Object parseType(Class<?> clazz, String string) {
        if (clazz.equals(Integer.class)) {
            return Integer.valueOf(string);
        }
        if (clazz.equals(Float.class)) {
            return Integer.valueOf(string);
        }
        if (clazz.equals(String.class)) {
            return string;
        }
        return null;
    }
}

