/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDL11Endpoint
implements MutableEndpoint {
    private Element _serviceElmt;

    public WSDL11Endpoint() {
    }

    public WSDL11Endpoint(QName qName, String string, String string2) {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        document.appendChild(element);
        this._serviceElmt = document.createElementNS(Namespaces.WSDL_11, "service");
        element.appendChild(this._serviceElmt);
        if (qName != null) {
            this._serviceElmt.setAttribute("name", qName.getLocalPart());
            this._serviceElmt.setAttribute("targetNamespace", qName.getNamespaceURI());
        }
        Element element2 = document.createElementNS(Namespaces.WSDL_11, "port");
        if (string != null) {
            element2.setAttribute("name", string);
        }
        element2.setAttribute("binding", "");
        Element element3 = document.createElementNS(Namespaces.SOAP_NS, "address");
        if (string2 != null) {
            element3.setAttribute("location", string2);
        }
        this._serviceElmt.appendChild(element2);
        element2.appendChild(element3);
    }

    public WSDL11Endpoint(QName qName, String string) {
        this(qName, string, null);
    }

    public String getUrl() {
        Element element = (Element)this._serviceElmt.getElementsByTagNameNS(Namespaces.WSDL_11, "port").item(0);
        Element element2 = (Element)element.getElementsByTagNameNS(Namespaces.SOAP_NS, "address").item(0);
        if (element2 == null) {
            element2 = (Element)element.getElementsByTagNameNS(Namespaces.HTTP_NS, "address").item(0);
        }
        if (element2 == null) {
            throw new IllegalArgumentException("soap:address and http:address element in element " + DOMUtils.domToString((Node)this._serviceElmt) + " is missing or in the wrong namespace.");
        }
        return element2.getAttribute("location");
    }

    public QName getServiceName() {
        return new QName(this._serviceElmt.getAttribute("targetNamespace"), this._serviceElmt.getAttribute("name"));
    }

    public boolean accept(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (element.getLocalName().equals("service-ref") && (element.getNamespaceURI().equals(Namespaces.WS_BPEL_20_NS) || element.getNamespaceURI().equals(Namespaces.WSBPEL2_0_FINAL_SERVREF))) {
                element = DOMUtils.getFirstChildElement((Element)element);
            }
            if (element.getLocalName().equals("service") && element.getNamespaceURI().equals(Namespaces.WSDL_11)) {
                return true;
            }
        }
        return false;
    }

    public void set(Node node) {
        this._serviceElmt = node.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI()) ? DOMUtils.getFirstChildElement((Element)((Element)node)) : (Element)node;
    }

    public Document toXML() {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(Namespaces.WSBPEL2_0_FINAL_SERVREF, "service-ref");
        document.appendChild(element);
        element.appendChild(document.importNode(this._serviceElmt, true));
        return this._serviceElmt.getOwnerDocument();
    }

    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put("address", this.getUrl());
        hashMap.put("service", new QName(this._serviceElmt.getAttribute("targetNamespace"), this._serviceElmt.getAttribute("name")));
        Element element = DOMUtils.getFirstChildElement((Element)this._serviceElmt);
        hashMap.put("port", element.getAttribute("name"));
        return hashMap;
    }

    public void fromMap(Map map) {
        Object object;
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        document.appendChild(element);
        this._serviceElmt = document.createElementNS(Namespaces.WSDL_11, "service");
        element.appendChild(this._serviceElmt);
        if (map.get("service") != null) {
            object = (QName)map.get("service");
            this._serviceElmt.setAttribute("name", ((QName)object).getLocalPart());
            this._serviceElmt.setAttribute("targetNamespace", ((QName)object).getNamespaceURI());
        }
        object = document.createElementNS(Namespaces.WSDL_11, "port");
        if (map.get("port") != null) {
            object.setAttribute("name", (String)map.get("port"));
        }
        object.setAttribute("binding", "");
        Element element2 = document.createElementNS(Namespaces.SOAP_NS, "address");
        if (map.get("address") != null) {
            element2.setAttribute("location", (String)map.get("address"));
        }
        this._serviceElmt.appendChild((Node)object);
        object.appendChild(element2);
    }
}

