/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.agents.memory;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public class SizingAgent {
    private static Instrumentation instrumentation;

    public static void premain(String string, Instrumentation instrumentation) {
        SizingAgent.instrumentation = instrumentation;
        Class[] classArray = instrumentation.getAllLoadedClasses();
    }

    public static void main(String[] stringArray) {
        System.out.println("Size of Object: " + SizingAgent.sizeOf(new Object()));
        System.out.println("Size of direct subclass: " + SizingAgent.sizeOf(new SizingAgent()));
        System.out.println("Size of Calendar: " + SizingAgent.sizeOf(Calendar.getInstance()));
    }

    public static long sizeOf(Object object) {
        if (instrumentation == null) {
            return 0L;
        }
        if (SizingAgent.isSharedFlyweight(object)) {
            return 0L;
        }
        return instrumentation.getObjectSize(object);
    }

    public static long deepSizeOf(Object object) {
        if (instrumentation == null) {
            return 0L;
        }
        IdentityHashMap identityHashMap = new IdentityHashMap();
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        long l = 0L;
        do {
            l += SizingAgent.internalSizeOf(stack.pop(), stack, identityHashMap);
        } while (!stack.isEmpty());
        return l;
    }

    private static boolean isSharedFlyweight(Object object) {
        if (object instanceof Comparable) {
            if (object instanceof Enum) {
                return true;
            }
            if (object instanceof String) {
                return object == ((String)object).intern();
            }
            if (object instanceof Boolean) {
                return object == Boolean.TRUE || object == Boolean.FALSE;
            }
            if (object instanceof Integer) {
                return object == Integer.valueOf((Integer)object);
            }
            if (object instanceof Short) {
                return object == Short.valueOf((Short)object);
            }
            if (object instanceof Byte) {
                return object == Byte.valueOf((Byte)object);
            }
            if (object instanceof Long) {
                return object == Long.valueOf((Long)object);
            }
            if (object instanceof Character) {
                return object == Character.valueOf(((Character)object).charValue());
            }
        }
        return false;
    }

    private static boolean skipObject(Object object, Map map) {
        return object == null || map.containsKey(object) || SizingAgent.isSharedFlyweight(object);
    }

    private static long internalSizeOf(Object object, Stack stack, Map map) {
        if (SizingAgent.skipObject(object, map)) {
            return 0L;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            SizingAgent.addArrayElementsToStack(clazz, object, stack);
        } else {
            while (clazz != null) {
                Field[] fieldArray;
                for (Field field : fieldArray = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    try {
                        stack.add(field.get(object));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        map.put(object, null);
        return SizingAgent.sizeOf(object);
    }

    private static void addArrayElementsToStack(Class clazz, Object object, Stack stack) {
        if (!clazz.getComponentType().isPrimitive()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                stack.add(Array.get(object, i));
            }
        }
    }
}

