/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.renderer.AbstractScheduleRenderer;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public class ScheduleDetailedDayRenderer
extends AbstractScheduleRenderer
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$schedule$renderer$ScheduleDetailedDayRenderer == null ? (class$org$apache$myfaces$custom$schedule$renderer$ScheduleDetailedDayRenderer = ScheduleDetailedDayRenderer.class$("org.apache.myfaces.custom.schedule.renderer.ScheduleDetailedDayRenderer")) : class$org$apache$myfaces$custom$schedule$renderer$ScheduleDetailedDayRenderer));
    private static final long serialVersionUID = -5103791076091317355L;
    private final int defaultRowHeightInPixels = 22;
    static /* synthetic */ Class class$org$apache$myfaces$custom$schedule$renderer$ScheduleDetailedDayRenderer;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        int rowHeight = this.getRowHeight(schedule.getAttributes());
        int numberOfRows = (this.getRenderedEndHour(schedule) - this.getRenderedStartHour(schedule)) * 2 + 1;
        int gridHeight = numberOfRows * rowHeight + 3 + 10;
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)("schedule-detailed-" + this.getTheme((UIComponent)schedule)), null);
        writer.writeAttribute("style", (Object)("height: " + String.valueOf(gridHeight) + "px; overflow: hidden;"), null);
        this.writeBackground(context, schedule, writer);
        this.writeForegroundStart(context, schedule, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            String dayBodyId = clientId + "_body_" + ScheduleUtil.getDateId(day.getDate());
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "column"), null);
            writer.writeAttribute("style", (Object)"height: 100%;", null);
            writer.startElement("div", (UIComponent)schedule);
            writer.writeAttribute("id", (Object)dayBodyId, null);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "column"), null);
            writer.writeAttribute("style", (Object)"position: relative; top: 0px; left: 0px; width: 100%; height: 100%; z-index: 0;", null);
            if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
                writer.writeAttribute("onmouseup", (Object)("fireScheduleTimeClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
            }
            this.writeEntries(context, schedule, day, writer);
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        this.writeForegroundEnd(writer);
        writer.endElement("div");
    }

    protected String getCellClass(HtmlSchedule schedule, int column, int row, int hour) {
        String cellClass = "free";
        ScheduleDay day = (ScheduleDay)schedule.getModel().get(column);
        if (!day.isWorkingDay()) {
            return this.getStyleClass((UIComponent)schedule, cellClass);
        }
        if (hour >= schedule.getWorkingStartHour() && hour < schedule.getWorkingEndHour()) {
            cellClass = row % 2 == 0 ? "even" : "uneven";
        }
        return this.getStyleClass((UIComponent)schedule, cellClass);
    }

    protected boolean isSelected(HtmlSchedule schedule, EntryWrapper entry) {
        ScheduleEntry selectedEntry = schedule.getModel().getSelectedEntry();
        if (selectedEntry == null) {
            return false;
        }
        boolean returnboolean = selectedEntry.getId().equals(entry.entry.getId());
        return returnboolean;
    }

    protected void maximizeEntries(EntryWrapper[] entries, int numberOfColumns) {
        for (int i = 0; i < entries.length; ++i) {
            EntryWrapper entry = entries[i];
            while (entry.column + entry.colspan < numberOfColumns && entry.canFitInColumn(entry.column + entry.colspan)) {
                entry.colspan++;
            }
        }
    }

    protected void scanEntries(EntryWrapper[] entries, int index) {
        if (entries.length <= 0) {
            return;
        }
        EntryWrapper entry = entries[index];
        entry.column = 0;
        for (int i = 0; i < index; ++i) {
            if (!entry.overlaps(entries[i])) continue;
            entry.overlappingEntries.add(entries[i]);
            entries[i].overlappingEntries.add(entry);
        }
        while (!entry.canFitInColumn(entry.column)) {
            entry.column++;
        }
        if (++index < entries.length) {
            this.scanEntries(entries, index);
        }
    }

    protected void writeBackground(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        int rowHeight = this.getRowHeight(schedule.getAttributes()) - 1;
        int headerHeight = rowHeight + 10;
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "background"), null);
        writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; z-index: 0;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "background"), null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        writer.startElement("tbody", (UIComponent)schedule);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "gutter"), null);
        writer.writeAttribute("style", (Object)("height: " + rowHeight + "px; border-style: none; border-width: 0px; overflow: hidden; padding: 0px"), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
        float columnWidth = schedule.getModel().size() == 0 ? 100.0f : (float)(100 / schedule.getModel().size());
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "header"), null);
            writer.writeAttribute("style", (Object)("height: " + headerHeight + "px; border-style: none; border-width: 0px; overflow: hidden;"), null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.startElement("div", (UIComponent)schedule);
            writer.writeAttribute("style", (Object)"position: relative; left: 0px; top: 0px; width: 100%; height: 100%;", null);
            writer.startElement("span", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "date"), null);
            writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; height: 15px; width: 100%; vertical-align: top; overflow: hidden; white-space: nowrap;", null);
            writer.writeText((Object)this.getDateString(context, (UIComponent)schedule, day.getDate()), null);
            writer.endElement("span");
            if (day.getSpecialDayName() != null && day.getSpecialDayName().length() > 0) {
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "holiday"), null);
                writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 15px; width: 100%; vertical-align: top; overflow: hidden; white-space: nowrap;", null);
                writer.writeText((Object)day.getSpecialDayName(), null);
                writer.endElement("span");
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        int startHour = this.getRenderedStartHour(schedule);
        int endHour = this.getRenderedEndHour(schedule);
        int numberOfRows = (endHour - startHour) * 2;
        for (int row = 0; row < numberOfRows; ++row) {
            writer.startElement("tr", (UIComponent)schedule);
            if (row % 2 == 0) {
                writer.startElement("td", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "gutter"), null);
                writer.writeAttribute("style", (Object)("height: " + rowHeight + "px; border-style: none; border-width: 0px; overflow: hidden; padding: 0px"), null);
                writer.writeAttribute("rowspan", (Object)"2", null);
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "hours"), null);
                writer.writeAttribute("style", (Object)"vertical-align: top; height: 100%; padding: 0px;", null);
                writer.writeText((Object)String.valueOf(startHour + row / 2), null);
                writer.endElement("span");
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "minutes"), null);
                writer.writeAttribute("style", (Object)"vertical-align: top; height: 100%; padding: 0px;", null);
                writer.writeText((Object)"00", null);
                writer.endElement("span");
                writer.endElement("td");
            }
            for (int column = 0; column < schedule.getModel().size(); ++column) {
                writer.startElement("td", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getCellClass(schedule, column, row, startHour + row / 2), null);
                writer.writeAttribute("style", (Object)("overflow: hidden; height: " + rowHeight + "px;"), null);
                writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
                writer.write("&#160;");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected int getRenderedStartHour(HtmlSchedule schedule) {
        int startHour = schedule.getVisibleStartHour();
        if (!this.expandToFitEntries((UIComponent)schedule)) {
            return startHour;
        }
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            int dayStart = day.getFirstEventHour();
            if (dayStart >= startHour) continue;
            startHour = dayStart;
        }
        return startHour;
    }

    protected int getRenderedEndHour(HtmlSchedule schedule) {
        int endHour = schedule.getVisibleEndHour();
        if (!this.expandToFitEntries((UIComponent)schedule)) {
            return endHour;
        }
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            int dayEnd = day.getLastEventHour();
            if (dayEnd <= endHour) continue;
            endHour = dayEnd;
        }
        return endHour;
    }

    protected void writeEntries(FacesContext context, HtmlSchedule schedule, ScheduleDay day, ResponseWriter writer) throws IOException {
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        TreeSet<EntryWrapper> entrySet = new TreeSet<EntryWrapper>();
        Iterator entryIterator = day.iterator();
        while (entryIterator.hasNext()) {
            entrySet.add(new EntryWrapper((ScheduleEntry)entryIterator.next(), day));
        }
        EntryWrapper[] entries = entrySet.toArray(new EntryWrapper[entrySet.size()]);
        this.scanEntries(entries, 0);
        int maxColumn = 0;
        Iterator entryIterator2 = entrySet.iterator();
        while (entryIterator2.hasNext()) {
            EntryWrapper wrapper = (EntryWrapper)entryIterator2.next();
            maxColumn = Math.max(wrapper.column, maxColumn);
        }
        int numberOfColumns = maxColumn + 1;
        this.maximizeEntries(entries, numberOfColumns);
        float columnWidth = 100 / numberOfColumns;
        Iterator entryIterator3 = entrySet.iterator();
        while (entryIterator3.hasNext()) {
            EntryWrapper wrapper = (EntryWrapper)entryIterator3.next();
            boolean selected = this.isSelected(schedule, wrapper);
            StringBuffer entryStyle = new StringBuffer();
            entryStyle.append(wrapper.getBounds(schedule, columnWidth));
            String entryBorderColor = this.getEntryRenderer((UIComponent)schedule).getColor(context, schedule, wrapper.entry, selected);
            if (entryBorderColor != null) {
                entryStyle.append(" border-color: ");
                entryStyle.append(entryBorderColor);
                entryStyle.append(";");
            }
            if (selected) {
                writer.startElement("div", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "entry-selected"), null);
                writer.writeAttribute("style", (Object)entryStyle.toString(), null);
                if (this.showTooltip((UIComponent)schedule)) {
                    this.getEntryRenderer((UIComponent)schedule).renderToolTip(context, writer, schedule, wrapper.entry, selected);
                }
                this.getEntryRenderer((UIComponent)schedule).renderContent(context, writer, schedule, day, wrapper.entry, false, selected);
                writer.endElement("div");
                continue;
            }
            writer.startElement(schedule.isReadonly() ? "div" : "a", (UIComponent)schedule);
            if (this.showTooltip((UIComponent)schedule)) {
                this.getEntryRenderer((UIComponent)schedule).renderToolTip(context, writer, schedule, wrapper.entry, selected);
            }
            if (!schedule.isReadonly()) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onmouseup", (Object)("fireEntrySelected('" + formId + "', '" + clientId + "', '" + wrapper.entry.getId() + "');"), null);
            }
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "entry"), null);
            writer.writeAttribute("style", (Object)entryStyle.toString(), null);
            this.getEntryRenderer((UIComponent)schedule).renderContent(context, writer, schedule, day, wrapper.entry, false, selected);
            writer.endElement(schedule.isReadonly() ? "div" : "a");
        }
    }

    protected void writeForegroundEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void writeForegroundStart(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        int rowHeight = this.getRowHeight(schedule.getAttributes()) - 1;
        int headerHeight = rowHeight + 10;
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "foreground"), null);
        writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;\tz-index: 2;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "foreground"), null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
        float columnWidth = schedule.getModel().size() == 0 ? 100.0f : (float)(100 / schedule.getModel().size());
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            String dayHeaderId = clientId + "_header_" + ScheduleUtil.getDateId(day.getDate());
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("id", (Object)dayHeaderId, null);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "header"), null);
            writer.writeAttribute("style", (Object)("height: " + headerHeight + "px; border-style: none; border-width: 0px; overflow: hidden;"), null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
                writer.writeAttribute("onmouseup", (Object)("fireScheduleDateClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
            }
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
    }

    protected String getRowHeightProperty() {
        return "detailedRowHeight";
    }

    protected int getDefaultRowHeight() {
        return 22;
    }

    protected Date determineLastClickedDate(HtmlSchedule schedule, String dateId, String yPos) {
        Calendar cal = GregorianCalendar.getInstance();
        String day = dateId.substring(dateId.lastIndexOf("_") + 1);
        Date date = ScheduleUtil.getDateFromId(day);
        if (date != null) {
            cal.setTime(date);
        }
        cal.set(11, this.getRenderedStartHour(schedule));
        try {
            int y = Integer.parseInt(yPos);
            int halfHourHeight = this.getRowHeight(schedule.getAttributes());
            int minutes = y * 30 / halfHourHeight;
            cal.add(12, minutes);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)"y position is not a number");
        }
        log.debug((Object)("last clicked datetime: " + cal.getTime()));
        return cal.getTime();
    }

    protected boolean renderZeroLengthEntries(UIComponent component) {
        Boolean value;
        ValueBinding binding = component.getValueBinding("renderZeroLengthEntries");
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return Boolean.valueOf((String)attributes.get("renderZeroLengthEntries"));
    }

    protected boolean expandToFitEntries(UIComponent component) {
        Boolean value;
        ValueBinding binding = component.getValueBinding("expandToFitEntries");
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return Boolean.valueOf((String)attributes.get("expandToFitEntries"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntryWrapper
    implements Comparable {
        private static final int HALF_HOUR = 1800000;
        private final ScheduleDay day;
        private final ScheduleEntry entry;
        private final TreeSet overlappingEntries;
        private int colspan;
        private int column;

        EntryWrapper(ScheduleEntry entry, ScheduleDay day) {
            this.entry = entry;
            this.day = day;
            this.column = 0;
            this.colspan = 1;
            this.overlappingEntries = new TreeSet();
        }

        public int compareTo(Object o) {
            return AbstractScheduleRenderer.comparator.compare(this.entry, o);
        }

        public boolean equals(Object o) {
            if (o instanceof EntryWrapper) {
                EntryWrapper other = (EntryWrapper)o;
                boolean returnboolean = this.entry.getStartTime().equals(other.entry.getStartTime()) && this.entry.getEndTime().equals(other.entry.getEndTime()) && this.entry.getId().equals(other.entry.getId()) && this.day.equals(other.day);
                return returnboolean;
            }
            return false;
        }

        public int hashCode() {
            int returnint = this.entry.getStartTime().hashCode() ^ this.entry.getEndTime().hashCode() ^ this.entry.getId().hashCode();
            return returnint;
        }

        String getBounds(HtmlSchedule schedule, float columnWidth) {
            boolean entryVisible;
            int rowHeight = ScheduleDetailedDayRenderer.this.getRowHeight(schedule.getAttributes());
            float width = columnWidth * (float)this.colspan - 0.5f;
            float left = (float)this.column * columnWidth;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(this.day.getDate());
            int curyear = cal.get(1);
            int curmonth = cal.get(2);
            int curday = cal.get(5);
            cal.setTime(this.entry.getStartTime());
            cal.set(curyear, curmonth, curday);
            long startMillis = cal.getTimeInMillis();
            cal.set(11, ScheduleDetailedDayRenderer.this.getRenderedStartHour(schedule));
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleStartMillis = cal.getTimeInMillis();
            startMillis = this.day.equalsDate(this.entry.getStartTime()) ? Math.max(startMillis, visibleStartMillis) : visibleStartMillis;
            cal.setTime(this.entry.getEndTime());
            cal.set(curyear, curmonth, curday);
            long endMillis = cal.getTimeInMillis();
            cal.set(11, ScheduleDetailedDayRenderer.this.getRenderedEndHour(schedule));
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleEndMillis = cal.getTimeInMillis();
            endMillis = this.day.equalsDate(this.entry.getEndTime()) ? Math.min(endMillis, visibleEndMillis) : visibleEndMillis;
            int top = (int)((startMillis - visibleStartMillis) * (long)rowHeight / 1800000L);
            int height = (int)((endMillis - startMillis) * (long)rowHeight / 1800000L);
            StringBuffer buffer = new StringBuffer();
            boolean bl = entryVisible = height > 0 || ScheduleDetailedDayRenderer.this.renderZeroLengthEntries((UIComponent)schedule);
            if (!entryVisible) {
                buffer.append("visibility: hidden; ");
            }
            buffer.append("position: absolute; height: ");
            if (height > 0) {
                buffer.append(height + "px");
            } else if (entryVisible) {
                buffer.append("auto");
            } else {
                buffer.append("0px");
            }
            buffer.append("; top: ");
            buffer.append(top);
            buffer.append("px; left: ");
            buffer.append(left);
            buffer.append("%; width: ");
            buffer.append(width);
            buffer.append("%; padding: 0px; overflow: hidden; border-width: 1.0px; border-style:solid;");
            return buffer.toString();
        }

        boolean canFitInColumn(int column) {
            Iterator overlapIterator = this.overlappingEntries.iterator();
            while (overlapIterator.hasNext()) {
                EntryWrapper overlap = (EntryWrapper)overlapIterator.next();
                if (overlap.column != column) continue;
                return false;
            }
            return true;
        }

        Date minimumEndTime() {
            Date start = this.entry.getStartTime();
            Date end = this.entry.getEndTime();
            return end != null ? (end.after(start) ? end : new Date(start.getTime() + 1800000L)) : null;
        }

        boolean overlaps(EntryWrapper other) {
            Date start = this.entry.getStartTime();
            Date end = this.minimumEndTime();
            if (start == null || end == null) {
                return false;
            }
            boolean returnboolean = start.before(other.minimumEndTime()) && end.after(other.entry.getStartTime());
            return returnboolean;
        }
    }
}

