/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.renderer.ScheduleEntryRenderer;

public class DefaultScheduleEntryRenderer
implements ScheduleEntryRenderer,
Serializable {
    private static final long serialVersionUID = 4987926168243581739L;

    public void renderContent(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, ScheduleEntry entry, boolean compact, boolean selected) throws IOException {
        if (compact) {
            this.renderCompactContent(context, writer, schedule, day, entry, selected);
        } else if (selected) {
            StringBuffer entryStyle = new StringBuffer();
            entryStyle.append("height: 100%; width: 100%;");
            String entryColor = this.getColor(context, schedule, entry, selected);
            if (entryColor != null) {
                entryStyle.append("border-color: ");
                entryStyle.append(entryColor);
                entryStyle.append(";");
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "text"), null);
            writer.writeAttribute("style", (Object)entryStyle.toString(), null);
            this.renderDetailedContentText(context, writer, schedule, day, entry, selected);
            writer.endElement("div");
        } else {
            this.renderDetailedContentText(context, writer, schedule, day, entry, selected);
        }
    }

    protected void renderCompactContent(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, ScheduleEntry entry, boolean selected) throws IOException {
        StringBuffer text = new StringBuffer();
        Date startTime = entry.getStartTime();
        if (day.getDayStart().after(entry.getStartTime())) {
            startTime = day.getDayStart();
        }
        Date endTime = entry.getEndTime();
        if (day.getDayEnd().before(entry.getEndTime())) {
            endTime = day.getDayEnd();
        }
        if (!entry.isAllDay()) {
            DateFormat format = DateFormat.getTimeInstance(3);
            text.append(format.format(startTime));
            if (!startTime.equals(endTime)) {
                text.append("-");
                text.append(format.format(endTime));
            }
            text.append(": ");
        }
        text.append(entry.getTitle());
        writer.writeText((Object)text.toString(), null);
    }

    protected void renderDetailedContentText(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, ScheduleEntry entry, boolean selected) throws IOException {
        if (entry.getTitle() != null) {
            writer.startElement("span", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "title"), null);
            writer.writeText((Object)entry.getTitle(), null);
            writer.endElement("span");
        }
        if (entry.getSubtitle() != null) {
            writer.startElement("br", (UIComponent)schedule);
            writer.endElement("br");
            writer.startElement("span", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "subtitle"), null);
            writer.writeText((Object)entry.getSubtitle(), null);
            writer.endElement("span");
        }
    }

    public String getColor(FacesContext context, HtmlSchedule schedule, ScheduleEntry entry, boolean selected) {
        return null;
    }

    public void renderToolTip(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleEntry entry, boolean selected) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("return makeTrue(domTT_activate(this, event, 'caption', '");
        if (entry.getTitle() != null) {
            buffer.append(this.escape(entry.getTitle()));
        }
        buffer.append("', 'content', '<i>");
        if (entry.getSubtitle() != null) {
            buffer.append(this.escape(entry.getSubtitle()));
        }
        buffer.append("</i>");
        if (entry.getDescription() != null) {
            buffer.append("<br/>");
            buffer.append(this.escape(entry.getDescription()));
        }
        buffer.append("', 'trail', true));");
        writer.writeAttribute("onmouseover", (Object)buffer.toString(), null);
    }

    private String escape(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("'", "\\\\'").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
    }

    protected String getStyleClass(UIComponent component, String className) {
        String value;
        ValueBinding binding = component.getValueBinding(className);
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        String returnValue = (String)attributes.get(className);
        return returnValue == null ? className : returnValue;
    }
}

