/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;

public class ScheduleDay
extends Day
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final TreeSet entries = new TreeSet(new ScheduleEntryComparator());

    public ScheduleDay(Date date) {
        super(date);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean addEntry(ScheduleEntry entry) {
        if (entry == null || entry.getStartTime() == null || entry.getEndTime() == null) {
            return false;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(entry.getEndTime());
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        cal.setTime(entry.getStartTime());
        while (cal.getTime().before(endDate)) {
            if (this.equalsDate(cal.getTime())) {
                this.entries.add(entry);
                return true;
            }
            cal.add(5, 1);
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public boolean remove(ScheduleEntry entry) {
        return this.entries.remove(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public int getLastEventHour() {
        Calendar endTime = GregorianCalendar.getInstance();
        Date lastEnd = null;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ScheduleEntry next = (ScheduleEntry)it.next();
            if (next.isAllDay() || lastEnd != null && !lastEnd.before(next.getEndTime())) continue;
            lastEnd = next.getEndTime();
        }
        if (lastEnd == null) {
            return 0;
        }
        endTime.setTime(lastEnd);
        if (endTime.get(12) > 0) {
            endTime.add(11, 1);
        }
        return this.equalsDate(endTime.getTime()) ? endTime.get(11) : 24;
    }

    public int getFirstEventHour() {
        Calendar startTime = null;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ScheduleEntry next = (ScheduleEntry)it.next();
            if (next.isAllDay()) continue;
            startTime = GregorianCalendar.getInstance();
            startTime.setTime(next.getStartTime());
            break;
        }
        if (startTime == null) {
            return 24;
        }
        return this.equalsDate(startTime.getTime()) ? startTime.get(11) : 0;
    }
}

