/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;

public class Day
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final Date date;
    private final Date dayEnd;
    private final Date dayStart;
    private String specialDayName;
    private boolean workingDay;

    public Day(Date date) {
        this.date = date;
        if (date == null) {
            throw new NullPointerException("date should not be null");
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.dayStart = cal.getTime();
        cal.add(5, 1);
        this.dayEnd = cal.getTime();
    }

    public Date getDate() {
        return this.date == null ? new Date() : this.date;
    }

    public Date getDayEnd() {
        return this.dayEnd;
    }

    public Date getDayStart() {
        return this.dayStart;
    }

    public void setSpecialDayName(String specialDayName) {
        this.specialDayName = specialDayName;
    }

    public String getSpecialDayName() {
        return this.specialDayName;
    }

    public void setWorkingDay(boolean workingDay) {
        this.workingDay = workingDay;
    }

    public boolean isWorkingDay() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(this.date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 7 || dayOfWeek == 1) {
            return false;
        }
        return this.workingDay;
    }

    public int compareTo(Object o) {
        if (o instanceof Day) {
            Day other = (Day)o;
            int returnint = ScheduleUtil.compareDays(this.date, other.getDate());
            return returnint;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof Day) {
            Day other = (Day)o;
            return ScheduleUtil.isSameDay(this.date, other.getDate());
        }
        return false;
    }

    public boolean equalsDate(Date date) {
        if (date == null) {
            return false;
        }
        return ScheduleUtil.isSameDay(date, this.date);
    }

    public int hashCode() {
        return ScheduleUtil.getHashCodeForDay(this.date);
    }
}

