/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.module.xhtml.XhtmlSink;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractMavenReport
extends AbstractMojo
implements MavenReport {
    private Sink sink;
    private Locale locale = Locale.ENGLISH;
    private File reportOutputDirectory;

    protected abstract SiteRenderer getSiteRenderer();

    protected abstract String getOutputDirectory();

    protected abstract MavenProject getProject();

    public void execute() throws MojoExecutionException {
        try {
            String outputDirectory = this.getOutputDirectory();
            XhtmlSink sink = new XhtmlSink(this.getSiteRenderer().createSink(new File(outputDirectory), this.getOutputName() + ".html", outputDirectory, this.getSiteDescriptor(), "maven"));
            this.generate(sink, Locale.ENGLISH);
            this.getSiteRenderer().copyResources(outputDirectory, "maven");
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(this.locale) + " report generation.", e);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        if (sink == null) {
            throw new MavenReportException("You must specify a sink.");
        }
        this.sink = sink;
        this.executeReport(locale);
        this.closeReport();
    }

    protected abstract void executeReport(Locale var1) throws MavenReportException;

    protected void closeReport() {
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    private String getReportsMenu() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<menu name=\"Project Documentation\">\n");
        buffer.append("  <item name=\"" + this.getName(this.locale) + "\" href=\"/" + this.getOutputName() + ".html\"/>\n");
        buffer.append("</menu>\n");
        return buffer.toString();
    }

    private InputStream getSiteDescriptor() throws MojoExecutionException {
        String siteDescriptorContent = "";
        try {
            siteDescriptorContent = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/default-report.xml"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("The site descriptor cannot be read!", (Exception)e);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("reports", this.getReportsMenu());
        if (this.getProject().getName() != null) {
            props.put("project.name", this.getProject().getName());
        } else {
            props.put("project.name", "NO_PROJECT_NAME_SET");
        }
        if (this.getProject().getUrl() != null) {
            props.put("project.url", this.getProject().getUrl());
        } else {
            props.put("project.url", "NO_PROJECT_URL_SET");
        }
        siteDescriptorContent = StringUtils.interpolate((String)siteDescriptorContent, props);
        return new StringInputStream(siteDescriptorContent);
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public Sink getSink() {
        return this.sink;
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public abstract /* synthetic */ String getDescription(Locale var1);

    public abstract /* synthetic */ String getName(Locale var1);

    public abstract /* synthetic */ String getOutputName();
}

