/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml.decoration.model;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.doxia.module.xhtml.decoration.model.Banner;
import org.apache.maven.doxia.module.xhtml.decoration.model.DecorationModel;
import org.apache.maven.doxia.module.xhtml.decoration.model.Image;
import org.apache.maven.doxia.module.xhtml.decoration.model.Item;
import org.apache.maven.doxia.module.xhtml.decoration.model.Link;
import org.apache.maven.doxia.module.xhtml.decoration.model.Menu;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class DecorationModelReader {
    public DecorationModel createNavigation(String siteFile) throws Exception {
        File navigationFile = new File(siteFile);
        if (navigationFile.exists()) {
            return this.createNavigation(new FileReader(navigationFile));
        }
        return this.getDecorationModel();
    }

    public DecorationModel createNavigation(Reader reader) throws Exception {
        Xpp3Dom be;
        DecorationModel decorationModel = this.getDecorationModel();
        Xpp3Dom siteElement = Xpp3DomBuilder.build((Reader)reader);
        Xpp3Dom flavourChild = siteElement.getChild("flavour");
        if (flavourChild != null) {
            decorationModel.setFlavour(flavourChild.getChild("name").getValue());
        }
        if ((be = siteElement.getChild("bannerLeft")) != null) {
            decorationModel.setBannerLeft(DecorationModelReader.processBanner(be));
        }
        if ((be = siteElement.getChild("bannerRight")) != null) {
            decorationModel.setBannerRight(DecorationModelReader.processBanner(be));
        }
        Xpp3Dom body = siteElement.getChild("body");
        int children = body.getChildCount();
        for (int i = 0; i < children; ++i) {
            Xpp3Dom element = body.getChild(i);
            if (element.getName().equals("menu")) {
                Menu menu = new Menu(element.getAttribute("name"));
                int items = element.getChildCount();
                for (int j = 0; j < items; ++j) {
                    Xpp3Dom itemElement = element.getChild(j);
                    menu.addItem(this.processItem(itemElement, decorationModel));
                }
                decorationModel.addMenu(menu);
                continue;
            }
            if (element.getName().equals("links")) {
                int count = element.getChildCount();
                for (int j = 0; j < count; ++j) {
                    Xpp3Dom item = element.getChild(j);
                    Link link = new Link(item.getAttribute("name"), item.getAttribute("href"));
                    decorationModel.addLink(link);
                }
                continue;
            }
            if (!element.getName().equals("search")) continue;
            decorationModel.setSearch(true);
        }
        return decorationModel;
    }

    private static Banner processBanner(Xpp3Dom be) {
        Banner b = new Banner();
        Image i = new Image();
        if (be.getChild("href") != null) {
            Link bl = new Link();
            bl.setHref(be.getChild("href").getValue());
            b.setLink(bl);
        }
        if (be.getChild("name") != null) {
            String value = be.getChild("name").getValue();
            i.setTitle(value);
            b.setName(value);
        }
        if (be.getChild("src") != null) {
            i.setSrc(be.getChild("src").getValue());
            b.setImage(i);
        }
        return b;
    }

    private DecorationModel getDecorationModel() {
        return new DecorationModel();
    }

    private Item processItem(Xpp3Dom itemElement, DecorationModel navigation) {
        String name = itemElement.getAttribute("name");
        String href = itemElement.getAttribute("href");
        Item item = new Item(name, href);
        navigation.addItemGroup(href, name);
        if (itemElement.getAttribute("collapse") != null) {
            item.setFoldable(true);
        }
        int items = itemElement.getChildCount();
        for (int i = 0; i < items; ++i) {
            Xpp3Dom subItemElement = itemElement.getChild(i);
            Item subitem = this.processItem(subItemElement, navigation);
            subitem.setGroup(item.getGroup());
            navigation.addItemGroup(subitem.getHref(), subitem.getGroup());
            item.addItem(subitem);
        }
        return item;
    }
}

