/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.yahooweather.types;

import com.sun.syndication.feed.impl.EqualsBean;
import com.sun.syndication.feed.impl.ToStringBean;
import java.io.Serializable;

public class Atmosphere
implements Serializable,
Cloneable {
    private EqualsBean equals = new EqualsBean(Atmosphere.class, this);
    private ToStringBean toString = new ToStringBean(Atmosphere.class, this);
    private int humidity;
    private double visibility;
    private double pressure;
    private PressureChange change;

    public Atmosphere() {
    }

    public Atmosphere(int humidity, double visibility, double pressure, PressureChange change) {
        this.humidity = humidity;
        this.visibility = visibility;
        this.pressure = pressure;
        this.change = change;
    }

    public boolean equals(Object o) {
        return this.equals.equals(o);
    }

    public int hashCode() {
        return this.equals.hashCode();
    }

    public String toString() {
        return this.toString.toString();
    }

    public int getHumidity() {
        return this.humidity;
    }

    public void setHumidity(int humidity) {
        this.humidity = humidity;
    }

    public double getVisibility() {
        return this.visibility;
    }

    public void setVisibility(double visibility) {
        this.visibility = visibility;
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public PressureChange getChange() {
        return this.change;
    }

    public void setChange(PressureChange change) {
        this.change = change;
    }

    public Object clone() {
        return new Atmosphere(this.humidity, this.visibility, this.pressure, this.change);
    }

    public static class PressureChange
    implements Serializable {
        public static final PressureChange RISING = new PressureChange(1, "rising");
        public static final PressureChange STEADY = new PressureChange(0, "steady");
        public static final PressureChange FALLING = new PressureChange(2, "falling");
        private int code;
        private String text;

        private PressureChange(int code, String text) {
            this.code = code;
            this.text = text;
        }

        public String toString() {
            return "[ code: " + this.code + " (" + this.text + ")]";
        }

        public int getCode() {
            return this.code;
        }

        public static PressureChange fromCode(int code) {
            switch (code) {
                case 0: {
                    return STEADY;
                }
                case 1: {
                    return RISING;
                }
                case 2: {
                    return FALLING;
                }
            }
            throw new RuntimeException("Invalid pressure change code.");
        }
    }
}

