/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.yahooweather.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.yahooweather.YWeatherModuleImpl;
import org.rometools.feed.module.yahooweather.types.Astronomy;
import org.rometools.feed.module.yahooweather.types.Atmosphere;
import org.rometools.feed.module.yahooweather.types.Condition;
import org.rometools.feed.module.yahooweather.types.ConditionCode;
import org.rometools.feed.module.yahooweather.types.Forecast;
import org.rometools.feed.module.yahooweather.types.Location;
import org.rometools.feed.module.yahooweather.types.Units;
import org.rometools.feed.module.yahooweather.types.Wind;

public class WeatherModuleParser
implements ModuleParser {
    private static final SimpleDateFormat TIME_ONLY = new SimpleDateFormat("h:mm a");
    private static final SimpleDateFormat LONG_DATE = new SimpleDateFormat("EEE, d MMM yyyy h:mm a zzz");
    private static final SimpleDateFormat SHORT_DATE = new SimpleDateFormat("d MMM yyyy");
    private static final Namespace NS = Namespace.getNamespace((String)"http://xml.weather.yahoo.com/ns/rss/1.0");

    @Override
    public String getNamespaceUri() {
        return "http://xml.weather.yahoo.com/ns/rss/1.0";
    }

    @Override
    public Module parse(Element element) {
        List forecasts;
        Element condition;
        Element astronomy;
        Element atmosphere;
        Element wind;
        Element units;
        YWeatherModuleImpl module = new YWeatherModuleImpl();
        Element location = element.getChild("location", NS);
        if (location != null) {
            Location l = new Location(location.getAttributeValue("city"), location.getAttributeValue("region"), location.getAttributeValue("country"));
            module.setLocation(l);
        }
        if ((units = element.getChild("units", NS)) != null) {
            Units u = new Units(units.getAttributeValue("temperature"), units.getAttributeValue("distance"), units.getAttributeValue("pressure"), units.getAttributeValue("speed"));
            module.setUnits(u);
        }
        if ((wind = element.getChild("wind", NS)) != null) {
            try {
                Wind w = new Wind(Integer.parseInt(wind.getAttributeValue("chill")), Integer.parseInt(wind.getAttributeValue("direction")), Integer.parseInt(wind.getAttributeValue("speed")));
                module.setWind(w);
            }
            catch (NumberFormatException nfe) {
                Logger.getAnonymousLogger().warning("NumberFormatException processing <wind> tag.");
            }
        }
        if ((atmosphere = element.getChild("atmosphere", NS)) != null) {
            try {
                Atmosphere a = new Atmosphere(Integer.parseInt(atmosphere.getAttributeValue("humidity")), Double.parseDouble(atmosphere.getAttributeValue("visibility")) / 100.0, Double.parseDouble(atmosphere.getAttributeValue("pressure")), Atmosphere.PressureChange.fromCode(Integer.parseInt(atmosphere.getAttributeValue("rising"))));
                module.setAtmosphere(a);
            }
            catch (NumberFormatException nfe) {
                Logger.getAnonymousLogger().warning("NumberFormatException processing <atmosphere> tag.");
            }
        }
        if ((astronomy = element.getChild("astronomy", NS)) != null) {
            try {
                Astronomy a = new Astronomy(TIME_ONLY.parse(astronomy.getAttributeValue("sunrise").replaceAll("am", "AM").replaceAll("pm", "PM")), TIME_ONLY.parse(astronomy.getAttributeValue("sunset").replaceAll("am", "AM").replaceAll("pm", "PM")));
                module.setAstronomy(a);
            }
            catch (ParseException pe) {
                Logger.getAnonymousLogger().warning("ParseException processing <astronomy> tag.");
            }
        }
        if ((condition = element.getChild("condition", NS)) != null) {
            try {
                Condition c = new Condition(condition.getAttributeValue("text"), ConditionCode.fromCode(Integer.parseInt(condition.getAttributeValue("code"))), Integer.parseInt(condition.getAttributeValue("temp")), LONG_DATE.parse(condition.getAttributeValue("date").replaceAll("pm", "PM").replaceAll("am", "AM")));
                module.setCondition(c);
            }
            catch (NumberFormatException nfe) {
                Logger.getAnonymousLogger().warning("NumberFormatException processing <condition> tag.");
            }
            catch (ParseException pe) {
                Logger.getAnonymousLogger().warning("ParseException processing <condition> tag.");
            }
        }
        if ((forecasts = element.getChildren("forecast", NS)) != null) {
            Forecast[] f = new Forecast[forecasts.size()];
            int i = 0;
            for (Element forecast : forecasts) {
                try {
                    f[i] = new Forecast(forecast.getAttributeValue("day"), SHORT_DATE.parse(forecast.getAttributeValue("date")), Integer.parseInt(forecast.getAttributeValue("low")), Integer.parseInt(forecast.getAttributeValue("high")), forecast.getAttributeValue("text"), ConditionCode.fromCode(Integer.parseInt(forecast.getAttributeValue("code"))));
                }
                catch (NumberFormatException nfe) {
                    Logger.getAnonymousLogger().warning("NumberFormatException processing <forecast> tag.");
                }
                catch (ParseException pe) {
                    Logger.getAnonymousLogger().warning("ParseException processing <forecast> tag.");
                }
                ++i;
            }
            module.setForecasts(f);
        }
        return module;
    }
}

