/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.sse;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.DelegatingModuleGenerator;
import com.sun.syndication.io.WireFeedGenerator;
import com.sun.syndication.io.impl.DateParser;
import com.sun.syndication.io.impl.RSS20Generator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.rometools.feed.module.sse.modules.Conflict;
import org.rometools.feed.module.sse.modules.History;
import org.rometools.feed.module.sse.modules.Related;
import org.rometools.feed.module.sse.modules.SSEModule;
import org.rometools.feed.module.sse.modules.Sharing;
import org.rometools.feed.module.sse.modules.Sync;
import org.rometools.feed.module.sse.modules.Update;

public class SSE091Generator
implements DelegatingModuleGenerator {
    private RSS20Generator parentGenerator;

    @Override
    public void setFeedGenerator(WireFeedGenerator feedGenerator) {
        this.parentGenerator = (RSS20Generator)feedGenerator;
    }

    @Override
    public String getNamespaceUri() {
        return "http://www.microsoft.com/schemas/rss/sse";
    }

    @Override
    public Set getNamespaces() {
        return SSEModule.NAMESPACES;
    }

    @Override
    public void generate(Module module, Element element) {
        if (!(module instanceof SSEModule)) {
            return;
        }
        SSEModule sseModule = (SSEModule)module;
        if (sseModule instanceof Sharing) {
            Sharing sharing = (Sharing)sseModule;
            Element root = element;
            while (root.getParent() != null && root.getParent() instanceof Element) {
                root = (Element)root.getParent();
            }
            root.addNamespaceDeclaration(SSEModule.SSE_NS);
            this.generateSharing(sharing, root);
        } else if (sseModule instanceof Sync) {
            this.generateSync((Sync)sseModule, element);
        }
    }

    private void generateSharing(Sharing sharing, Element parent) {
        Element sharingElement = new Element("sharing", SSEModule.SSE_NS);
        this.generateAttribute(sharingElement, "until", sharing.getUntil());
        this.generateAttribute(sharingElement, "since", sharing.getSince());
        this.generateAttribute(sharingElement, "ordered", sharing.getOrdered());
        this.generateAttribute(sharingElement, "window", sharing.getWindow());
        this.generateAttribute(sharingElement, "version", sharing.getVersion());
        parent.addContent(0, (Content)sharingElement);
        Related related = sharing.getRelated();
        if (related != null) {
            this.generateRelated(related);
        }
    }

    private void generateRelated(Related related) {
        Element relatedElement = new Element("related", SSEModule.SSE_NS);
        this.generateAttribute(relatedElement, "since", related.getSince());
        this.generateAttribute(relatedElement, "until", related.getUntil());
        this.generateAttribute(relatedElement, "link", related.getLink());
        this.generateAttribute(relatedElement, "title", related.getTitle());
        this.generateAttribute(relatedElement, "type", related.getType());
    }

    protected void generateSync(Sync sync, Element parent) {
        Element syncElement = new Element("sync", SSEModule.SSE_NS);
        this.generateAttribute(syncElement, "deleted", sync.isDeleted());
        this.generateAttribute(syncElement, "version", sync.getVersion());
        this.generateAttribute(syncElement, "id", sync.getId());
        this.generateAttribute(syncElement, "conflict", sync.isConflict());
        this.generateHistory(syncElement, sync.getHistory());
        this.generateConflicts(syncElement, sync.getConflicts());
        parent.addContent((Content)syncElement);
    }

    private void generateConflicts(Element syncElement, List conflicts) {
        if (conflicts != null) {
            Element conflictsElement = new Element("conflicts", SSEModule.SSE_NS);
            Iterator confictIter = conflicts.iterator();
            while (confictIter.hasNext()) {
                Element conflictElement = new Element("conflict", SSEModule.SSE_NS);
                Conflict conflict = (Conflict)confictIter.next();
                this.generateAttribute(conflictElement, "by", conflict.getBy());
                this.generateAttribute(conflictElement, "version", conflict.getVersion());
                this.generateAttribute(conflictElement, "when", conflict.getWhen());
                this.generateItem(conflictElement, conflict.getItem());
                conflictsElement.addContent((Content)conflictElement);
            }
            syncElement.addContent((Content)conflictsElement);
        }
    }

    private void generateItem(Element conflictElement, Item item) {
        if (item != null) {
            Element itemElement = new Element("item");
            this.parentGenerator.populateItem(item, itemElement, 0);
            this.parentGenerator.generateItemModules(item.getModules(), itemElement);
            conflictElement.addContent((Content)itemElement);
        }
    }

    private void generateHistory(Element syncElement, History history) {
        if (history != null) {
            Element historyElement = new Element("history", SSEModule.SSE_NS);
            this.generateAttribute(historyElement, "by", history.getBy());
            this.generateAttribute(historyElement, "when", history.getWhen());
            this.generateUpdates(historyElement, history.getUpdates());
            syncElement.addContent((Content)historyElement);
        }
    }

    private void generateUpdates(Element historyElement, List updates) {
        if (updates != null) {
            Iterator updateIter = updates.iterator();
            while (updateIter.hasNext()) {
                Element updateElement = new Element("update", SSEModule.SSE_NS);
                Update update = (Update)updateIter.next();
                this.generateAttribute(updateElement, "by", update.getBy());
                this.generateAttribute(updateElement, "when", update.getWhen());
                historyElement.addContent((Content)updateElement);
            }
        }
    }

    private void generateAttribute(Element syncElement, String attrName, Object attribute) {
        if (attribute != null) {
            syncElement.setAttribute(attrName, this.toString(attribute));
        }
    }

    private String toString(Object o) {
        if (o != null) {
            if (o instanceof Date) {
                return DateParser.formatRFC822((Date)o);
            }
            return o.toString();
        }
        return "";
    }
}

