/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.sle.io;

import com.sun.syndication.feed.module.Module;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.sle.SimpleListExtension;
import org.rometools.feed.module.sle.io.ModuleParser;
import org.rometools.feed.module.sle.types.Group;
import org.rometools.feed.module.sle.types.Sort;

public class ModuleGenerator
implements com.sun.syndication.io.ModuleGenerator {
    private static final Set NAMESPACES = new HashSet();

    @Override
    public String getNamespaceUri() {
        return "http://www.microsoft.com/schemas/rss/core/2005";
    }

    @Override
    public Set getNamespaces() {
        return NAMESPACES;
    }

    @Override
    public void generate(Module module, Element element) {
        if (!(module instanceof SimpleListExtension)) {
            return;
        }
        SimpleListExtension sle = (SimpleListExtension)module;
        this.addNotNullElement(element, "treatAs", sle.getTreatAs());
        Group[] groups = sle.getGroupFields();
        Element listInfo = new Element("listinfo", ModuleParser.NS);
        for (int i = 0; groups != null && i < groups.length; ++i) {
            Element group = new Element("group", ModuleParser.NS);
            if (groups[i].getNamespace() != Namespace.NO_NAMESPACE) {
                this.addNotNullAttribute(group, "ns", groups[i].getNamespace().getURI());
            }
            this.addNotNullAttribute(group, "element", groups[i].getElement());
            this.addNotNullAttribute(group, "label", groups[i].getLabel());
            listInfo.addContent((Content)group);
        }
        Sort[] sorts = sle.getSortFields();
        for (int i = 0; sorts != null && i < sorts.length; ++i) {
            Element sort = new Element("sort", ModuleParser.NS);
            if (sorts[i].getNamespace() != Namespace.NO_NAMESPACE) {
                this.addNotNullAttribute(sort, "ns", sorts[i].getNamespace().getURI());
            }
            this.addNotNullAttribute(sort, "element", sorts[i].getElement());
            this.addNotNullAttribute(sort, "label", sorts[i].getLabel());
            this.addNotNullAttribute(sort, "data-type", sorts[i].getDataType());
            if (sorts[i].getDefaultOrder()) {
                this.addNotNullAttribute(sort, "default", "true");
            }
            listInfo.addContent((Content)sort);
        }
        if (listInfo.getChildren().size() > 0) {
            element.addContent((Content)listInfo);
        }
    }

    protected void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    protected Element addNotNullElement(Element target, String name, Object value) {
        if (value == null) {
            return null;
        }
        Element e = this.generateSimpleElement(name, value.toString());
        target.addContent((Content)e);
        return e;
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, ModuleParser.NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(ModuleParser.NS);
    }
}

