/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.sle;

import com.sun.syndication.feed.module.Extendable;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.impl.ModuleGenerators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom2.Document;
import org.rometools.feed.module.sle.SleEntry;
import org.rometools.feed.module.sle.io.ModuleParser;
import org.rometools.feed.module.sle.types.Group;
import org.rometools.feed.module.sle.types.Sort;

public class SleUtility {
    private static final String ITEM_MODULE_GENERATORS_POSFIX_KEY = ".item.ModuleGenerator.classes";

    private SleUtility() {
    }

    public static List group(List values, Group[] groups) {
        SortableList list = values instanceof SortableList ? (SortableList)values : new SortableList((Collection)values);
        GroupStrategy gs = new GroupStrategy();
        for (int i = groups.length - 1; i >= 0; --i) {
            list.sortOnProperty(groups[i], true, gs);
        }
        return list;
    }

    public static List sort(List values, Sort sort, boolean ascending) {
        SortableList list = values instanceof SortableList ? (SortableList)values : new SortableList((Collection)values);
        list.sortOnProperty(sort, ascending, new SortStrategy());
        return list;
    }

    public static List sortAndGroup(List values, Group[] groups, Sort sort, boolean ascending) {
        List list = SleUtility.sort(values, sort, ascending);
        list = SleUtility.group(list, groups);
        return list;
    }

    public static void initializeForSorting(SyndFeed feed) throws FeedException {
        List<SyndEntry> syndEntries = feed.getEntries();
        ModuleGenerators g = new ModuleGenerators(feed.getFeedType() + ITEM_MODULE_GENERATORS_POSFIX_KEY, null);
        SyndFeedOutput o = new SyndFeedOutput();
        Document d = o.outputJDom(feed);
        SyndFeed feed2 = new SyndFeedInput().build(d);
        feed.copyFrom(feed2);
    }

    private static class SortableList
    extends ArrayList {
        public SortableList(Collection c) {
            super(c);
        }

        public synchronized void sortOnProperty(Object value, boolean ascending, ValueStrategy strat) {
            Object temp = null;
            for (int i = 0; i < this.size() - 1; ++i) {
                for (int j = i + 1; j < this.size(); ++j) {
                    Extendable o1 = (Extendable)this.get(i);
                    Comparable oc1 = strat.getValue(o1, value);
                    Extendable o2 = (Extendable)this.get(j);
                    Comparable oc2 = strat.getValue(o2, value);
                    System.out.println(oc1 + " < " + oc2);
                    if (ascending) {
                        if (oc1 == oc2 || oc2 != null && (oc1 == null || oc2 == null || oc2.compareTo(oc1) >= 0)) continue;
                        this.set(i, o2);
                        this.set(j, o1);
                        continue;
                    }
                    if (oc1 == oc2 || oc1 != null && (oc1 == null || oc2 == null || oc1.compareTo(oc2) >= 0)) continue;
                    this.set(i, o2);
                    this.set(j, o1);
                }
            }
        }
    }

    private static class SortStrategy
    implements ValueStrategy {
        private SortStrategy() {
        }

        @Override
        public Comparable getValue(Extendable o, Object value) {
            Comparable oc = null;
            try {
                oc = ((SleEntry)o.getModule(ModuleParser.TEMP.getURI())).getSortByElement((Sort)value).getValue();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            return oc;
        }
    }

    private static class GroupStrategy
    implements ValueStrategy {
        private GroupStrategy() {
        }

        @Override
        public Comparable getValue(Extendable o, Object value) {
            Comparable oc = null;
            try {
                oc = ((SleEntry)o.getModule(ModuleParser.TEMP.getURI())).getGroupByElement((Group)value).getValue();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            return oc;
        }
    }

    private static interface ValueStrategy {
        public Comparable getValue(Extendable var1, Object var2);
    }
}

