/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.mediarss.types;

import com.sun.syndication.feed.impl.EqualsBean;
import java.io.Serializable;
import java.text.NumberFormat;

public class Time
implements Serializable {
    private static final long serialVersionUID = 4088522049885593073L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000000L;
    private static final NumberFormat nf = NumberFormat.getInstance();
    private long milliseconds = 0L;

    public Time(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public Time(String value) {
        String[] values = value.split(":");
        int count = values.length - 1;
        this.milliseconds = (long)(Double.parseDouble(values[count]) * 1000.0);
        if (--count >= 0) {
            this.milliseconds += Long.parseLong(values[count]) * 60000L;
            --count;
        }
        if (count >= 0) {
            this.milliseconds += Long.parseLong(values[count]) * 3600000000L;
        }
    }

    public long getValue() {
        return this.milliseconds;
    }

    public boolean equals(Object obj) {
        EqualsBean eBean = new EqualsBean(this.getClass(), this);
        return eBean.beanEquals(obj);
    }

    public int hashCode() {
        EqualsBean equals = new EqualsBean(this.getClass(), this);
        return equals.beanHashCode();
    }

    public String toString() {
        long value = this.milliseconds;
        long hours = value / 3600000000L;
        long minutes = (value -= hours * 3600000000L) / 60000L;
        double seconds = (double)(value -= minutes * 60000L) / 1000.0;
        return nf.format(hours) + ":" + nf.format(minutes) + ":" + seconds;
    }

    static {
        nf.setMinimumIntegerDigits(2);
    }
}

