/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.mediarss.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.mediarss.MediaEntryModule;
import org.rometools.feed.module.mediarss.MediaModule;
import org.rometools.feed.module.mediarss.types.Category;
import org.rometools.feed.module.mediarss.types.Credit;
import org.rometools.feed.module.mediarss.types.MediaContent;
import org.rometools.feed.module.mediarss.types.MediaGroup;
import org.rometools.feed.module.mediarss.types.Metadata;
import org.rometools.feed.module.mediarss.types.PlayerReference;
import org.rometools.feed.module.mediarss.types.Rating;
import org.rometools.feed.module.mediarss.types.Restriction;
import org.rometools.feed.module.mediarss.types.Text;
import org.rometools.feed.module.mediarss.types.Thumbnail;
import org.rometools.feed.module.mediarss.types.UrlReference;

public class MediaModuleGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"media", (String)"http://search.yahoo.com/mrss/");
    private static final Set NAMESPACES = new HashSet();

    @Override
    public String getNamespaceUri() {
        return "http://search.yahoo.com/mrss/";
    }

    @Override
    public Set getNamespaces() {
        return NAMESPACES;
    }

    @Override
    public void generate(Module module, Element element) {
        MediaModule m;
        if (module instanceof MediaModule) {
            m = (MediaModule)module;
            this.generateMetadata(m.getMetadata(), element);
            this.generatePlayer(m.getPlayer(), element);
        }
        if (module instanceof MediaEntryModule) {
            m = (MediaEntryModule)module;
            MediaGroup[] g = m.getMediaGroups();
            for (int i = 0; i < g.length; ++i) {
                this.generateGroup(g[i], element);
            }
            MediaContent[] c = m.getMediaContents();
            for (int i = 0; i < c.length; ++i) {
                this.generateContent(c[i], element);
            }
        }
    }

    public void generateContent(MediaContent c, Element e) {
        Element mc = new Element("content", NS);
        this.addNotNullAttribute(mc, "medium", c.getMedium());
        this.addNotNullAttribute(mc, "channels", c.getAudioChannels());
        this.addNotNullAttribute(mc, "bitrate", c.getBitrate());
        this.addNotNullAttribute(mc, "duration", c.getDuration());
        this.addNotNullAttribute(mc, "expression", c.getExpression());
        this.addNotNullAttribute(mc, "fileSize", c.getFileSize());
        this.addNotNullAttribute(mc, "framerate", c.getFramerate());
        this.addNotNullAttribute(mc, "height", c.getHeight());
        this.addNotNullAttribute(mc, "lang", c.getLanguage());
        this.addNotNullAttribute(mc, "samplingrate", c.getSamplingrate());
        this.addNotNullAttribute(mc, "type", c.getType());
        this.addNotNullAttribute(mc, "width", c.getWidth());
        if (c.isDefaultContent()) {
            this.addNotNullAttribute(mc, "isDefault", "true");
        }
        if (c.getReference() instanceof UrlReference) {
            this.addNotNullAttribute(mc, "url", c.getReference());
            this.generatePlayer(c.getPlayer(), mc);
        } else {
            this.generatePlayer(c.getPlayer(), mc);
        }
        this.generateMetadata(c.getMetadata(), mc);
        e.addContent((Content)mc);
    }

    public void generateGroup(MediaGroup g, Element e) {
        Element t = new Element("group", NS);
        MediaContent[] c = g.getContents();
        for (int i = 0; i < c.length; ++i) {
            this.generateContent(c[i], t);
        }
        this.generateMetadata(g.getMetadata(), t);
        e.addContent((Content)t);
    }

    public void generateMetadata(Metadata m, Element e) {
        int i;
        String[] keywords;
        if (m == null) {
            return;
        }
        Category[] cats = m.getCategories();
        for (int i2 = 0; i2 < cats.length; ++i2) {
            Element c = this.generateSimpleElement("category", cats[i2].getValue());
            this.addNotNullAttribute(c, "scheme", cats[i2].getScheme());
            this.addNotNullAttribute(c, "label", cats[i2].getLabel());
            e.addContent((Content)c);
        }
        Element copyright = this.addNotNullElement(e, "copyright", m.getCopyright());
        this.addNotNullAttribute(copyright, "url", m.getCopyrightUrl());
        Credit[] creds = m.getCredits();
        for (int i3 = 0; i3 < creds.length; ++i3) {
            Element c = this.generateSimpleElement("credit", creds[i3].getName());
            this.addNotNullAttribute(c, "role", creds[i3].getRole());
            this.addNotNullAttribute(c, "scheme", creds[i3].getScheme());
            e.addContent((Content)c);
        }
        Element desc = this.addNotNullElement(e, "description", m.getDescription());
        this.addNotNullAttribute(desc, "type", m.getDescriptionType());
        if (m.getHash() != null) {
            Element hash = this.addNotNullElement(e, "hash", m.getHash().getValue());
            this.addNotNullAttribute(hash, "algo", m.getHash().getAlgorithm());
        }
        if ((keywords = m.getKeywords()).length > 0) {
            String keyword = keywords[0];
            for (i = 1; i < keywords.length; ++i) {
                keyword = keyword + ", " + keywords[i];
            }
            this.addNotNullElement(e, "keywords", keyword);
        }
        Rating[] rats = m.getRatings();
        for (i = 0; i < rats.length; ++i) {
            Element rat = this.addNotNullElement(e, "rating", rats[i].getValue());
            this.addNotNullAttribute(rat, "scheme", rats[i].getScheme());
            if (rats[i].equals(Rating.ADULT)) {
                this.addNotNullElement(e, "adult", "true");
                continue;
            }
            if (!rats[i].equals(Rating.NONADULT)) continue;
            this.addNotNullElement(e, "adult", "false");
        }
        Text[] text = m.getText();
        for (int i4 = 0; i4 < text.length; ++i4) {
            Element t = this.addNotNullElement(e, "text", text[i4].getValue());
            this.addNotNullAttribute(t, "type", text[i4].getType());
            this.addNotNullAttribute(t, "start", text[i4].getStart());
            this.addNotNullAttribute(t, "end", text[i4].getEnd());
        }
        Thumbnail[] thumbs = m.getThumbnail();
        for (int i5 = 0; i5 < thumbs.length; ++i5) {
            Element t = new Element("thumbnail", NS);
            this.addNotNullAttribute(t, "url", thumbs[i5].getUrl());
            this.addNotNullAttribute(t, "width", thumbs[i5].getWidth());
            this.addNotNullAttribute(t, "height", thumbs[i5].getHeight());
            this.addNotNullAttribute(t, "time", thumbs[i5].getTime());
            e.addContent((Content)t);
        }
        Element title = this.addNotNullElement(e, "title", m.getTitle());
        this.addNotNullAttribute(title, "type", m.getTitleType());
        Restriction[] r = m.getRestrictions();
        for (int i6 = 0; i6 < r.length; ++i6) {
            Element res = this.addNotNullElement(e, "restriction", r[i6].getValue());
            this.addNotNullAttribute(res, "type", r[i6].getType());
            this.addNotNullAttribute(res, "relationship", r[i6].getRelationship());
        }
    }

    public void generatePlayer(PlayerReference p, Element e) {
        if (p == null) {
            return;
        }
        Element t = new Element("player", NS);
        this.addNotNullAttribute(t, "url", p.getUrl());
        this.addNotNullAttribute(t, "width", p.getWidth());
        this.addNotNullAttribute(t, "height", p.getHeight());
        e.addContent((Content)t);
    }

    protected void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    protected Element addNotNullElement(Element target, String name, Object value) {
        if (value == null) {
            return null;
        }
        Element e = this.generateSimpleElement(name, value.toString());
        target.addContent((Content)e);
        return e;
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(NS);
    }
}

