/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.itunes.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.itunes.AbstractITunesObject;
import org.rometools.feed.module.itunes.EntryInformationImpl;
import org.rometools.feed.module.itunes.FeedInformationImpl;
import org.rometools.feed.module.itunes.types.Category;

public class ITunesGenerator
implements ModuleGenerator {
    private static final HashSet SET = new HashSet();
    private static final Namespace NS = Namespace.getNamespace((String)"itunes", (String)"http://www.itunes.com/dtds/podcast-1.0.dtd");

    @Override
    public void generate(Module module, Element element) {
        AbstractITunesObject info;
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        root.addNamespaceDeclaration(NS);
        if (!(module instanceof AbstractITunesObject)) {
            return;
        }
        AbstractITunesObject itunes = (AbstractITunesObject)module;
        if (itunes instanceof FeedInformationImpl) {
            info = (FeedInformationImpl)itunes;
            Element owner = this.generateSimpleElement("owner", "");
            Element email = this.generateSimpleElement("email", ((FeedInformationImpl)info).getOwnerEmailAddress());
            owner.addContent((Content)email);
            Element name = this.generateSimpleElement("name", ((FeedInformationImpl)info).getOwnerName());
            owner.addContent((Content)name);
            element.addContent((Content)owner);
            if (((FeedInformationImpl)info).getImage() != null) {
                Element image = this.generateSimpleElement("image", "");
                image.setAttribute("href", ((FeedInformationImpl)info).getImage().toExternalForm());
                element.addContent((Content)image);
            }
            for (Category cat : ((FeedInformationImpl)info).getCategories()) {
                Element category = this.generateSimpleElement("category", "");
                category.setAttribute("text", cat.getName());
                if (cat.getSubcategory() != null) {
                    Element subcat = this.generateSimpleElement("category", "");
                    subcat.setAttribute("text", cat.getSubcategory().getName());
                    category.addContent((Content)subcat);
                }
                element.addContent((Content)category);
            }
        } else if (itunes instanceof EntryInformationImpl && ((EntryInformationImpl)(info = (EntryInformationImpl)itunes)).getDuration() != null) {
            element.addContent((Content)this.generateSimpleElement("duration", ((EntryInformationImpl)info).getDuration().toString()));
        }
        if (itunes.getAuthor() != null) {
            element.addContent((Content)this.generateSimpleElement("author", itunes.getAuthor()));
        }
        if (itunes.getBlock()) {
            element.addContent((Content)this.generateSimpleElement("block", ""));
        }
        if (itunes.getExplicit()) {
            element.addContent((Content)this.generateSimpleElement("explicit", "yes"));
        } else {
            element.addContent((Content)this.generateSimpleElement("explicit", "no"));
        }
        if (itunes.getKeywords() != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < itunes.getKeywords().length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(itunes.getKeywords()[i]);
            }
            element.addContent((Content)this.generateSimpleElement("keywords", sb.toString()));
        }
        if (itunes.getSubtitle() != null) {
            element.addContent((Content)this.generateSimpleElement("subtitle", itunes.getSubtitle()));
        }
        if (itunes.getSummary() != null) {
            element.addContent((Content)this.generateSimpleElement("summary", itunes.getSummary()));
        }
    }

    @Override
    public Set getNamespaces() {
        return SET;
    }

    @Override
    public String getNamespaceUri() {
        return "http://www.itunes.com/dtds/podcast-1.0.dtd";
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    static {
        SET.add(NS);
    }
}

