/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.itunes;

import com.sun.syndication.feed.CopyFrom;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.rometools.feed.module.itunes.AbstractITunesObject;
import org.rometools.feed.module.itunes.FeedInformation;

public class FeedInformationImpl
extends AbstractITunesObject
implements FeedInformation {
    private String ownerName;
    private String ownerEmailAddress;
    private URL image;
    private List categories;

    @Override
    public List getCategories() {
        return this.categories == null ? (this.categories = new ArrayList()) : this.categories;
    }

    @Override
    public void setCategories(List categories) {
        this.categories = categories;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getOwnerEmailAddress() {
        return this.ownerEmailAddress;
    }

    @Override
    public void setOwnerEmailAddress(String ownerEmailAddress) {
        this.ownerEmailAddress = ownerEmailAddress;
    }

    @Override
    public URL getImage() {
        return this.image;
    }

    @Override
    public void setImage(URL image) {
        this.image = image;
    }

    @Override
    public void copyFrom(CopyFrom obj) {
        FeedInformationImpl info = (FeedInformationImpl)obj;
        this.setAuthor(info.getAuthor());
        this.setBlock(info.getBlock());
        this.getCategories().clear();
        if (info.getCategories() != null) {
            this.getCategories().addAll(info.getCategories());
        }
        this.setExplicit(info.getExplicit());
        try {
            if (info.getImage() != null) {
                this.setImage(new URL(info.getImage().toExternalForm()));
            }
        }
        catch (MalformedURLException e) {
            Logger.getAnonymousLogger().fine("Error copying URL:" + info.getImage());
        }
        if (info.getKeywords() != null) {
            this.setKeywords((String[])info.getKeywords().clone());
        }
        this.setOwnerEmailAddress(info.getOwnerEmailAddress());
        this.setOwnerName(info.getOwnerName());
        this.setSubtitle(info.getSubtitle());
        this.setSummary(info.getSummary());
    }

    @Override
    public Object clone() {
        FeedInformationImpl info = new FeedInformationImpl();
        info.copyFrom(this);
        return info;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(" email: ");
        sb.append(this.getOwnerEmailAddress());
        sb.append(" name: ");
        sb.append(this.getOwnerName());
        sb.append(" image: ");
        sb.append(this.getImage());
        sb.append(" categories: ");
        sb.append(this.getCategories());
        sb.append("]");
        sb.append(super.toString());
        return sb.toString();
    }
}

