/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.georss.geometries;

import java.io.Serializable;

public class PositionList
implements Cloneable,
Serializable {
    private double[] latitude;
    private double[] longitude;
    private int size = 0;

    public Object clone() throws CloneNotSupportedException {
        PositionList retval = (PositionList)super.clone();
        if (this.latitude != null) {
            retval.latitude = (double[])this.latitude.clone();
        }
        if (this.longitude != null) {
            retval.longitude = (double[])this.longitude.clone();
        }
        retval.size = this.size;
        return retval;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PositionList p = (PositionList)obj;
        if (p.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (p.latitude[i] == this.latitude[i] && p.longitude[i] == this.longitude[i]) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int new_size) {
        if (this.longitude != null && this.longitude.length >= new_size) {
            return;
        }
        new_size = new_size < 4 ? 4 : (int)Math.ceil(Math.pow(2.0, Math.ceil(Math.log(new_size) / Math.log(2.0))));
        double[] tmp = new double[new_size];
        if (this.longitude != null) {
            System.arraycopy(this.longitude, 0, tmp, 0, this.size);
        }
        this.longitude = tmp;
        tmp = new double[new_size];
        if (this.latitude != null) {
            System.arraycopy(this.latitude, 0, tmp, 0, this.size);
        }
        this.latitude = tmp;
    }

    public int size() {
        return this.size;
    }

    public double getLongitude(int pos) {
        return this.longitude[pos];
    }

    public double getLatitude(int pos) {
        return this.latitude[pos];
    }

    public void add(double latitude, double longitude) {
        this.ensureCapacity(this.size + 1);
        this.longitude[this.size] = longitude;
        this.latitude[this.size] = latitude;
        ++this.size;
    }

    public void insert(int pos, double latitude, double longitude) {
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.longitude, pos, this.longitude, pos + 1, this.size - pos);
        System.arraycopy(this.latitude, pos, this.latitude, pos + 1, this.size - pos);
        this.longitude[pos] = longitude;
        this.latitude[pos] = latitude;
        ++this.size;
    }

    public void replace(int pos, double latitude, double longitude) {
        this.longitude[pos] = longitude;
        this.latitude[pos] = latitude;
    }

    public void remove(int pos) {
        System.arraycopy(this.longitude, pos + 1, this.longitude, pos, this.size - pos - 1);
        System.arraycopy(this.latitude, pos + 1, this.latitude, pos, this.size - pos - 1);
        --this.size;
    }
}

