/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import org.jdom2.Element;
import org.rometools.feed.module.georss.GeoRSSModule;
import org.rometools.feed.module.georss.W3CGeoModuleImpl;
import org.rometools.feed.module.georss.geometries.Point;
import org.rometools.feed.module.georss.geometries.Position;

public class W3CGeoParser
implements ModuleParser {
    @Override
    public String getNamespaceUri() {
        return "http://www.w3.org/2003/01/geo/wgs84_pos#";
    }

    static Module parseW3C(Element element) {
        W3CGeoModuleImpl geoRSSModule = null;
        Element pointElement = element.getChild("Point", GeoRSSModule.W3CGEO_NS);
        if (pointElement == null) {
            pointElement = element;
        }
        Element lat = pointElement.getChild("lat", GeoRSSModule.W3CGEO_NS);
        Element lng = pointElement.getChild("long", GeoRSSModule.W3CGEO_NS);
        if (lng == null) {
            lng = pointElement.getChild("lon", GeoRSSModule.W3CGEO_NS);
        }
        if (lat != null && lng != null) {
            geoRSSModule = new W3CGeoModuleImpl();
            Position pos = new Position(Double.parseDouble(lat.getText()), Double.parseDouble(lng.getText()));
            geoRSSModule.setGeometry(new Point(pos));
        }
        return geoRSSModule;
    }

    @Override
    public Module parse(Element element) {
        Module geoRssModule = W3CGeoParser.parseW3C(element);
        return geoRssModule;
    }
}

