/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import org.jdom2.Element;
import org.rometools.feed.module.georss.GMLParser;
import org.rometools.feed.module.georss.GeoRSSModule;
import org.rometools.feed.module.georss.GeoRSSUtils;
import org.rometools.feed.module.georss.SimpleModuleImpl;
import org.rometools.feed.module.georss.geometries.Envelope;
import org.rometools.feed.module.georss.geometries.LineString;
import org.rometools.feed.module.georss.geometries.LinearRing;
import org.rometools.feed.module.georss.geometries.Point;
import org.rometools.feed.module.georss.geometries.Polygon;
import org.rometools.feed.module.georss.geometries.Position;
import org.rometools.feed.module.georss.geometries.PositionList;

public class SimpleParser
implements ModuleParser {
    @Override
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    private static PositionList parsePosList(Element element) {
        String coordinates = element.getText();
        String[] coord = GeoRSSUtils.trimWhitespace(coordinates).split(" ");
        PositionList posList = new PositionList();
        for (int i = 0; i < coord.length; i += 2) {
            posList.add(Double.parseDouble(coord[i]), Double.parseDouble(coord[i + 1]));
        }
        return posList;
    }

    @Override
    public Module parse(Element element) {
        Module geoRssModule = SimpleParser.parseSimple(element);
        return geoRssModule;
    }

    static Module parseSimple(Element element) {
        GeoRSSModule geoRSSModule = null;
        Element pointElement = element.getChild("point", GeoRSSModule.SIMPLE_NS);
        Element lineElement = element.getChild("line", GeoRSSModule.SIMPLE_NS);
        Element polygonElement = element.getChild("polygon", GeoRSSModule.SIMPLE_NS);
        Element boxElement = element.getChild("box", GeoRSSModule.SIMPLE_NS);
        Element whereElement = element.getChild("where", GeoRSSModule.SIMPLE_NS);
        if (pointElement != null) {
            geoRSSModule = new SimpleModuleImpl();
            String coordinates = pointElement.getText();
            String[] coord = GeoRSSUtils.trimWhitespace(coordinates).split(" ");
            Position pos = new Position(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]));
            geoRSSModule.setGeometry(new Point(pos));
        } else if (lineElement != null) {
            geoRSSModule = new SimpleModuleImpl();
            PositionList posList = SimpleParser.parsePosList(lineElement);
            geoRSSModule.setGeometry(new LineString(posList));
        } else if (polygonElement != null) {
            geoRSSModule = new SimpleModuleImpl();
            PositionList posList = SimpleParser.parsePosList(polygonElement);
            Polygon poly = new Polygon();
            poly.setExterior(new LinearRing(posList));
            geoRSSModule.setGeometry(poly);
        } else if (boxElement != null) {
            geoRSSModule = new SimpleModuleImpl();
            String coordinates = boxElement.getText();
            String[] coord = GeoRSSUtils.trimWhitespace(coordinates).split(" ");
            Envelope envelope = new Envelope(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]), Double.parseDouble(coord[2]), Double.parseDouble(coord[3]));
            geoRSSModule.setGeometry(envelope);
        } else if (whereElement != null) {
            geoRSSModule = (GeoRSSModule)GMLParser.parseGML(whereElement);
        }
        return geoRSSModule;
    }
}

