/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.georss.GeoRSSModule;
import org.rometools.feed.module.georss.geometries.AbstractGeometry;
import org.rometools.feed.module.georss.geometries.AbstractRing;
import org.rometools.feed.module.georss.geometries.Envelope;
import org.rometools.feed.module.georss.geometries.LineString;
import org.rometools.feed.module.georss.geometries.LinearRing;
import org.rometools.feed.module.georss.geometries.Point;
import org.rometools.feed.module.georss.geometries.Polygon;
import org.rometools.feed.module.georss.geometries.Position;
import org.rometools.feed.module.georss.geometries.PositionList;

public class SimpleGenerator
implements ModuleGenerator {
    private static final Set NAMESPACES;

    private String posListToString(PositionList posList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < posList.size(); ++i) {
            sb.append(posList.getLatitude(i)).append(" ").append(posList.getLongitude(i)).append(" ");
        }
        return sb.toString();
    }

    @Override
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    @Override
    public Set getNamespaces() {
        return NAMESPACES;
    }

    @Override
    public void generate(Module module, Element element) {
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(GeoRSSModule.SIMPLE_NS);
        GeoRSSModule geoRSSModule = (GeoRSSModule)module;
        AbstractGeometry geometry = geoRSSModule.getGeometry();
        if (geometry instanceof Point) {
            Position pos = ((Point)geometry).getPosition();
            Element pointElement = new Element("point", GeoRSSModule.SIMPLE_NS);
            pointElement.addContent(pos.getLatitude() + " " + pos.getLongitude());
            element.addContent((Content)pointElement);
        } else if (geometry instanceof LineString) {
            PositionList posList = ((LineString)geometry).getPositionList();
            Element lineElement = new Element("line", GeoRSSModule.SIMPLE_NS);
            lineElement.addContent(this.posListToString(posList));
            element.addContent((Content)lineElement);
        } else if (geometry instanceof Polygon) {
            AbstractRing ring = ((Polygon)geometry).getExterior();
            if (ring instanceof LinearRing) {
                PositionList posList = ((LinearRing)ring).getPositionList();
                Element polygonElement = new Element("polygon", GeoRSSModule.SIMPLE_NS);
                polygonElement.addContent(this.posListToString(posList));
                element.addContent((Content)polygonElement);
            } else {
                System.err.println("GeoRSS simple format can't handle rings of type: " + ring.getClass().getName());
            }
            if (((Polygon)geometry).getInterior() != null || !((Polygon)geometry).getInterior().isEmpty()) {
                System.err.println("GeoRSS simple format can't handle interior rings (ignored)");
            }
        } else if (geometry instanceof Envelope) {
            Envelope envelope = (Envelope)geometry;
            Element boxElement = new Element("box", GeoRSSModule.SIMPLE_NS);
            boxElement.addContent(envelope.getMinLatitude() + " " + envelope.getMinLongitude() + " " + envelope.getMaxLatitude() + " " + envelope.getMaxLongitude());
            element.addContent((Content)boxElement);
        } else {
            System.err.println("GeoRSS simple format can't handle geometries of type: " + geometry.getClass().getName());
        }
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(GeoRSSModule.SIMPLE_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

