/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.georss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import org.rometools.feed.module.georss.GeoRSSModule;

public class GeoRSSUtils {
    static String trimWhitespace(String in) {
        int i;
        StringBuffer strbuf = new StringBuffer();
        for (i = 0; i < in.length() && Character.isWhitespace(in.charAt(i)); ++i) {
        }
        boolean wasWhite = false;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if (Character.isWhitespace(ch)) {
                wasWhite = true;
            } else {
                if (wasWhite) {
                    strbuf.append(' ');
                }
                strbuf.append(ch);
                wasWhite = false;
            }
            ++i;
        }
        return strbuf.toString();
    }

    public static GeoRSSModule getGeoRSS(SyndEntry entry) {
        GeoRSSModule simple = (GeoRSSModule)entry.getModule("http://www.georss.org/georss");
        GeoRSSModule w3cGeo = (GeoRSSModule)entry.getModule("http://www.w3.org/2003/01/geo/wgs84_pos#");
        GeoRSSModule gml = (GeoRSSModule)entry.getModule("http://www.opengis.net/gml");
        if (gml != null) {
            return gml;
        }
        if (simple != null) {
            return simple;
        }
        if (w3cGeo != null) {
            return w3cGeo;
        }
        return null;
    }

    public static GeoRSSModule getGeoRSS(SyndFeed feed) {
        GeoRSSModule simple = (GeoRSSModule)feed.getModule("http://www.georss.org/georss");
        GeoRSSModule w3cGeo = (GeoRSSModule)feed.getModule("http://www.w3.org/2003/01/geo/wgs84_pos#");
        GeoRSSModule gml = (GeoRSSModule)feed.getModule("http://www.opengis.net/gml");
        if (gml != null) {
            return gml;
        }
        if (simple != null) {
            return simple;
        }
        if (w3cGeo != null) {
            return w3cGeo;
        }
        return null;
    }
}

