/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.cc.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.cc.CreativeCommonsImpl;
import org.rometools.feed.module.cc.types.License;

public class ModuleParserRSS1
implements ModuleParser {
    private static final Namespace NS = Namespace.getNamespace((String)"http://web.resource.org/cc/");
    static final Namespace RDF = Namespace.getNamespace((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");

    @Override
    public Module parse(Element element) {
        CreativeCommonsImpl module = new CreativeCommonsImpl();
        Element root = element;
        while (root.getParentElement() != null) {
            root = root.getParentElement();
        }
        List licenseList = root.getChildren("License", NS);
        ArrayList<License> licenses = new ArrayList<License>();
        for (Element licenseTag : licenseList) {
            String licenseURI = licenseTag.getAttributeValue("about", RDF);
            if (licenseURI == null) continue;
            License license = License.findByValue(licenseURI);
            ArrayList<License.Behaviour> permitsValues = new ArrayList<License.Behaviour>();
            ArrayList<License.Behaviour> requiresValues = new ArrayList<License.Behaviour>();
            List permitsTags = licenseTag.getChildren("permits", NS);
            for (Element permitTag : permitsTags) {
                permitsValues.add(License.Behaviour.findByValue(permitTag.getAttributeValue("resource", RDF)));
            }
            List requiresTags = licenseTag.getChildren("requires", NS);
            for (Element requireTag : requiresTags) {
                requiresValues.add(License.Behaviour.findByValue(requireTag.getAttributeValue("resource", RDF)));
            }
            license = new License(licenseURI, requiresValues.toArray(new License.Behaviour[requiresValues.size()]), permitsValues.toArray(new License.Behaviour[permitsValues.size()]));
            licenses.add(license);
        }
        module.setAllLicenses(licenses.toArray(new License[0]));
        ArrayList<License> licenses2 = new ArrayList<License>();
        List licenseTags = element.getChildren("license", NS);
        for (Element licenseTag : licenseTags) {
            licenses2.add(License.findByValue(licenseTag.getAttributeValue("resource", RDF)));
        }
        if (licenses2.size() > 0) {
            module.setLicenses(licenses2.toArray(new License[licenses2.size()]));
        }
        if (module.getLicenses() != null || module.getAllLicenses() != null) {
            return module;
        }
        return null;
    }

    @Override
    public String getNamespaceUri() {
        return "http://web.resource.org/cc/";
    }
}

