/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.base.types;

import java.util.StringTokenizer;
import org.rometools.feed.module.base.types.CloneableType;
import org.rometools.feed.module.base.types.FloatUnit;

public class Size
implements CloneableType {
    private FloatUnit height;
    private FloatUnit length;
    private FloatUnit width;

    public Size(String source) {
        StringTokenizer tok = new StringTokenizer(source, "Xx");
        this.length = new FloatUnit(tok.nextToken());
        this.width = new FloatUnit(tok.nextToken());
        if (tok.hasMoreTokens()) {
            this.height = new FloatUnit(tok.nextToken());
        }
    }

    public Size(FloatUnit length, FloatUnit width) {
        this.length = length;
        this.width = width;
    }

    public Size(FloatUnit length, FloatUnit width, FloatUnit height) {
        this.length = length;
        this.width = width;
        this.height = height;
    }

    public FloatUnit getHeight() {
        return this.height;
    }

    public FloatUnit getLength() {
        return this.length;
    }

    public FloatUnit getWidth() {
        return this.width;
    }

    @Override
    public Object clone() {
        if (this.height != null) {
            return new Size(this.length, this.width, this.height);
        }
        return new Size(this.length, this.width);
    }

    public String toString() {
        if (this.height != null) {
            return this.length + "x" + this.width + "x" + this.height;
        }
        return this.length + "x" + this.width;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Size)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }
}

