/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.base.types;

import org.rometools.feed.module.base.io.GoogleBaseParser;
import org.rometools.feed.module.base.types.CloneableType;

public class FloatUnit
implements CloneableType {
    private String units;
    private float value;

    private boolean inCharArray(char find, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (find != array[i]) continue;
            return true;
        }
        return false;
    }

    public FloatUnit(String source) {
        String parse = source.trim();
        int space = -1;
        for (int i = 0; i < parse.length(); ++i) {
            if (this.inCharArray(parse.charAt(i), GoogleBaseParser.FLOAT_CHARS)) continue;
            space = i;
            break;
        }
        if (space == -1) {
            space = parse.length();
        }
        this.value = Float.parseFloat(GoogleBaseParser.stripNonValidCharacters(GoogleBaseParser.FLOAT_CHARS, parse.substring(0, space)));
        if (space != parse.length()) {
            this.units = parse.substring(space, parse.length()).trim();
        }
    }

    public FloatUnit(float value, String units) {
        this.value = value;
        this.units = units;
    }

    public String getUnits() {
        return this.units;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new FloatUnit(0.0f + this.value, this.units);
    }

    public String toString() {
        if (this.units != null && this.units.trim().length() > 0) {
            return this.value + " " + this.units;
        }
        return Float.toString(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FloatUnit)) {
            return false;
        }
        FloatUnit f = (FloatUnit)o;
        if (f.getValue() != this.value) {
            return false;
        }
        return this.units == f.getUnits() || this.units != null && this.units.equals(f.getUnits());
    }
}

