/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.base.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.rometools.feed.module.base.CustomTagImpl;
import org.rometools.feed.module.base.CustomTagsImpl;
import org.rometools.feed.module.base.io.GoogleBaseParser;
import org.rometools.feed.module.base.types.DateTimeRange;
import org.rometools.feed.module.base.types.FloatUnit;
import org.rometools.feed.module.base.types.IntUnit;
import org.rometools.feed.module.base.types.ShortDate;

public class CustomTagParser
implements ModuleParser {
    private static final Logger log = Logger.getAnonymousLogger();
    static final Namespace NS = Namespace.getNamespace((String)"g-custom", (String)"http://base.google.com/cns/1.0");

    @Override
    public Module parse(Element element) {
        CustomTagsImpl module = new CustomTagsImpl();
        ArrayList<CustomTagImpl> tags = new ArrayList<CustomTagImpl>();
        List elements = element.getChildren();
        for (Element child : elements) {
            if (!child.getNamespace().equals((Object)NS)) continue;
            String type = child.getAttributeValue("type");
            try {
                if (type == null) continue;
                if (type.equals("string")) {
                    tags.add(new CustomTagImpl(child.getName(), child.getText()));
                    continue;
                }
                if (type.equals("int")) {
                    tags.add(new CustomTagImpl(child.getName(), new Integer(child.getTextTrim())));
                    continue;
                }
                if (type.equals("float")) {
                    tags.add(new CustomTagImpl(child.getName(), new Float(child.getTextTrim())));
                    continue;
                }
                if (type.equals("intUnit")) {
                    tags.add(new CustomTagImpl(child.getName(), new IntUnit(child.getTextTrim())));
                    continue;
                }
                if (type.equals("floatUnit")) {
                    tags.add(new CustomTagImpl(child.getName(), new FloatUnit(child.getTextTrim())));
                    continue;
                }
                if (type.equals("date")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), new ShortDate(GoogleBaseParser.SHORT_DT_FMT.parse(child.getTextTrim()))));
                    }
                    catch (ParseException e) {
                        log.log(Level.WARNING, "Unable to parse date type on " + child.getName(), e);
                    }
                    continue;
                }
                if (type.equals("dateTime")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), GoogleBaseParser.LONG_DT_FMT.parse(child.getTextTrim())));
                    }
                    catch (ParseException e) {
                        log.log(Level.WARNING, "Unable to parse date type on " + child.getName(), e);
                    }
                    continue;
                }
                if (type.equals("dateTimeRange")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), new DateTimeRange(GoogleBaseParser.LONG_DT_FMT.parse(child.getChild("start", NS).getText().trim()), GoogleBaseParser.LONG_DT_FMT.parse(child.getChild("end", NS).getText().trim()))));
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Unable to parse date type on " + child.getName(), e);
                    }
                    continue;
                }
                if (type.equals("url")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), new URL(child.getTextTrim())));
                    }
                    catch (MalformedURLException e) {
                        log.log(Level.WARNING, "Unable to parse URL type on " + child.getName(), e);
                    }
                    continue;
                }
                if (type.equals("boolean")) {
                    tags.add(new CustomTagImpl(child.getName(), new Boolean(child.getTextTrim().toLowerCase())));
                    continue;
                }
                if (type.equals("location")) {
                    tags.add(new CustomTagImpl(child.getName(), new CustomTagImpl.Location(child.getText())));
                    continue;
                }
                throw new Exception("Unknown type: " + type);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to parse type on " + child.getName(), e);
            }
        }
        module.setValues(tags);
        return module;
    }

    @Override
    public String getNamespaceUri() {
        return "http://base.google.com/cns/1.0";
    }
}

