/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.feed.module.base.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.rometools.feed.module.base.CustomTag;
import org.rometools.feed.module.base.CustomTagImpl;
import org.rometools.feed.module.base.CustomTags;
import org.rometools.feed.module.base.io.CustomTagParser;
import org.rometools.feed.module.base.io.GoogleBaseParser;
import org.rometools.feed.module.base.types.DateTimeRange;
import org.rometools.feed.module.base.types.FloatUnit;
import org.rometools.feed.module.base.types.IntUnit;
import org.rometools.feed.module.base.types.ShortDate;

public class CustomTagGenerator
implements ModuleGenerator {
    static final HashSet NAMESPACES = new HashSet();

    @Override
    public String getNamespaceUri() {
        return "http://base.google.com/cns/1.0";
    }

    @Override
    public Set getNamespaces() {
        return NAMESPACES;
    }

    @Override
    public void generate(Module module, Element element) {
        if (!(module instanceof CustomTags)) {
            return;
        }
        List tags = ((CustomTags)module).getValues();
        for (CustomTag tag : tags) {
            Element newTag;
            Element newTag2;
            if (tag.getValue() instanceof DateTimeRange) {
                DateTimeRange dtr = (DateTimeRange)tag.getValue();
                newTag2 = new Element(tag.getName(), CustomTagParser.NS);
                newTag2.setAttribute("type", "dateTimeRange");
                newTag2.addContent((Content)this.generateSimpleElement("start", GoogleBaseParser.LONG_DT_FMT.format(dtr.getStart())));
                newTag2.addContent((Content)this.generateSimpleElement("end", GoogleBaseParser.LONG_DT_FMT.format(dtr.getEnd())));
                element.addContent((Content)newTag2);
                continue;
            }
            if (tag.getValue() instanceof ShortDate) {
                ShortDate sd = (ShortDate)tag.getValue();
                newTag2 = this.generateSimpleElement(tag.getName(), GoogleBaseParser.SHORT_DT_FMT.format(sd));
                newTag2.setAttribute("type", "date");
                element.addContent((Content)newTag2);
                continue;
            }
            if (tag.getValue() instanceof Date) {
                Date d = (Date)tag.getValue();
                newTag2 = this.generateSimpleElement(tag.getName(), GoogleBaseParser.SHORT_DT_FMT.format(d));
                newTag2.setAttribute("type", "dateTime");
                element.addContent((Content)newTag2);
                continue;
            }
            if (tag.getValue() instanceof Integer) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "int");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof IntUnit) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "intUnit");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof Float) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "float");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof FloatUnit) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "floatUnit");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof String) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "string");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof URL) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "url");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof Boolean) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "boolean");
                element.addContent((Content)newTag);
                continue;
            }
            if (!(tag.getValue() instanceof CustomTagImpl.Location)) continue;
            newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
            newTag.setAttribute("type", "location");
            element.addContent((Content)newTag);
        }
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, CustomTagParser.NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(CustomTagParser.NS);
    }
}

