/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.rss;

import com.google.common.base.Preconditions;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.SyModule;
import com.sun.syndication.feed.rss.Category;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Enclosure;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.marmotta.commons.sesame.rio.rss.FeedParserBase;
import org.apache.marmotta.commons.sesame.rio.rss.RSSFormat;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.rometools.feed.module.content.ContentModule;
import org.rometools.feed.module.georss.GeoRSSModule;
import org.rometools.feed.module.mediarss.MediaEntryModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class RSSParser
extends FeedParserBase {
    private static Logger log = LoggerFactory.getLogger(RSSParser.class);

    public RSSParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public RSSParser(ValueFactory valueFactory) {
        super(valueFactory);
        this.valueFactory = valueFactory;
    }

    public RDFFormat getRDFFormat() {
        return RSSFormat.FORMAT;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        WireFeedInput input = new WireFeedInput();
        try {
            WireFeed feed = input.build(new InputSource(in));
            if (!(feed instanceof Channel)) {
                throw new RDFParseException("data stream is not an RSS feed");
            }
            this.parseFeed((Channel)feed);
        }
        catch (FeedException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        WireFeedInput input = new WireFeedInput();
        try {
            WireFeed feed = input.build(reader);
            if (!(feed instanceof Channel)) {
                throw new RDFParseException("data stream is not an RSS feed");
            }
            this.parseFeed((Channel)feed);
        }
        catch (FeedException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    private void parseFeedEntry(Item entry, Resource r_feed) throws RDFParseException, RDFHandlerException {
        String entryURI = entry.getUri() != null ? entry.getUri() : entry.getLink();
        URI r_entry = this.createURI(entryURI);
        URI rdf_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_entry, rdf_type, (Value)this.createURI("http://rdfs.org/sioc/ns#Post")));
        this.rdfHandler.handleStatement(this.createStatement(r_feed, this.createURI("http://rdfs.org/sioc/ns#container_of"), (Value)r_entry));
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_entry, this.createURI("http://rdfs.org/sioc/ns#has_container"), (Value)r_feed));
        this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/creator", entry.getAuthor());
        for (Object category : entry.getCategories()) {
            this.parseCategory((Resource)r_entry, (Category)category);
        }
        this.createUrlProperty((Resource)r_entry, "http://rdfs.org/sioc/ns#has_discussion", entry.getComments());
        if (entry.getContent() != null) {
            this.createStringProperty((Resource)r_entry, "http://purl.org/rss/1.0/modules/content/encoded", entry.getContent().getValue());
            this.createStringProperty((Resource)r_entry, "http://purl.org/rss/1.0/modules/content/format", entry.getContent().getType());
        }
        if (entry.getDescription() != null) {
            this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/description", entry.getDescription().getValue());
        }
        for (Enclosure enclosure : entry.getEnclosures()) {
            this.createUrlProperty((Resource)r_entry, "http://purl.org/dc/terms/hasPart", enclosure.getUrl());
        }
        this.createDateProperty((Resource)r_entry, "http://purl.org/dc/terms/valid", entry.getExpirationDate());
        this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/identifier", entry.getGuid().getValue());
        this.createUrlProperty((Resource)r_entry, "http://rdfs.org/sioc/ns#link", entry.getLink());
        for (Module module : entry.getModules()) {
            if (module instanceof DCModule) {
                this.parseDCModule((Resource)r_entry, (DCModule)module);
                continue;
            }
            if (module instanceof GeoRSSModule) {
                this.parseGeoModule((Resource)r_entry, (GeoRSSModule)module);
                continue;
            }
            if (module instanceof MediaEntryModule) {
                this.parseMediaModule((Resource)r_entry, (MediaEntryModule)module);
                continue;
            }
            if (module instanceof ContentModule) {
                this.parseContentModule((Resource)r_entry, (ContentModule)module);
                continue;
            }
            log.warn("module {} not supported yet", (Object)module.getUri());
        }
        this.createDateProperty((Resource)r_entry, "http://purl.org/dc/terms/issued", entry.getPubDate());
        if (entry.getSource() != null) {
            this.createUrlProperty((Resource)r_entry, "http://purl.org/dc/terms/source", entry.getSource().getUrl());
        }
        this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/title", entry.getTitle());
        log.debug("parsed RSS item {}", (Object)r_entry.stringValue());
    }

    private void parseFeed(Channel feed) throws RDFParseException, RDFHandlerException {
        String feedUri;
        if (log.isInfoEnabled()) {
            log.info("importing entries from {} feed '{}' found at '{}'", new Object[]{feed.getFeedType(), feed.getTitle(), feed.getUri()});
        }
        String string = feedUri = feed.getUri() != null ? feed.getUri() : feed.getLink();
        if (feedUri == null) {
            log.error("feed '{}' has neither uri nor link to reference", (Object)feed.getTitle());
            return;
        }
        this.setNamespace("http://purl.org/dc/terms/", "dcterms");
        this.setNamespace("http://purl.org/rss/1.0/modules/syndication/", "sy");
        this.setNamespace("http://purl.org/rss/1.0/modules/content/", "content");
        this.setNamespace("http://rdfs.org/sioc/ns#", "sioc");
        URI r_feed = this.createURI(feedUri);
        URI rdf_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_feed, rdf_type, (Value)this.createURI("http://rdfs.org/sioc/ns#Forum")));
        this.createUrlProperty((Resource)r_feed, "http://rdfs.org/sioc/ns#feed", feedUri);
        for (Category category : feed.getCategories()) {
            this.parseCategory((Resource)r_feed, category);
        }
        if (feed.getCloud() != null) {
            this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/cloudUpdateProtocol", feed.getCloud().getProtocol());
            this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/cloudUpdateDomain", feed.getCloud().getDomain());
            this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/cloudUpdatePath", feed.getCloud().getPath());
            this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/cloudUpdateProcedure", feed.getCloud().getRegisterProcedure());
            this.createIntProperty((Resource)r_feed, "http://purl.org/rss/1.0/cloudUpdatePort", feed.getCloud().getPort());
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/rights", feed.getCopyright());
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/description", feed.getDescription());
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/provenance", feed.getGenerator());
        if (feed.getImage() != null) {
            this.createUrlProperty((Resource)r_feed, "http://xmlns.com/foaf/0.1/depiction", feed.getImage().getUrl());
        }
        for (Item item : feed.getItems()) {
            this.parseFeedEntry(item, (Resource)r_feed);
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/language", feed.getLanguage());
        this.createDateProperty((Resource)r_feed, "http://purl.org/dc/terms/created", feed.getLastBuildDate());
        this.createUrlProperty((Resource)r_feed, "http://rdfs.org/sioc/ns#link", feed.getLink());
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/creator", feed.getManagingEditor());
        for (Module module : feed.getModules()) {
            if (module instanceof SyModule) {
                SyModule syModule = (SyModule)module;
                this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/modules/syndication/updatePeriod", syModule.getUpdatePeriod());
                this.createIntProperty((Resource)r_feed, "http://purl.org/rss/1.0/modules/syndication/updateFrequency", syModule.getUpdateFrequency());
                this.createDateProperty((Resource)r_feed, "http://purl.org/rss/1.0/modules/syndication/updateBase", syModule.getUpdateBase());
                continue;
            }
            if (!(module instanceof DCModule)) continue;
            this.parseDCModule((Resource)r_feed, (DCModule)module);
        }
        this.createDateProperty((Resource)r_feed, "http://purl.org/dc/terms/issued", feed.getPubDate());
        this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/rating", feed.getRating());
        for (String day : feed.getSkipDays()) {
            this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/skipDay", day);
        }
        for (Integer hour : feed.getSkipHours()) {
            this.createIntProperty((Resource)r_feed, "http://purl.org/rss/1.0/skipHour", hour);
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/title", feed.getTitle());
        if (feed.getTtl() > 0) {
            this.createIntProperty((Resource)r_feed, "http://purl.org/rss/1.0/ttl", feed.getTtl());
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/publisher", feed.getWebMaster());
        log.info("importing RSS feed finished successfully.");
    }

    protected void parseCategory(Resource resource, Category category) throws RDFHandlerException, RDFParseException {
        if (category.getValue() == null) {
            return;
        }
        try {
            URI skosConcept;
            if (category.getDomain() != null && category.getValue() != null) {
                String localName = URLEncoder.encode(category.getValue(), "UTF-8");
                String namespace = category.getDomain();
                skosConcept = this.createURI(namespace + (namespace.endsWith("/") || namespace.endsWith("#") ? "" : "/") + localName);
            } else {
                String localName = URLEncoder.encode(category.getValue(), "UTF-8");
                skosConcept = this.resolveURI(localName);
            }
            this.createUrlProperty((Resource)skosConcept, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2004/02/skos/core#Concept");
            this.createStringProperty((Resource)skosConcept, "http://www.w3.org/2004/02/skos/core#prefLabel", category.getValue());
            this.rdfHandler.handleStatement(this.createStatement(resource, this.createURI("http://rdfs.org/sioc/ns#topic"), (Value)skosConcept));
        }
        catch (UnsupportedEncodingException e) {
            throw new RDFParseException((Throwable)e);
        }
        this.createStringProperty(resource, "http://purl.org/dc/terms/subject", category.getValue());
    }
}

