/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.rss;

import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCSubject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;
import org.rometools.feed.module.content.ContentModule;
import org.rometools.feed.module.georss.GeoRSSModule;
import org.rometools.feed.module.mediarss.MediaEntryModule;
import org.rometools.feed.module.mediarss.types.MediaContent;
import org.rometools.feed.module.mediarss.types.Metadata;
import org.rometools.feed.module.mediarss.types.UrlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeedParserBase
extends RDFParserBase {
    private static Logger log = LoggerFactory.getLogger(FeedParserBase.class);
    protected static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected static final String NS_DC = "http://purl.org/dc/elements/1.1/";
    protected static final String NS_DC_TERMS = "http://purl.org/dc/terms/";
    protected static final String NS_SIOC = "http://rdfs.org/sioc/ns#";
    protected static final String NS_SKOS = "http://www.w3.org/2004/02/skos/core#";
    protected static final String NS_RSS = "http://purl.org/rss/1.0/";
    protected static final String NS_RSS_CONTENT = "http://purl.org/rss/1.0/modules/content/";
    protected static final String NS_RSS_SY = "http://purl.org/rss/1.0/modules/syndication/";
    protected static final String NS_ADMIN = "http://webns.net/mvcb/";
    protected static final String NS_FOAF = "http://xmlns.com/foaf/0.1/";
    protected static final String NS_GEO = "http://www.w3.org/2003/01/geo/wgs84_pos#";
    protected static final String NS_MA = "http://www.w3.org/ns/ma-ont#";
    protected ValueFactory valueFactory;

    protected FeedParserBase() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    protected FeedParserBase(ValueFactory valueFactory) {
        super(valueFactory);
        this.valueFactory = valueFactory;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        super.setValueFactory(valueFactory);
        this.valueFactory = valueFactory;
    }

    protected void parseDCModule(Resource resource, DCModule dcModule) throws RDFHandlerException, RDFParseException {
        for (String contributor : dcModule.getContributors()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/contributor", contributor);
        }
        for (String coverage : dcModule.getCoverages()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/coverage", coverage);
        }
        for (String creator : dcModule.getCreators()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/creator", creator);
        }
        for (Date date : dcModule.getDates()) {
            this.createDateProperty(resource, "http://purl.org/dc/terms/date", date);
        }
        for (String description : dcModule.getDescriptions()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/description", description);
        }
        for (String format : dcModule.getFormats()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/format", format);
        }
        for (String identifier : dcModule.getIdentifiers()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/identifier", identifier);
        }
        for (String language : dcModule.getLanguages()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/language", language);
        }
        for (String publisher : dcModule.getPublishers()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/publisher", publisher);
        }
        for (String relation : dcModule.getRelations()) {
            this.createUrlProperty(resource, "http://purl.org/dc/terms/relation", relation);
        }
        for (String rights : dcModule.getRightsList()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/rights", rights);
        }
        for (String source : dcModule.getSources()) {
            this.createUrlProperty(resource, "http://purl.org/dc/terms/source", source);
        }
        for (DCSubject subject : dcModule.getSubjects()) {
            this.parseDCSubject(resource, subject);
        }
        for (String title : dcModule.getTitles()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/title", title);
        }
        for (String type : dcModule.getTypes()) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/type", type);
        }
    }

    protected void parseContentModule(Resource resource, ContentModule contentModule) throws RDFHandlerException, RDFParseException {
        for (Object content : contentModule.getEncodeds()) {
            this.createStringProperty(resource, "http://purl.org/rss/1.0/modules/content/encoded", (String)content);
        }
        if (contentModule.getContentItems() != null && contentModule.getContentItems().size() > 0) {
            log.warn("content items are not supported yet");
        }
    }

    protected void parseGeoModule(Resource resource, GeoRSSModule geoRSSModule) throws RDFParseException, RDFHandlerException {
        if (geoRSSModule.getPosition() != null) {
            BNode r_location = this.createBNode();
            URI t_adr = this.createURI("http://www.w3.org/2003/01/geo/wgs84_pos#Point");
            URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_type, (Value)t_adr));
            this.createDoubleProperty((Resource)r_location, "http://www.w3.org/2003/01/geo/wgs84_pos#latitude", geoRSSModule.getPosition().getLatitude());
            this.createDoubleProperty((Resource)r_location, "http://www.w3.org/2003/01/geo/wgs84_pos#longitude", geoRSSModule.getPosition().getLongitude());
            this.rdfHandler.handleStatement(this.createStatement(resource, this.createURI("http://purl.org/dc/terms/spatial"), (Value)r_location));
        }
    }

    protected void parseMediaModule(Resource resource, MediaEntryModule mediaEntryModule) throws RDFParseException, RDFHandlerException {
        for (MediaContent content : mediaEntryModule.getMediaContents()) {
            if (content.getReference() == null || !(content.getReference() instanceof UrlReference)) continue;
            URI r_media = this.createURI(((UrlReference)content.getReference()).getUrl().toString());
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_media, this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.createURI("http://www.w3.org/ns/ma-ont#MediaResource")));
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_media, this.createURI("http://www.w3.org/ns/ma-ont#locator"), (Value)r_media));
            if (content.getBitrate() != null) {
                this.createDoubleProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#averageBitRate", content.getBitrate().floatValue());
            }
            if (content.getDuration() != null) {
                this.createLongProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#duration", content.getDuration());
            }
            this.createStringProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#hasFormat", content.getType());
            if (content.getFramerate() != null) {
                this.createDoubleProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#frameRate", content.getFramerate().floatValue());
            }
            if (content.getHeight() != null) {
                this.createIntProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#frameHeight", content.getHeight());
            }
            if (content.getWidth() != null) {
                this.createIntProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#frameWidth", content.getWidth());
            }
            this.createStringProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#hasLanguage", content.getLanguage());
            if (content.getMetadata() != null) {
                Metadata metadata = content.getMetadata();
                this.createStringProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#title", metadata.getTitle());
                this.createStringProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#copyright", metadata.getCopyright());
                this.createStringProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#description", metadata.getDescription());
                for (String keyword : metadata.getKeywords()) {
                    this.createStringProperty((Resource)r_media, "http://www.w3.org/ns/ma-ont#hasKeyword", keyword);
                }
            }
            this.rdfHandler.handleStatement(this.createStatement(resource, this.createURI("http://rdfs.org/sioc/ns#hasPart"), (Value)r_media));
        }
    }

    protected void parseDCSubject(Resource resource, DCSubject category) throws RDFHandlerException, RDFParseException {
        if (category.getValue() == null) {
            return;
        }
        try {
            URI skosConcept;
            if (category.getTaxonomyUri() != null && category.getValue() != null) {
                String localName = URLEncoder.encode(category.getValue(), "UTF-8");
                String namespace = category.getTaxonomyUri();
                skosConcept = this.createURI(namespace + (namespace.endsWith("/") || namespace.endsWith("#") ? "" : "/") + localName);
            } else {
                String localName = URLEncoder.encode(category.getValue(), "UTF-8");
                skosConcept = this.resolveURI(localName);
            }
            this.createUrlProperty((Resource)skosConcept, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2004/02/skos/core#Concept");
            this.createStringProperty((Resource)skosConcept, "http://www.w3.org/2004/02/skos/core#prefLabel", category.getValue());
            this.rdfHandler.handleStatement(this.createStatement(resource, this.createURI("http://rdfs.org/sioc/ns#topic"), (Value)skosConcept));
        }
        catch (UnsupportedEncodingException e) {
            throw new RDFParseException((Throwable)e);
        }
        this.createStringProperty(resource, "http://purl.org/dc/terms/subject", category.getValue());
    }

    protected void createStringProperty(Resource resource, String rdfProperty, String value) throws RDFParseException, RDFHandlerException {
        if (value != null && !"".equals(value.trim())) {
            URI p_description = this.createURI(rdfProperty);
            Literal v_description = this.createLiteral(value, null, null);
            this.rdfHandler.handleStatement(this.createStatement(resource, p_description, (Value)v_description));
        }
    }

    protected void createIntProperty(Resource resource, String rdfProperty, int value) throws RDFParseException, RDFHandlerException {
        URI p_description = this.createURI(rdfProperty);
        Literal v_description = this.createLiteral("" + value, null, this.createURI("http://www.w3.org/2001/XMLSchema#int"));
        this.rdfHandler.handleStatement(this.createStatement(resource, p_description, (Value)v_description));
    }

    protected void createLongProperty(Resource resource, String rdfProperty, long value) throws RDFParseException, RDFHandlerException {
        URI p_description = this.createURI(rdfProperty);
        Literal v_description = this.createLiteral("" + value, null, this.createURI("http://www.w3.org/2001/XMLSchema#long"));
        this.rdfHandler.handleStatement(this.createStatement(resource, p_description, (Value)v_description));
    }

    protected void createDoubleProperty(Resource resource, String rdfProperty, double value) throws RDFParseException, RDFHandlerException {
        URI p_description = this.createURI(rdfProperty);
        Literal v_description = this.createLiteral("" + value, null, this.createURI("http://www.w3.org/2001/XMLSchema#double"));
        this.rdfHandler.handleStatement(this.createStatement(resource, p_description, (Value)v_description));
    }

    protected void createDateProperty(Resource resource, String rdfProperty, Date value) throws RDFParseException, RDFHandlerException {
        if (value != null) {
            URI p_dateprop = this.createURI(rdfProperty);
            Literal v_dateprop = this.valueFactory.createLiteral(FeedParserBase.getXMLCalendar(value, null));
            this.rdfHandler.handleStatement(this.createStatement(resource, p_dateprop, (Value)v_dateprop));
        }
    }

    protected void createUrlProperty(Resource resource, String rdfProperty, String value) throws RDFParseException, RDFHandlerException {
        if (value != null) {
            URI p_description = this.createURI(rdfProperty);
            URI v_description = this.createURI(value);
            this.rdfHandler.handleStatement(this.createStatement(resource, p_description, (Value)v_description));
        }
    }

    protected void createUrlProperty(Resource resource, String rdfProperty, Resource value) throws RDFParseException, RDFHandlerException {
        if (value != null) {
            URI p_description = this.createURI(rdfProperty);
            this.rdfHandler.handleStatement(this.createStatement(resource, p_description, (Value)value));
        }
    }

    protected static XMLGregorianCalendar getXMLCalendar(Date date, TimeZone timezone) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        if (timezone != null) {
            c.setTimeZone(timezone);
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }
}

