/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.rss;

import com.google.common.base.Preconditions;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.SyModule;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.marmotta.commons.sesame.rio.rss.AtomFormat;
import org.apache.marmotta.commons.sesame.rio.rss.FeedParserBase;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.rometools.feed.module.content.ContentModule;
import org.rometools.feed.module.georss.GeoRSSModule;
import org.rometools.feed.module.mediarss.MediaEntryModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class AtomParser
extends FeedParserBase {
    private static Logger log = LoggerFactory.getLogger(AtomParser.class);

    public AtomParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public AtomParser(ValueFactory valueFactory) {
        super(valueFactory);
        this.valueFactory = valueFactory;
    }

    public RDFFormat getRDFFormat() {
        return AtomFormat.FORMAT;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        WireFeedInput input = new WireFeedInput();
        try {
            WireFeed feed = input.build(new InputSource(in));
            if (!(feed instanceof Feed)) {
                throw new RDFParseException("data stream is not an RSS feed");
            }
            this.parseFeed((Feed)feed);
        }
        catch (FeedException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        WireFeedInput input = new WireFeedInput();
        try {
            WireFeed feed = input.build(reader);
            if (!(feed instanceof Feed)) {
                throw new RDFParseException("data stream is not an RSS feed");
            }
            this.parseFeed((Feed)feed);
        }
        catch (FeedException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    private void parseFeedEntry(Entry entry, Resource r_feed) throws RDFParseException, RDFHandlerException {
        String entryURI = entry.getId();
        URI r_entry = this.createURI(entryURI);
        URI rdf_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_entry, rdf_type, (Value)this.createURI("http://rdfs.org/sioc/ns#Post")));
        this.rdfHandler.handleStatement(this.createStatement(r_feed, this.createURI("http://rdfs.org/sioc/ns#container_of"), (Value)r_entry));
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_entry, this.createURI("http://rdfs.org/sioc/ns#has_container"), (Value)r_feed));
        for (Link link : entry.getAlternateLinks()) {
            this.createUrlProperty((Resource)r_entry, "http://rdfs.org/sioc/ns#link", (Resource)this.resolveURI(link.getHref()));
        }
        for (Person person : entry.getAuthors()) {
            this.parsePerson((Resource)r_entry, person, "creator");
        }
        for (Cloneable category : entry.getCategories()) {
            this.parseCategory((Resource)r_entry, (Category)category);
        }
        for (Content content : entry.getContents()) {
            this.createStringProperty((Resource)r_entry, "http://purl.org/rss/1.0/modules/content/encoded", content.getValue());
            this.createStringProperty((Resource)r_entry, "http://purl.org/rss/1.0/modules/content/format", content.getType());
            this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/description", content.getValue());
        }
        for (Person person : entry.getContributors()) {
            this.parsePerson((Resource)r_entry, person, "contributor");
        }
        this.createDateProperty((Resource)r_entry, "http://purl.org/dc/terms/created", entry.getCreated());
        this.createDateProperty((Resource)r_entry, "http://purl.org/dc/terms/issued", entry.getPublished());
        this.createDateProperty((Resource)r_entry, "http://purl.org/dc/terms/modified", entry.getUpdated());
        this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/identifier", entry.getId());
        for (Cloneable module : entry.getModules()) {
            if (module instanceof DCModule) {
                this.parseDCModule((Resource)r_entry, (DCModule)module);
                continue;
            }
            if (module instanceof GeoRSSModule) {
                this.parseGeoModule((Resource)r_entry, (GeoRSSModule)module);
                continue;
            }
            if (module instanceof MediaEntryModule) {
                this.parseMediaModule((Resource)r_entry, (MediaEntryModule)module);
                continue;
            }
            if (module instanceof ContentModule) {
                this.parseContentModule((Resource)r_entry, (ContentModule)module);
                continue;
            }
            log.warn("module {} not supported yet", (Object)module.toString());
        }
        for (Link link : entry.getOtherLinks()) {
            this.createUrlProperty((Resource)r_entry, "http://rdfs.org/sioc/ns#link", (Resource)this.resolveURI(link.getHref()));
        }
        this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/rights", entry.getRights());
        if (entry.getSource() != null) {
            this.createUrlProperty((Resource)r_entry, "http://purl.org/dc/terms/source", entry.getSource().getId());
        }
        if (entry.getSummary() != null) {
            this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/abstract", entry.getSummary().getValue());
        }
        this.createStringProperty((Resource)r_entry, "http://purl.org/dc/terms/title", entry.getTitle());
        log.debug("parsed Atom item {}", (Object)r_entry.stringValue());
    }

    private void parseFeed(Feed feed) throws RDFParseException, RDFHandlerException {
        String feedUri;
        if (log.isInfoEnabled()) {
            log.info("importing entries from {} feed '{}' found at '{}'", new Object[]{feed.getFeedType(), feed.getTitle(), feed.getId()});
        }
        if ((feedUri = feed.getId()) == null) {
            log.error("feed '{}' has neither uri nor link to reference", (Object)feed.getTitle());
            return;
        }
        this.setNamespace("http://purl.org/dc/terms/", "dcterms");
        this.setNamespace("http://purl.org/rss/1.0/modules/syndication/", "sy");
        this.setNamespace("http://purl.org/rss/1.0/modules/content/", "content");
        this.setNamespace("http://rdfs.org/sioc/ns#", "sioc");
        URI r_feed = this.createURI(feedUri);
        URI rdf_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_feed, rdf_type, (Value)this.createURI("http://rdfs.org/sioc/ns#Forum")));
        this.createUrlProperty((Resource)r_feed, "http://rdfs.org/sioc/ns#feed", feedUri);
        for (Link link : feed.getAlternateLinks()) {
            this.createUrlProperty((Resource)r_feed, "http://rdfs.org/sioc/ns#link", (Resource)this.resolveURI(link.getHref()));
        }
        for (Person person : feed.getAuthors()) {
            this.parsePerson((Resource)r_feed, person, "creator");
        }
        for (Cloneable category : feed.getCategories()) {
            this.parseCategory((Resource)r_feed, (Category)category);
        }
        for (Person person : feed.getAuthors()) {
            this.parsePerson((Resource)r_feed, person, "contributor");
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/provenance", feed.getGenerator().getValue());
        if (feed.getIcon() != null) {
            this.createUrlProperty((Resource)r_feed, "http://xmlns.com/foaf/0.1/thumbnail", (Resource)this.resolveURI(feed.getIcon()));
        }
        for (Entry item : feed.getEntries()) {
            this.parseFeedEntry(item, (Resource)r_feed);
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/language", feed.getLanguage());
        if (feed.getLogo() != null) {
            this.createUrlProperty((Resource)r_feed, "http://xmlns.com/foaf/0.1/logo", (Resource)this.resolveURI(feed.getLogo()));
        }
        for (Module module : feed.getModules()) {
            if (module instanceof SyModule) {
                SyModule syModule = (SyModule)module;
                this.createStringProperty((Resource)r_feed, "http://purl.org/rss/1.0/modules/syndication/updatePeriod", syModule.getUpdatePeriod());
                this.createIntProperty((Resource)r_feed, "http://purl.org/rss/1.0/modules/syndication/updateFrequency", syModule.getUpdateFrequency());
                this.createDateProperty((Resource)r_feed, "http://purl.org/rss/1.0/modules/syndication/updateBase", syModule.getUpdateBase());
                continue;
            }
            if (!(module instanceof DCModule)) continue;
            this.parseDCModule((Resource)r_feed, (DCModule)module);
        }
        for (Link link : feed.getOtherLinks()) {
            this.createUrlProperty((Resource)r_feed, "http://rdfs.org/sioc/ns#link", (Resource)this.resolveURI(link.getHref()));
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/rights", feed.getRights());
        if (feed.getSubtitle() != null) {
            this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/description", feed.getSubtitle().getValue());
        }
        this.createStringProperty((Resource)r_feed, "http://purl.org/dc/terms/title", feed.getTitle());
        this.createDateProperty((Resource)r_feed, "http://purl.org/dc/terms/created", feed.getUpdated());
        this.createDateProperty((Resource)r_feed, "http://purl.org/dc/terms/issued", feed.getUpdated());
        log.info("importing Atom feed finished successfully.");
    }

    protected void parseCategory(Resource resource, Category category) throws RDFHandlerException, RDFParseException {
        if (category.getTerm() == null) {
            return;
        }
        try {
            URI skosConcept;
            if (category.getScheme() != null) {
                String localName = URLEncoder.encode(category.getTerm(), "UTF-8");
                String namespace = category.getScheme();
                skosConcept = this.createURI(namespace + (namespace.endsWith("/") || namespace.endsWith("#") ? "" : "/") + localName);
            } else {
                String localName = URLEncoder.encode(category.getTerm(), "UTF-8");
                skosConcept = this.resolveURI(localName);
            }
            this.createUrlProperty((Resource)skosConcept, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2004/02/skos/core#Concept");
            if (category.getLabel() != null) {
                this.createStringProperty((Resource)skosConcept, "http://www.w3.org/2004/02/skos/core#prefLabel", category.getLabel());
            } else {
                this.createStringProperty((Resource)skosConcept, "http://www.w3.org/2004/02/skos/core#prefLabel", category.getTerm());
            }
            this.rdfHandler.handleStatement(this.createStatement(resource, this.createURI("http://rdfs.org/sioc/ns#topic"), (Value)skosConcept));
        }
        catch (UnsupportedEncodingException e) {
            throw new RDFParseException((Throwable)e);
        }
        if (category.getLabel() != null) {
            this.createStringProperty(resource, "http://purl.org/dc/terms/subject", category.getLabel());
        } else {
            this.createStringProperty(resource, "http://purl.org/dc/terms/subject", category.getTerm());
        }
    }

    protected void parsePerson(Resource r_entry, Person person, String relation) throws RDFParseException, RDFHandlerException {
        if ("creator".equals(relation) && (person.getUri() != null || person.getEmail() != null)) {
            String personUri = person.getUri() != null ? person.getUri() : "mailto:" + person.getEmail();
            URI r_person = this.createURI(personUri);
            this.createStringProperty((Resource)r_person, "http://xmlns.com/foaf/0.1/name", person.getName());
            if (person.getEmail() != null) {
                this.createUrlProperty((Resource)r_person, "http://xmlns.com/foaf/0.1/mbox", "mailto:" + person.getEmail());
            }
            this.createUrlProperty((Resource)r_person, "http://xmlns.com/foaf/0.1/homepage", person.getUri());
            this.rdfHandler.handleStatement(this.createStatement(r_entry, this.createURI("http://xmlns.com/foaf/0.1/maker"), (Value)r_person));
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_person, this.createURI("http://xmlns.com/foaf/0.1/made"), (Value)r_entry));
        }
        this.createStringProperty(r_entry, "http://purl.org/dc/terms/" + relation, person.getName());
    }
}

