/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.rss.Category;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Guid;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.feed.synd.impl.ConverterForRSS093;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ConverterForRSS094
extends ConverterForRSS093 {
    public ConverterForRSS094() {
        this("rss_0.94");
    }

    protected ConverterForRSS094(String type) {
        super(type);
    }

    @Override
    public void copyInto(WireFeed feed, SyndFeed syndFeed) {
        Channel channel = (Channel)feed;
        super.copyInto(channel, syndFeed);
        List<Category> cats = channel.getCategories();
        if (cats.size() > 0) {
            HashSet<SyndCategory> s = new HashSet<SyndCategory>();
            s.addAll(this.createSyndCategories(cats));
            s.addAll(syndFeed.getCategories());
            syndFeed.setCategories(new ArrayList<SyndCategory>(s));
        }
    }

    @Override
    protected SyndEntry createSyndEntry(Item item, boolean preserveWireItem) {
        Guid guid;
        List<String> creators;
        SyndEntry syndEntry = super.createSyndEntry(item, preserveWireItem);
        String author = item.getAuthor();
        if (author != null && !(creators = ((DCModule)syndEntry.getModule("http://purl.org/dc/elements/1.1/")).getCreators()).contains(author)) {
            HashSet<String> s = new HashSet<String>();
            s.addAll(creators);
            s.add(author);
            creators.clear();
            creators.addAll(s);
        }
        if ((guid = item.getGuid()) != null) {
            syndEntry.setUri(guid.getValue());
            if (item.getLink() == null && guid.isPermaLink()) {
                syndEntry.setLink(guid.getValue());
            }
        } else {
            syndEntry.setUri(item.getLink());
        }
        if (item.getComments() != null) {
            SyndLinkImpl comments = new SyndLinkImpl();
            comments.setRel("comments");
            comments.setHref(item.getComments());
            comments.setType("text/html");
        }
        return syndEntry;
    }

    @Override
    protected WireFeed createRealFeed(String type, SyndFeed syndFeed) {
        Channel channel = (Channel)super.createRealFeed(type, syndFeed);
        List<SyndCategory> cats = syndFeed.getCategories();
        if (cats.size() > 0) {
            channel.setCategories(this.createRSSCategories(cats));
        }
        return channel;
    }

    @Override
    protected Item createRSSItem(SyndEntry sEntry) {
        Item item = super.createRSSItem(sEntry);
        if (sEntry.getAuthors() != null && sEntry.getAuthors().size() > 0) {
            SyndPerson author = sEntry.getAuthors().get(0);
            item.setAuthor(author.getEmail());
        }
        Guid guid = null;
        String uri = sEntry.getUri();
        if (uri != null) {
            guid = new Guid();
            guid.setPermaLink(false);
            guid.setValue(uri);
        } else {
            String link = sEntry.getLink();
            if (link != null) {
                guid = new Guid();
                guid.setPermaLink(true);
                guid.setValue(link);
            }
        }
        item.setGuid(guid);
        SyndLink comments = sEntry.findRelatedLink("comments");
        if (comments != null && (comments.getType() == null || comments.getType().endsWith("html"))) {
            item.setComments(comments.getHref());
        }
        return item;
    }
}

