/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd;

import com.sun.syndication.feed.CopyFrom;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.impl.CopyFromHelper;
import com.sun.syndication.feed.impl.ObjectBean;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.SyModule;
import com.sun.syndication.feed.module.SyModuleImpl;
import com.sun.syndication.feed.module.impl.ModuleUtils;
import com.sun.syndication.feed.synd.Converter;
import com.sun.syndication.feed.synd.SyndCategoryListFacade;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.feed.synd.impl.Converters;
import com.sun.syndication.feed.synd.impl.URINormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SyndFeedImpl
implements Serializable,
SyndFeed {
    private ObjectBean _objBean;
    private String _encoding;
    private String _uri;
    private SyndContent _title;
    private SyndContent _description;
    private String _feedType;
    private String _link;
    private List _links;
    private SyndImage _image;
    private List _entries;
    private List _modules;
    private List _authors;
    private List _contributors;
    private List _foreignMarkup;
    private WireFeed wireFeed = null;
    private boolean preserveWireFeed = false;
    private static final Converters CONVERTERS = new Converters();
    private static final Set IGNORE_PROPERTIES = new HashSet();
    public static final Set CONVENIENCE_PROPERTIES = Collections.unmodifiableSet(IGNORE_PROPERTIES);
    private static final CopyFromHelper COPY_FROM_HELPER;

    public List getSupportedFeedTypes() {
        return CONVERTERS.getSupportedFeedTypes();
    }

    protected SyndFeedImpl(Class beanClass, Set convenienceProperties) {
        this._objBean = new ObjectBean(beanClass, this, convenienceProperties);
    }

    public SyndFeedImpl() {
        this(null);
    }

    public SyndFeedImpl(WireFeed feed) {
        this(feed, false);
    }

    public SyndFeedImpl(WireFeed feed, boolean preserveWireFeed) {
        this(SyndFeed.class, IGNORE_PROPERTIES);
        if (preserveWireFeed) {
            this.wireFeed = feed;
            this.preserveWireFeed = preserveWireFeed;
        }
        if (feed != null) {
            this._feedType = feed.getFeedType();
            Converter converter = CONVERTERS.getConverter(this._feedType);
            if (converter == null) {
                throw new IllegalArgumentException("Invalid feed type [" + this._feedType + "]");
            }
            converter.copyInto(feed, this);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this._objBean.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Object fm = this.getForeignMarkup();
        this.setForeignMarkup(((SyndFeedImpl)other).getForeignMarkup());
        boolean ret = this._objBean.equals(other);
        this.setForeignMarkup(fm);
        return ret;
    }

    public int hashCode() {
        return this._objBean.hashCode();
    }

    public String toString() {
        return this._objBean.toString();
    }

    @Override
    public WireFeed createWireFeed() {
        return this.createWireFeed(this._feedType);
    }

    @Override
    public WireFeed createWireFeed(String feedType) {
        if (feedType == null) {
            throw new IllegalArgumentException("Feed type cannot be null");
        }
        Converter converter = CONVERTERS.getConverter(feedType);
        if (converter == null) {
            throw new IllegalArgumentException("Invalid feed type [" + feedType + "]");
        }
        return converter.createRealFeed(this);
    }

    @Override
    public WireFeed originalWireFeed() {
        return this.wireFeed;
    }

    @Override
    public String getFeedType() {
        return this._feedType;
    }

    @Override
    public void setFeedType(String feedType) {
        this._feedType = feedType;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    @Override
    public String getUri() {
        return this._uri;
    }

    @Override
    public void setUri(String uri) {
        this._uri = URINormalizer.normalize(uri);
    }

    @Override
    public String getTitle() {
        if (this._title != null) {
            return this._title.getValue();
        }
        return null;
    }

    @Override
    public void setTitle(String title) {
        if (this._title == null) {
            this._title = new SyndContentImpl();
        }
        this._title.setValue(title);
    }

    @Override
    public SyndContent getTitleEx() {
        return this._title;
    }

    @Override
    public void setTitleEx(SyndContent title) {
        this._title = title;
    }

    @Override
    public String getLink() {
        return this._link;
    }

    @Override
    public void setLink(String link) {
        this._link = link;
    }

    @Override
    public String getDescription() {
        if (this._description != null) {
            return this._description.getValue();
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        if (this._description == null) {
            this._description = new SyndContentImpl();
        }
        this._description.setValue(description);
    }

    @Override
    public SyndContent getDescriptionEx() {
        return this._description;
    }

    @Override
    public void setDescriptionEx(SyndContent description) {
        this._description = description;
    }

    @Override
    public Date getPublishedDate() {
        return this.getDCModule().getDate();
    }

    @Override
    public void setPublishedDate(Date publishedDate) {
        this.getDCModule().setDate(publishedDate);
    }

    @Override
    public String getCopyright() {
        return this.getDCModule().getRights();
    }

    @Override
    public void setCopyright(String copyright) {
        this.getDCModule().setRights(copyright);
    }

    @Override
    public SyndImage getImage() {
        return this._image;
    }

    @Override
    public void setImage(SyndImage image) {
        this._image = image;
    }

    public List getCategories() {
        return new SyndCategoryListFacade(this.getDCModule().getSubjects());
    }

    public void setCategories(List categories) {
        this.getDCModule().setSubjects(SyndCategoryListFacade.convertElementsSyndCategoryToSubject(categories));
    }

    public List getEntries() {
        return this._entries == null ? (this._entries = new ArrayList()) : this._entries;
    }

    public void setEntries(List entries) {
        this._entries = entries;
    }

    @Override
    public String getLanguage() {
        return this.getDCModule().getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        this.getDCModule().setLanguage(language);
    }

    public List getModules() {
        if (this._modules == null) {
            this._modules = new ArrayList();
        }
        if (ModuleUtils.getModule(this._modules, "http://purl.org/dc/elements/1.1/") == null) {
            this._modules.add(new DCModuleImpl());
        }
        return this._modules;
    }

    @Override
    public void setModules(List modules) {
        this._modules = modules;
    }

    @Override
    public Module getModule(String uri) {
        return ModuleUtils.getModule(this.getModules(), uri);
    }

    private DCModule getDCModule() {
        return (DCModule)this.getModule("http://purl.org/dc/elements/1.1/");
    }

    public Class getInterface() {
        return SyndFeed.class;
    }

    @Override
    public void copyFrom(CopyFrom obj) {
        COPY_FROM_HELPER.copy(this, obj);
    }

    public List getLinks() {
        return this._links == null ? (this._links = new ArrayList()) : this._links;
    }

    public void setLinks(List links) {
        this._links = links;
    }

    public List getAuthors() {
        return this._authors == null ? (this._authors = new ArrayList()) : this._authors;
    }

    public void setAuthors(List authors) {
        this._authors = authors;
    }

    @Override
    public String getAuthor() {
        return this.getDCModule().getCreator();
    }

    @Override
    public void setAuthor(String author) {
        this.getDCModule().setCreator(author);
    }

    public List getContributors() {
        return this._contributors == null ? (this._contributors = new ArrayList()) : this._contributors;
    }

    public void setContributors(List contributors) {
        this._contributors = contributors;
    }

    @Override
    public Object getForeignMarkup() {
        return this._foreignMarkup == null ? (this._foreignMarkup = new ArrayList()) : this._foreignMarkup;
    }

    @Override
    public void setForeignMarkup(Object foreignMarkup) {
        this._foreignMarkup = (List)foreignMarkup;
    }

    @Override
    public boolean isPreservingWireFeed() {
        return this.preserveWireFeed;
    }

    static {
        IGNORE_PROPERTIES.add("publishedDate");
        IGNORE_PROPERTIES.add("author");
        IGNORE_PROPERTIES.add("copyright");
        IGNORE_PROPERTIES.add("categories");
        IGNORE_PROPERTIES.add("language");
        HashMap<String, Class> basePropInterfaceMap = new HashMap<String, Class>();
        basePropInterfaceMap.put("feedType", String.class);
        basePropInterfaceMap.put("encoding", String.class);
        basePropInterfaceMap.put("uri", String.class);
        basePropInterfaceMap.put("title", String.class);
        basePropInterfaceMap.put("link", String.class);
        basePropInterfaceMap.put("description", String.class);
        basePropInterfaceMap.put("image", SyndImage.class);
        basePropInterfaceMap.put("entries", SyndEntry.class);
        basePropInterfaceMap.put("modules", Module.class);
        HashMap<Class, Class> basePropClassImplMap = new HashMap<Class, Class>();
        basePropClassImplMap.put(SyndEntry.class, SyndEntryImpl.class);
        basePropClassImplMap.put(SyndImage.class, SyndImageImpl.class);
        basePropClassImplMap.put(DCModule.class, DCModuleImpl.class);
        basePropClassImplMap.put(SyModule.class, SyModuleImpl.class);
        COPY_FROM_HELPER = new CopyFromHelper(SyndFeed.class, basePropInterfaceMap, basePropClassImplMap);
    }
}

