/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd;

import com.sun.syndication.feed.CopyFrom;
import com.sun.syndication.feed.impl.CopyFromHelper;
import com.sun.syndication.feed.impl.ObjectBean;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.SyModule;
import com.sun.syndication.feed.module.SyModuleImpl;
import com.sun.syndication.feed.module.impl.ModuleUtils;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.feed.synd.impl.URINormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SyndEntryImpl
implements Serializable,
SyndEntry {
    private ObjectBean _objBean;
    private String _uri;
    private String _link;
    private Date _updatedDate;
    private SyndContent _title;
    private SyndContent _description;
    private List<SyndLink> _links;
    private List<SyndContent> _contents;
    private List<Module> _modules;
    private List<SyndEnclosure> _enclosures;
    private List<SyndPerson> _authors;
    private List<SyndPerson> _contributors;
    private SyndFeed _source;
    private List _foreignMarkup;
    private Object wireEntry;
    private List _categories = new ArrayList();
    private static final Set IGNORE_PROPERTIES = new HashSet();
    public static final Set CONVENIENCE_PROPERTIES = Collections.unmodifiableSet(IGNORE_PROPERTIES);
    private static final CopyFromHelper COPY_FROM_HELPER;

    protected SyndEntryImpl(Class beanClass, Set convenienceProperties) {
        this._objBean = new ObjectBean(beanClass, this, convenienceProperties);
    }

    public SyndEntryImpl() {
        this(SyndEntry.class, IGNORE_PROPERTIES);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this._objBean.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SyndEntryImpl)) {
            return false;
        }
        Object fm = this.getForeignMarkup();
        this.setForeignMarkup(((SyndEntryImpl)other).getForeignMarkup());
        boolean ret = this._objBean.equals(other);
        this.setForeignMarkup(fm);
        return ret;
    }

    public int hashCode() {
        return this._objBean.hashCode();
    }

    public String toString() {
        return this._objBean.toString();
    }

    @Override
    public String getUri() {
        return this._uri;
    }

    @Override
    public void setUri(String uri) {
        this._uri = URINormalizer.normalize(uri);
    }

    @Override
    public String getTitle() {
        if (this._title != null) {
            return this._title.getValue();
        }
        return null;
    }

    @Override
    public void setTitle(String title) {
        if (this._title == null) {
            this._title = new SyndContentImpl();
        }
        this._title.setValue(title);
    }

    @Override
    public SyndContent getTitleEx() {
        return this._title;
    }

    @Override
    public void setTitleEx(SyndContent title) {
        this._title = title;
    }

    @Override
    public String getLink() {
        return this._link;
    }

    @Override
    public void setLink(String link) {
        this._link = link;
    }

    @Override
    public SyndContent getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(SyndContent description) {
        this._description = description;
    }

    @Override
    public List<SyndContent> getContents() {
        return this._contents == null ? (this._contents = new ArrayList<SyndContent>()) : this._contents;
    }

    @Override
    public void setContents(List<SyndContent> contents) {
        this._contents = contents;
    }

    @Override
    public List<SyndEnclosure> getEnclosures() {
        return this._enclosures == null ? (this._enclosures = new ArrayList<SyndEnclosure>()) : this._enclosures;
    }

    @Override
    public void setEnclosures(List<SyndEnclosure> enclosures) {
        this._enclosures = enclosures;
    }

    @Override
    public Date getPublishedDate() {
        return this.getDCModule().getDate();
    }

    @Override
    public void setPublishedDate(Date publishedDate) {
        this.getDCModule().setDate(publishedDate);
    }

    @Override
    public List<SyndCategory> getCategories() {
        return this._categories;
    }

    @Override
    public void setCategories(List<SyndCategory> categories) {
        this._categories = categories;
    }

    @Override
    public List<Module> getModules() {
        if (this._modules == null) {
            this._modules = new ArrayList<Module>();
        }
        if (ModuleUtils.getModule(this._modules, "http://purl.org/dc/elements/1.1/") == null) {
            this._modules.add(new DCModuleImpl());
        }
        return this._modules;
    }

    @Override
    public void setModules(List<Module> modules) {
        this._modules = modules;
    }

    @Override
    public Module getModule(String uri) {
        return ModuleUtils.getModule(this.getModules(), uri);
    }

    private DCModule getDCModule() {
        return (DCModule)this.getModule("http://purl.org/dc/elements/1.1/");
    }

    public Class getInterface() {
        return SyndEntry.class;
    }

    @Override
    public void copyFrom(CopyFrom obj) {
        COPY_FROM_HELPER.copy(this, obj);
    }

    @Override
    public List<SyndLink> getLinks() {
        return this._links == null ? (this._links = new ArrayList<SyndLink>()) : this._links;
    }

    public void setLinks(List links) {
        this._links = links;
    }

    @Override
    public Date getUpdatedDate() {
        return this._updatedDate == null ? null : new Date(this._updatedDate.getTime());
    }

    @Override
    public void setUpdatedDate(Date updatedDate) {
        this._updatedDate = new Date(updatedDate.getTime());
    }

    public List getAuthors() {
        return this._authors == null ? (this._authors = new ArrayList<SyndPerson>()) : this._authors;
    }

    public void setAuthors(List authors) {
        this._authors = authors;
    }

    @Override
    public String getAuthor() {
        String author = this._authors != null && this._authors.size() > 0 ? this._authors.get(0).getName() : this.getDCModule().getCreator();
        if (author == null) {
            author = "";
        }
        return author;
    }

    @Override
    public void setAuthor(String author) {
        DCModule dcModule = this.getDCModule();
        String currentValue = dcModule.getCreator();
        if (currentValue == null || currentValue.length() == 0) {
            this.getDCModule().setCreator(author);
        }
    }

    public List getContributors() {
        return this._contributors == null ? (this._contributors = new ArrayList<SyndPerson>()) : this._contributors;
    }

    public void setContributors(List contributors) {
        this._contributors = contributors;
    }

    @Override
    public SyndFeed getSource() {
        return this._source;
    }

    @Override
    public void setSource(SyndFeed source) {
        this._source = source;
    }

    @Override
    public Object getForeignMarkup() {
        return this._foreignMarkup == null ? (this._foreignMarkup = new ArrayList()) : this._foreignMarkup;
    }

    @Override
    public void setForeignMarkup(Object foreignMarkup) {
        this._foreignMarkup = (List)foreignMarkup;
    }

    @Override
    public Object getWireEntry() {
        return this.wireEntry;
    }

    public void setWireEntry(Object wireEntry) {
        this.wireEntry = wireEntry;
    }

    @Override
    public SyndLink findRelatedLink(String relation) {
        for (SyndLink l : this.getLinks()) {
            if (!relation.equals(l.getRel())) continue;
            return l;
        }
        return null;
    }

    static {
        IGNORE_PROPERTIES.add("publishedDate");
        IGNORE_PROPERTIES.add("author");
        HashMap<String, Class<Module>> basePropInterfaceMap = new HashMap<String, Class<Module>>();
        basePropInterfaceMap.put("uri", String.class);
        basePropInterfaceMap.put("title", String.class);
        basePropInterfaceMap.put("link", String.class);
        basePropInterfaceMap.put("uri", String.class);
        basePropInterfaceMap.put("description", SyndContent.class);
        basePropInterfaceMap.put("contents", SyndContent.class);
        basePropInterfaceMap.put("enclosures", SyndEnclosure.class);
        basePropInterfaceMap.put("modules", Module.class);
        HashMap<Class, Class> basePropClassImplMap = new HashMap<Class, Class>();
        basePropClassImplMap.put(SyndContent.class, SyndContentImpl.class);
        basePropClassImplMap.put(SyndEnclosure.class, SyndEnclosureImpl.class);
        basePropClassImplMap.put(DCModule.class, DCModuleImpl.class);
        basePropClassImplMap.put(SyModule.class, SyModuleImpl.class);
        COPY_FROM_HELPER = new CopyFromHelper(SyndEntry.class, basePropInterfaceMap, basePropClassImplMap);
    }
}

