/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module;

import com.sun.syndication.feed.CopyFrom;
import com.sun.syndication.feed.impl.CopyFromHelper;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.ModuleImpl;
import com.sun.syndication.feed.module.SyModule;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SyModuleImpl
extends ModuleImpl
implements SyModule {
    private static final Set<String> PERIODS = new HashSet<String>();
    private String _updatePeriod;
    private int _updateFrequency;
    private Date _updateBase;
    private static final CopyFromHelper COPY_FROM_HELPER;

    public SyModuleImpl() {
        super(SyModule.class, "http://purl.org/rss/1.0/modules/syndication/");
    }

    @Override
    public String getUpdatePeriod() {
        return this._updatePeriod;
    }

    @Override
    public void setUpdatePeriod(String updatePeriod) {
        if (!PERIODS.contains(updatePeriod)) {
            throw new IllegalArgumentException("Invalid period [" + updatePeriod + "]");
        }
        this._updatePeriod = updatePeriod;
    }

    @Override
    public int getUpdateFrequency() {
        return this._updateFrequency;
    }

    @Override
    public void setUpdateFrequency(int updateFrequency) {
        this._updateFrequency = updateFrequency;
    }

    @Override
    public Date getUpdateBase() {
        if (this._updateBase != null) {
            return new Date(this._updateBase.getTime());
        }
        return null;
    }

    @Override
    public void setUpdateBase(Date updateBase) {
        this._updateBase = updateBase != null ? new Date(updateBase.getTime()) : null;
    }

    public Class<? extends Module> getInterface() {
        return SyModule.class;
    }

    @Override
    public void copyFrom(CopyFrom obj) {
        COPY_FROM_HELPER.copy(this, obj);
    }

    static {
        PERIODS.add("hourly");
        PERIODS.add("daily");
        PERIODS.add("weekly");
        PERIODS.add("monthly");
        PERIODS.add("yearly");
        HashMap<String, Class<Date>> basePropInterfaceMap = new HashMap<String, Class<Date>>();
        basePropInterfaceMap.put("updatePeriod", String.class);
        basePropInterfaceMap.put("updateFrequency", Integer.TYPE);
        basePropInterfaceMap.put("updateBase", Date.class);
        Map basePropClassImplMap = Collections.EMPTY_MAP;
        COPY_FROM_HELPER = new CopyFromHelper(SyModule.class, basePropInterfaceMap, basePropClassImplMap);
    }
}

