/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.jsonld;

import de.dfki.km.json.jsonld.impl.SesameJSONLDSerializer;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;

public class JsonLdWriter
implements RDFWriter {
    private PrintWriter writer;
    SesameJSONLDSerializer serializer;

    public JsonLdWriter(OutputStream out) {
        this.writer = new PrintWriter(new OutputStreamWriter(out));
        this.serializer = new SesameJSONLDSerializer();
    }

    public JsonLdWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.serializer = new SesameJSONLDSerializer();
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public void startRDF() throws RDFHandlerException {
    }

    public void endRDF() throws RDFHandlerException {
        this.writer.print(this.serializer.asString());
        this.writer.flush();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.serializer.setPrefix(uri, prefix);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.serializer.handleStatement(st);
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }
}

