/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.km.json.jsonld.impl;

import de.dfki.km.json.jsonld.JSONLDTripleCallback;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;

public class SesameTripleCallback
implements JSONLDTripleCallback {
    private ValueFactory vf;
    private Graph storageGraph;

    public SesameTripleCallback() {
        this((Graph)new GraphImpl());
    }

    public SesameTripleCallback(Graph nextGraph) {
        this.setStorageGraph(nextGraph);
    }

    @Override
    public void triple(String s, String p, String o) {
        if (s == null || p == null || o == null) {
            return;
        }
        Statement result = this.vf.createStatement((Resource)this.vf.createURI(s), this.vf.createURI(p), (Value)this.vf.createURI(o));
        this.storageGraph.add((Object)result);
    }

    @Override
    public void triple(String s, String p, String value, String datatype, String language) {
        if (s == null || p == null || value == null) {
            return;
        }
        URI subject = this.vf.createURI(s);
        URI predicate = this.vf.createURI(p);
        Literal object = language != null ? this.vf.createLiteral(value, language) : (datatype != null ? this.vf.createLiteral(value, this.vf.createURI(datatype)) : this.vf.createLiteral(value));
        Statement result = this.vf.createStatement((Resource)subject, predicate, (Value)object);
        this.storageGraph.add((Object)result);
    }

    public Graph getStorageGraph() {
        return this.storageGraph;
    }

    public void setStorageGraph(Graph storageGraph) {
        this.storageGraph = storageGraph;
        if (storageGraph != null) {
            this.vf = storageGraph.getValueFactory();
        }
    }
}

