/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.km.json.jsonld;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONLDUtils {
    public static Map<String, String> getKeywords(Object ctx) {
        HashMap<String, String> rval = new HashMap<String, String>();
        rval.put("@id", "@id");
        rval.put("@language", "@language");
        rval.put("@value", "@value");
        rval.put("@type", "@type");
        if (ctx != null && ctx instanceof Map) {
            HashMap<String, String> keywords = new HashMap<String, String>();
            for (String key : ((Map)ctx).keySet()) {
                Object value = ((Map)ctx).get(key);
                if (!(value instanceof String) || !rval.containsKey(value)) continue;
                keywords.put((String)value, key);
            }
            rval.putAll(keywords);
        }
        return rval;
    }

    public static String getTermIri(Object ctx, String term) {
        String rval = null;
        if (((Map)ctx).containsKey(term)) {
            Object t = ((Map)ctx).get(term);
            if (t instanceof String) {
                rval = (String)t;
            } else if (t instanceof Map && ((Map)t).containsKey("@id")) {
                rval = (String)((Map)t).get("@id");
            }
        }
        return rval;
    }

    public static Map<String, Object> mergeContexts(Object ctxOne, Object ctxTwo) {
        Map<String, Object> ctx1 = ctxOne instanceof List ? JSONLDUtils.mergeContexts(new HashMap(), ctxOne) : (Map<String, Object>)ctxOne;
        Map<String, Object> merged = (Map<String, Object>)JSONLDUtils.clone(ctx1);
        if (ctxTwo instanceof List) {
            for (Object i : (List)ctxTwo) {
                merged = JSONLDUtils.mergeContexts(merged, i);
            }
        } else {
            Map ctx2 = (Map)ctxTwo;
            block1: for (String key : ctx2.keySet()) {
                if (key.startsWith("@")) continue;
                for (String mkey : merged.keySet()) {
                    if (!merged.get(mkey).equals(ctx2.get(key))) continue;
                    merged.remove(mkey);
                    continue block1;
                }
            }
            for (String key : ctx2.keySet()) {
                merged.put(key, ctx2.get(key));
            }
        }
        return merged;
    }

    @Deprecated
    public static String compactIRI(Map<String, Object> ctx, String iri) {
        return JSONLDUtils.compactIRI(ctx, iri, null);
    }

    public static String compactIRI(Map<String, Object> ctx, String iri, Map<String, Object> usedCtx) {
        Map<String, String> keywords;
        String rval = null;
        for (String key : ctx.keySet()) {
            if (key.startsWith("@") || !iri.equals(JSONLDUtils.getTermIri(ctx, key))) continue;
            rval = key;
            if (usedCtx == null) break;
            usedCtx.put(key, JSONLDUtils.clone(ctx.get(key)));
            break;
        }
        if (rval == null && (keywords = JSONLDUtils.getKeywords(ctx)).containsKey(iri) && !(rval = keywords.get(iri)).equals(iri) && usedCtx != null) {
            usedCtx.put(rval, iri);
        }
        if (rval == null) {
            for (String key : ctx.keySet()) {
                String ctxIRI;
                if (key.startsWith("@") || (ctxIRI = JSONLDUtils.getTermIri(ctx, key)) == null || !iri.startsWith(ctxIRI) || iri.length() <= ctxIRI.length()) continue;
                rval = key + ":" + iri.substring(ctxIRI.length());
                if (usedCtx == null) break;
                usedCtx.put(key, JSONLDUtils.clone(ctx.get(key)));
                break;
            }
        }
        if (rval == null) {
            rval = iri;
        }
        return rval;
    }

    @Deprecated
    public static String getCoercionType(Map<String, Object> ctx, String property) {
        return JSONLDUtils.getCoercionType(ctx, property, new HashMap<String, Object>());
    }

    public static String getCoercionType(Map<String, Object> ctx, String property, Map<String, Object> usedCtx) {
        String rval = null;
        String p = JSONLDUtils.expandTerm(ctx, property, null);
        if ("@id".equals(p) || "@type".equals(p)) {
            rval = "@id";
        } else if (ctx.containsKey(p = JSONLDUtils.compactIRI(ctx, p, null)) && ctx.get(p) instanceof Map && ((Map)ctx.get(p)).containsKey("@type")) {
            String type = (String)((Map)ctx.get(p)).get("@type");
            rval = JSONLDUtils.expandTerm(ctx, type, usedCtx);
            if (usedCtx != null) {
                usedCtx.put(p, JSONLDUtils.clone(ctx.get(p)));
            }
        }
        return rval;
    }

    @Deprecated
    public static String expandTerm(Map<String, Object> ctx, String term) {
        return JSONLDUtils.expandTerm(ctx, term, null);
    }

    public static String expandTerm(Map<String, Object> ctx, String term, Map<String, Object> usedCtx) {
        String rval;
        block4: {
            Map<String, String> keywords;
            block5: {
                block3: {
                    keywords = JSONLDUtils.getKeywords(ctx);
                    rval = term;
                    int idx = term.indexOf(":");
                    if (idx == -1) break block3;
                    String prefix = term.substring(0, idx);
                    if (!ctx.containsKey(prefix)) break block4;
                    String iri = JSONLDUtils.getTermIri(ctx, prefix);
                    rval = iri + term.substring(idx + 1);
                    if (usedCtx != null) {
                        usedCtx.put(prefix, JSONLDUtils.clone(ctx.get(prefix)));
                    }
                    break block4;
                }
                if (!ctx.containsKey(term)) break block5;
                rval = JSONLDUtils.getTermIri(ctx, term);
                if (usedCtx == null) break block4;
                usedCtx.put(term, JSONLDUtils.clone(ctx.get(term)));
                break block4;
            }
            for (String k : keywords.keySet()) {
                String v = keywords.get(k);
                if (!v.equals(term)) continue;
                rval = k;
                break;
            }
        }
        if (!term.equals(rval)) {
            return JSONLDUtils.expandTerm(ctx, rval, usedCtx);
        }
        return rval;
    }

    public static boolean isReference(Object value) {
        return value != null && value instanceof Map && ((Map)value).containsKey("@id") && ((Map)value).size() == 1;
    }

    public static boolean isSubject(Object value) {
        boolean rval = false;
        if (value != null && value instanceof Map && !((Map)value).containsKey("@value")) {
            rval = ((Map)value).size() > 1 || !((Map)value).containsKey("@id");
        }
        return rval;
    }

    public static boolean isBlankNode(Object v) {
        return JSONLDUtils.isSubject(v) && (!((Map)v).containsKey("@id") || JSONLDUtils.isNamedBlankNode(v));
    }

    public static boolean isNamedBlankNode(Object v) {
        return v instanceof Map && ((Map)v).containsKey("@id") && JSONLDUtils.isBlankNodeIri(((Map)v).get("@id"));
    }

    public static boolean isBlankNodeIri(Object input) {
        return input instanceof String && ((String)input).startsWith("_:");
    }

    public static Object clone(Object value) {
        Object rval = null;
        if (value instanceof Cloneable) {
            try {
                rval = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
            }
            catch (Exception e) {
                rval = e;
            }
        }
        if (rval == null || rval instanceof Exception) {
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                rval = value;
            } else {
                throw new RuntimeException(new CloneNotSupportedException(rval instanceof Exception ? ((Exception)rval).getMessage() : ""));
            }
        }
        return rval;
    }

    public static int compare(Object v1, Object v2) {
        int rval = 0;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 instanceof List && v2 instanceof List) {
            if (((List)v1).size() != ((List)v2).size()) {
                rval = 1;
            } else {
                for (int i = 0; i < ((List)v1).size() && rval == 0; ++i) {
                    rval = JSONLDUtils.compare(((List)v1).get(i), ((List)v2).get(i));
                }
            }
        } else if (v1 instanceof Number && v2 instanceof Number) {
            double n2;
            double n1 = ((Number)v1).doubleValue();
            rval = n1 < (n2 = ((Number)v2).doubleValue()) ? -1 : (n1 > n2 ? 1 : 0);
        } else if (v1 instanceof String && v2 instanceof String) {
            rval = ((String)v1).compareTo((String)v2);
            if (rval > 1) {
                rval = 1;
            } else if (rval < -1) {
                rval = -1;
            }
        } else {
            if (v1 instanceof Map && v2 instanceof Map) {
                throw new RuntimeException("I don't know how I should handle this case yet!");
            }
            throw new RuntimeException("compare unspecified for these objects");
        }
        return rval;
    }

    public static int compareBlankNodeObjects(Map<String, Object> a, Map<String, Object> b) {
        int rval = 0;
        for (String p : a.keySet()) {
            if (p.equals("@id")) continue;
            int lenA = a.get(p) instanceof List ? ((List)a.get(p)).size() : 1;
            int lenB = b.get(p) instanceof List ? ((List)b.get(p)).size() : 1;
            rval = JSONLDUtils.compare(lenA, lenB);
            if (rval == 0) {
                Object e;
                int i;
                ArrayList<Object> objsB;
                List objsA;
                if (a.get(p) instanceof List) {
                    objsA = (List)JSONLDUtils.clone((List)a.get(p));
                    objsB = (ArrayList<Object>)JSONLDUtils.clone((List)b.get(p));
                } else {
                    objsA = new ArrayList<Object>();
                    objsA.add(a.get(p));
                    objsB = new ArrayList<Object>();
                    objsB.add(b.get(p));
                }
                for (i = 0; i < objsA.size(); ++i) {
                    e = objsA.get(i);
                    if (!JSONLDUtils.isNamedBlankNode(e)) continue;
                    objsA.remove(i);
                    --i;
                }
                for (i = 0; i < objsB.size(); ++i) {
                    e = objsB.get(i);
                    if (!JSONLDUtils.isNamedBlankNode(e)) continue;
                    objsB.remove(i);
                    --i;
                }
                rval = JSONLDUtils.compare(objsA.size(), objsB.size());
                if (rval == 0) {
                    Collections.sort(objsA, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return JSONLDUtils.compareObjects(o1, o2);
                        }
                    });
                    Collections.sort(objsB, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return JSONLDUtils.compareObjects(o1, o2);
                        }
                    });
                    for (i = 0; i < objsA.size() && rval == 0 && (rval = JSONLDUtils.compareObjects(objsA.get(i), objsB.get(i))) == 0; ++i) {
                    }
                }
            }
            if (rval == 0) continue;
            break;
        }
        return rval;
    }

    public static int compareObjects(Object o1, Object o2) {
        int rval = 0;
        if (o1 instanceof String) {
            rval = o2 instanceof String ? JSONLDUtils.compare(o1, o2) : -1;
        } else if (o2 instanceof String) {
            rval = 1;
        } else if (o1 instanceof Map && (rval = JSONLDUtils.compareObjectKeys(o1, o2, "@value")) == 0) {
            if (((Map)o1).containsKey("@value")) {
                rval = JSONLDUtils.compareObjectKeys(o1, o2, "@type");
                if (rval == 0) {
                    rval = JSONLDUtils.compareObjectKeys(o1, o2, "@language");
                }
            } else {
                rval = JSONLDUtils.compare(((Map)o1).get("@id"), ((Map)o2).get("@id"));
            }
        }
        return rval;
    }

    private static int compareObjectKeys(Object o1, Object o2, String key) {
        int rval = 0;
        if (((Map)o1).containsKey(key)) {
            rval = ((Map)o2).containsKey(key) ? JSONLDUtils.compare(((Map)o1).get(key), ((Map)o2).get(key)) : -1;
        } else if (((Map)o2).containsKey(key)) {
            rval = 1;
        }
        return rval;
    }

    public static void rotate(List<Object> a) {
        if (a.size() > 0) {
            Object tmp = a.remove(0);
            a.add(tmp);
        }
    }

    public static int compareSerializations(String s1, String s2) {
        int rval = 0;
        rval = s1.length() == s2.length() ? JSONLDUtils.compare(s1, s2) : (s1.length() > s2.length() ? JSONLDUtils.compare(s1.substring(0, s2.length()), s2) : JSONLDUtils.compare(s1, s2.substring(0, s1.length())));
        return rval;
    }

    public static String serializeProperties(Map<String, Object> b) {
        String rval = "";
        Boolean first = true;
        for (String p : b.keySet()) {
            if ("@id".equals(p)) continue;
            if (first.booleanValue()) {
                first = false;
            } else {
                rval = rval + "|";
            }
            rval = rval + "<" + p + ">";
            List<Object> objs = null;
            if (b.get(p) instanceof List) {
                objs = (List)b.get(p);
            } else {
                objs = new ArrayList();
                objs.add(b.get(p));
            }
            for (Object e : objs) {
                if (e instanceof Map) {
                    if (((Map)e).containsKey("@id")) {
                        if (JSONLDUtils.isBlankNodeIri(((Map)e).get("@id"))) {
                            rval = rval + "_:";
                            continue;
                        }
                        rval = rval + "<" + ((Map)e).get("@id") + ">";
                        continue;
                    }
                    rval = rval + "\"" + ((Map)e).get("@value") + "\"";
                    if (((Map)e).containsKey("@type")) {
                        rval = rval + "^^<" + ((Map)e).get("@type") + ">";
                        continue;
                    }
                    if (!((Map)e).containsKey("@language")) continue;
                    rval = rval + "@" + ((Map)e).get("@language");
                    continue;
                }
                rval = rval + "\"" + e + "\"";
            }
        }
        return rval;
    }

    public static void setProperty(Map<String, Object> s, String p, Object o) {
        if (s.containsKey(p)) {
            if (s.get(p) instanceof List) {
                ((List)s.get(p)).add(o);
            } else {
                ArrayList<Object> tmp = new ArrayList<Object>();
                tmp.add(s.get(p));
                tmp.add(o);
                s.put(p, tmp);
            }
        } else {
            s.put(p, o);
        }
    }

    public static Object frame(Map subjects, List input, Object frame, HashMap embeds, boolean autoembed, Object parent, String parentKey, Map options) {
        Map defopts;
        ArrayList rval = null;
        int limit = -1;
        List frames = null;
        if (frame instanceof List) {
            rval = new ArrayList();
            frames = (List)frame;
            if (frames.isEmpty()) {
                frames.add(new HashMap());
            }
        } else {
            frames = new ArrayList<Object>();
            frames.add(frame);
            limit = 1;
        }
        boolean omitOn = false;
        if (options != null && options.containsKey("defaults") && (defopts = (Map)options.get("defaults")).containsKey("omitDefaultOn")) {
            omitOn = (Boolean)defopts.get("omitDefaultOn");
        }
        ArrayList values = new ArrayList();
        for (Object e : frames) {
            if (!(e instanceof List) && !(e instanceof Map)) {
                throw new RuntimeException("Invalid JSON - LD frame. Frame type is not a map or array.");
            }
            ArrayList vali = new ArrayList();
            for (Object n : input) {
                if (n instanceof Map && ((Map)n).containsKey("@id") && subjects.containsKey(((Map)n).get("@id"))) {
                    n = subjects.get(((Map)n).get("@id"));
                }
                if (!JSONLDUtils.isType(n, (Map)e) && !JSONLDUtils.isDuckType(n, (Map)e)) continue;
                vali.add(n);
                if (--limit != 0) continue;
                break;
            }
            values.add(vali);
            if (limit != 0) continue;
            break;
        }
        for (int i = 0; i < frames.size(); ++i) {
            Object e = frames.get(i);
            List v = (List)values.get(i);
            for (Object value : v) {
                if (JSONLDUtils.isSubject(value)) {
                    value = JSONLDUtils.subframe(subjects, (Map)value, (Map)e, embeds, autoembed, parent, parentKey, options);
                }
                if (rval == null) {
                    rval = value;
                    continue;
                }
                if (JSONLDUtils.isReference(value) && embeds.containsKey(((Map)value).get("@id")) && parent == null) continue;
                ((List)rval).add(value);
            }
        }
        return rval;
    }

    private static Object subframe(Map subjects, Map value, Map frame, HashMap embeds, boolean autoembed, Object parent, String parentKey, Map options) {
        boolean embedOn;
        String iri = (String)value.get("@id");
        HashMap<String, Object> embed = (HashMap<String, Object>)embeds.get(iri);
        boolean bl = embedOn = (frame.containsKey("@embed") && (Boolean)frame.get("@embed") != false || !frame.containsKey("@embed") && (Boolean)((Map)options.get("defaults")).get("embedOn") != false) && (embed == null || (Boolean)embed.get("autoembed") != false && !autoembed);
        if (!embedOn) {
            HashMap tmp = new HashMap();
            tmp.put("@id", value.get("@id"));
            return tmp;
        }
        if (embed == null) {
            embed = new HashMap<String, Object>();
            embeds.put(iri, embed);
        } else if (embed.get("parent") != null) {
            Object objs = ((Map)embed.get("parent")).get(embed.get("key"));
            if (objs instanceof List) {
                for (int i = 0; i < ((List)objs).size(); ++i) {
                    Object oi = ((List)objs).get(i);
                    if (!(oi instanceof Map) || !((Map)oi).containsKey("@id") || !((Map)oi).get("@id").equals(iri)) continue;
                    HashMap tmp = new HashMap();
                    tmp.put("@id", value.get("id"));
                    ((List)objs).set(i, tmp);
                    break;
                }
            } else {
                HashMap tmp = new HashMap();
                tmp.put("@id", value.get("@id"));
                ((Map)embed.get("parent")).put(embed.get("key"), tmp);
            }
            JSONLDUtils.removeDependentEmbeds(iri, embeds);
        }
        embed.put("autoembed", autoembed);
        embed.put("parent", parent);
        embed.put("key", parentKey);
        boolean explicitOn = frame.containsKey("@explicit") ? (Boolean)frame.get("@explicit") : (Boolean)((Map)options.get("defaults")).get("explicitOn");
        if (explicitOn) {
            for (String key : new HashSet(value.keySet())) {
                if ("@id".equals(key) || frame.containsKey(key)) continue;
                value.remove(key);
            }
        }
        for (String key : value.keySet()) {
            boolean _autoembed;
            Object v = value.get(key);
            if (key.startsWith("@")) continue;
            Object f = frame.get(key);
            boolean bl2 = _autoembed = f == null;
            if (_autoembed) {
                f = value.get(key) instanceof List ? new ArrayList() : new HashMap();
            }
            ArrayList input = null;
            if (value.get(key) instanceof List) {
                input = (ArrayList)value.get(key);
            } else {
                ArrayList tmp = new ArrayList();
                tmp.add(value.get(key));
                input = tmp;
            }
            for (int n = 0; n < input.size(); ++n) {
                Object in = input.get(n);
                if (!(in instanceof Map) || !((Map)in).containsKey("@id") || !subjects.containsKey(((Map)in).get("@id"))) continue;
                input.set(n, subjects.get(((Map)in).get("@id")));
            }
            value.put(key, JSONLDUtils.frame(subjects, input, f, embeds, _autoembed, value, key, options));
        }
        for (String key : frame.keySet()) {
            Object f = frame.get(key);
            if (key.startsWith("@") || value.containsKey(key) && value.get(key) != null) continue;
            if (f instanceof List) {
                value.put(key, new ArrayList());
                continue;
            }
            boolean omitOn = ((Map)f).containsKey("@omitDefault") ? (Boolean)((Map)f).get("@omitDefault") : (Boolean)((Map)options.get("defaults")).get("omitDefaultOn");
            if (omitOn) continue;
            if (((Map)f).containsKey("@default")) {
                value.put(key, ((Map)f).get("@default"));
                continue;
            }
            value.put(key, null);
        }
        return value;
    }

    private static void removeDependentEmbeds(String iri, Map embeds) {
        HashSet iris = new HashSet(embeds.keySet());
        for (String i : iris) {
            if (!embeds.containsKey(i) || ((Map)embeds.get(i)).get("parent") == null || !iri.equals(((Map)((Map)embeds.get(i)).get("parent")).get("@id"))) continue;
            embeds.remove(i);
            JSONLDUtils.removeDependentEmbeds(i, embeds);
        }
    }

    private static boolean isDuckType(Object src, Map frame) {
        String rType = "@type";
        if (!frame.containsKey(rType)) {
            Set props1 = frame.keySet();
            HashSet<String> props = new HashSet<String>();
            for (String p : props1) {
                if (p.startsWith("@")) continue;
                props.add(p);
            }
            if (props.isEmpty()) {
                return true;
            }
            if (src instanceof Map && ((Map)src).containsKey("@id")) {
                for (String i : props) {
                    if (((Map)src).containsKey(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isType(Object src, Map frame) {
        String rType = "@type";
        if (frame.containsKey(rType) && src instanceof Map && ((Map)src).containsKey(rType)) {
            List tmp = null;
            if (((Map)src).get(rType) instanceof List) {
                tmp = (List)((Map)src).get(rType);
            } else {
                tmp = new ArrayList();
                tmp.add(((Map)src).get(rType));
            }
            List types = null;
            if (frame.get(rType) instanceof List) {
                types = (List)frame.get(rType);
            } else {
                types = new ArrayList();
                types.add(frame.get(rType));
            }
            for (Object typ : types) {
                for (Object i : tmp) {
                    if (!i.equals(typ)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class NameGenerator {
        private String prefix;
        private int count;

        public NameGenerator(String prefix) {
            this.prefix = prefix;
            this.count = -1;
        }

        public String next() {
            ++this.count;
            return this.current();
        }

        public String current() {
            return "_:" + this.prefix + this.count;
        }

        public boolean inNamespace(String iri) {
            return iri.startsWith("_:" + this.prefix);
        }
    }
}

