/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.km.json.jsonld;

import de.dfki.km.json.JSONUtils;
import de.dfki.km.json.jsonld.JSONLDProcessor;
import de.dfki.km.json.jsonld.JSONLDUtils;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONLDSerializer {
    private Map<String, Map<String, Object>> _subjects;
    private Map<String, Object> _context;
    JSONLDUtils.NameGenerator _ng;
    Map<String, String> _bns;

    public JSONLDSerializer() {
        this.reset();
    }

    public void reset() {
        this._subjects = new HashMap<String, Map<String, Object>>();
        this._context = new HashMap<String, Object>();
        this._context.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this._context.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this._context.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        this._ng = new JSONLDUtils.NameGenerator("bn");
        this._bns = new HashMap<String, String>();
    }

    protected Map<String, Object> getSubject(String subjURI) {
        return this._subjects.get(subjURI);
    }

    protected void setSubject(String subjURI, Map<String, Object> subj) {
        this._subjects.put(subjURI, subj);
    }

    protected String getNameForBlankNode(String node) {
        if (!this._bns.containsKey(node)) {
            this._bns.put(node, this._ng.next());
        }
        return this._bns.get(node);
    }

    private void triple(String s, String p, Object value) {
        Object oldval;
        Map<String, Object> subj = this._subjects.get(s);
        if (subj == null) {
            subj = new HashMap<String, Object>();
            this._subjects.put(s, subj);
            subj.put("@id", s);
        }
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(p)) {
            p = "@type";
            if (value instanceof Map) {
                if (((Map)((Object)value)).containsKey("@id")) {
                    value = ((Map)((Object)value)).get("@id");
                } else if (((Map)((Object)value)).containsKey("@value")) {
                    value = ((Map)((Object)value)).get("@value");
                }
            }
        }
        if ((oldval = subj.get(p)) != null) {
            if (oldval instanceof List) {
                ((List)oldval).add(value);
                value = oldval;
            } else {
                ArrayList<Object> tmp = new ArrayList<Object>();
                tmp.add(oldval);
                tmp.add(value);
                value = tmp;
            }
        }
        subj.put(p, value);
    }

    public void triple(String s, String p, String value, String datatype, String language) {
        HashMap val;
        if (datatype == null || "http://www.w3.org/2001/XMLSchema#string".equals(datatype)) {
            if (language == null || "".equals(language)) {
                val = value;
            } else {
                val = new HashMap();
                ((Map)val).put("@value", value);
                ((Map)val).put("@language", language);
            }
        } else {
            val = new HashMap();
            ((Map)val).put("@value", value);
            ((Map)val).put("@type", datatype);
        }
        this.triple(s, p, val);
    }

    public void triple(String s, String p, String o) {
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("@id", o);
        this.triple(s, p, val);
    }

    public void setPrefix(String fullUri, String prefix) {
        this._context.put(prefix, fullUri);
    }

    public Object asObject() {
        JSONLDProcessor p = new JSONLDProcessor();
        ArrayList<Map> subjects = new ArrayList<Map>();
        for (Map<String, Object> map : this._subjects.values()) {
            Map map2 = (Map)p.compact(this._context, map);
            subjects.add(map2);
        }
        if (subjects.size() == 1) {
            Map<String, Map<String, Object>> rval = new HashMap();
            rval = (Map)subjects.get(0);
            rval.put("@context", this._context);
            return rval;
        }
        return subjects;
    }

    public void toWriter(Writer writer) {
        try {
            JSONUtils.writePrettyPrint(writer, this.asObject());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String asString() {
        return this.asString(false);
    }

    public String asString(boolean prettyPrint) {
        try {
            if (!prettyPrint) {
                return JSONUtils.toString(this.asObject());
            }
            return JSONUtils.toPrettyString(this.asObject());
        }
        catch (Exception e) {
            return "{\"error\":\"" + e.getLocalizedMessage() + "\"}";
        }
    }
}

