/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.km.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;

public class JSONUtils {
    public static Object fromString(String jsonString) throws JsonParseException, JsonMappingException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object rval = null;
        if (jsonString.trim().startsWith("[")) {
            try {
                rval = objectMapper.readValue(jsonString, List.class);
            }
            catch (IOException e) {
                if (e instanceof JsonParseException) {
                    throw (JsonParseException)e;
                }
                if (e instanceof JsonMappingException) {
                    throw (JsonMappingException)e;
                }
                e.printStackTrace();
            }
        } else if (jsonString.trim().startsWith("{")) {
            try {
                rval = objectMapper.readValue(jsonString, Map.class);
            }
            catch (IOException e) {
                if (e instanceof JsonParseException) {
                    throw (JsonParseException)e;
                }
                if (e instanceof JsonMappingException) {
                    throw (JsonMappingException)e;
                }
                e.printStackTrace();
            }
        } else if (jsonString.trim().startsWith("\"")) {
            try {
                rval = objectMapper.readValue(jsonString, String.class);
            }
            catch (IOException e) {
                if (e instanceof JsonParseException) {
                    throw (JsonParseException)e;
                }
                if (e instanceof JsonMappingException) {
                    throw (JsonMappingException)e;
                }
                e.printStackTrace();
            }
        } else if (jsonString.trim().equals("true") || jsonString.trim().equals("false")) {
            try {
                rval = objectMapper.readValue(jsonString, Boolean.class);
            }
            catch (IOException e) {
                if (e instanceof JsonParseException) {
                    throw (JsonParseException)e;
                }
                if (e instanceof JsonMappingException) {
                    throw (JsonMappingException)e;
                }
                e.printStackTrace();
            }
        } else if (jsonString.trim().matches("[0-9.e+-]+")) {
            try {
                rval = objectMapper.readValue(jsonString, Number.class);
            }
            catch (IOException e) {
                if (e instanceof JsonParseException) {
                    throw (JsonParseException)e;
                }
                if (e instanceof JsonMappingException) {
                    throw (JsonMappingException)e;
                }
                e.printStackTrace();
            }
        } else if (jsonString.trim().equals("null")) {
            rval = null;
        } else {
            throw new JsonParseException("document doesn't start with a valid json element", new JsonLocation((Object)("\"" + jsonString.substring(0, Math.min(jsonString.length(), 100)) + "...\""), 0L, 1, 0));
        }
        return rval;
    }

    public static Object fromReader(Reader r) throws IOException {
        int b;
        StringBuffer sb = new StringBuffer();
        while ((b = r.read()) != -1) {
            sb.append((char)b);
        }
        return JSONUtils.fromString(sb.toString());
    }

    public static void write(Writer w, Object jsonObject) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        objectMapper.writeValue(w, jsonObject);
    }

    public static void writePrettyPrint(Writer w, Object jsonObject) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        objectWriter.writeValue(w, jsonObject);
    }

    public static Object fromInputStream(InputStream content) throws IOException {
        return JSONUtils.fromInputStream(content, "UTF-8");
    }

    public static Object fromInputStream(InputStream content, String enc) throws IOException {
        return JSONUtils.fromReader(new BufferedReader(new InputStreamReader(content, enc)));
    }

    public static String toPrettyString(Object obj) {
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writePrettyPrint(sw, obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }

    public static String toString(Object obj) {
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.write(sw, obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }

    public static boolean equals(Object v1, Object v2) {
        boolean rval = true;
        if (v1 instanceof List && v2 instanceof List) {
            if (((List)v1).size() != ((List)v2).size()) {
                rval = false;
            } else {
                for (int i = 0; i < ((List)v1).size() && rval; ++i) {
                    rval = JSONUtils.equals(((List)v1).get(i), ((List)v2).get(i));
                }
            }
        } else if (v1 instanceof Number && v2 instanceof Number) {
            double n2;
            double n1 = ((Number)v1).doubleValue();
            rval = n1 == (n2 = ((Number)v2).doubleValue());
        } else if (v1 instanceof String && v2 instanceof String) {
            rval = ((String)v1).equals((String)v2);
        } else if (v1 instanceof Map && v2 instanceof Map) {
            if (((Map)v1).size() != ((Map)v2).size()) {
                rval = false;
            } else {
                Object k1;
                Iterator i$ = ((Map)v1).keySet().iterator();
                while (i$.hasNext() && (rval = ((Map)v2).containsKey(k1 = i$.next()) ? JSONUtils.equals(((Map)v1).get(k1), ((Map)v2).get(k1)) : false)) {
                }
            }
        } else {
            rval = v1 instanceof Boolean && v2 instanceof Boolean ? v1 == v2 : (v1 != null && v2 != null ? v1.equals(v2) : v1 == v2);
        }
        return rval;
    }
}

