/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldcache.services.ldcache;

import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.marmotta.commons.sesame.filter.NotFilter;
import org.apache.marmotta.commons.sesame.filter.SesameFilter;
import org.apache.marmotta.ldcache.sail.KiWiLinkedDataSail;
import org.apache.marmotta.ldcache.services.LDCache;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.ldclient.LDClientService;
import org.apache.marmotta.ldclient.model.ClientConfiguration;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.http.HttpClientService;
import org.apache.marmotta.platform.core.api.triplestore.NotifyingSailProvider;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.events.ConfigurationChangedEvent;
import org.apache.marmotta.platform.core.model.filter.MarmottaLocalFilter;
import org.apache.marmotta.platform.ldcache.api.endpoint.LinkedDataEndpointService;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.helpers.NotifyingSailWrapper;
import org.slf4j.Logger;

@ApplicationScoped
public class LDCacheSailProvider
implements NotifyingSailProvider {
    public static final String LDCACHE_ENABLED = "ldcache.enabled";
    @Inject
    private Logger log;
    @Inject
    private LinkedDataEndpointService endpointService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;
    @Inject
    private HttpClientService httpClientService;
    private ClientConfiguration ldclientConfig;
    private KiWiLinkedDataSail sail;

    public String getName() {
        return "Linked Data Caching";
    }

    public boolean isEnabled() {
        return this.configurationService.getBooleanConfiguration(LDCACHE_ENABLED, true);
    }

    public void configurationChanged(@Observes ConfigurationChangedEvent e) {
        if (e.containsChangedKey(LDCACHE_ENABLED)) {
            this.sesameService.shutdown();
            this.sesameService.initialise();
        }
    }

    @PostConstruct
    public void initialize() {
        this.ldclientConfig = new ClientConfiguration();
        this.updateConfig();
    }

    public void updateEndpoints() {
        this.ldclientConfig.setEndpoints(new HashSet<Endpoint>(this.endpointService.listEndpoints()));
        if (this.sail != null && this.sail.getLDCache() != null) {
            this.sail.getLDCache().reload();
        }
    }

    public void updateConfig() {
        this.ldclientConfig.setDefaultExpiry(this.configurationService.getLongConfiguration("ldcache.expiry", 86400L));
        this.ldclientConfig.setMinimumExpiry(this.configurationService.getLongConfiguration("ldcache.minexpiry", 3600L));
        this.ldclientConfig.setSocketTimeout(this.configurationService.getIntConfiguration("ldcache.so_timeout", 60000));
        this.ldclientConfig.setConnectionTimeout(this.configurationService.getIntConfiguration("ldcache.connection_timeout", 10000));
        this.ldclientConfig.setMaxParallelRequests(this.configurationService.getIntConfiguration("ldcache.max_parallel_requests", 10));
        this.ldclientConfig.setEndpoints(new HashSet<Endpoint>(this.endpointService.listEndpoints()));
        this.ldclientConfig.setHttpClient(this.httpClientService.getHttpClient());
        if (this.sail != null && this.sail.getLDCache() != null) {
            this.sail.getLDCache().reload();
        }
    }

    public NotifyingSailWrapper createSail(NotifyingSail parent) {
        String cache_context = this.configurationService.getCacheContext();
        this.sail = new KiWiLinkedDataSail(parent, (SesameFilter)new NotFilter((SesameFilter)MarmottaLocalFilter.getInstance()), cache_context, this.ldclientConfig);
        return this.sail;
    }

    public LDClientService getLDClient() {
        return this.sail.getLDCache().getLDClient();
    }

    public LDCache getLDCache() {
        return this.sail.getLDCache();
    }
}

