/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldcache.services.endpoint;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.marmotta.commons.http.LMFHttpUtils;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.ldcache.api.endpoint.LinkedDataEndpointService;
import org.openrdf.model.URI;
import org.slf4j.Logger;

@ApplicationScoped
public class LinkedDataEndpointServiceImpl
implements LinkedDataEndpointService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    private static Endpoint[] blacklist = new Endpoint[]{new Endpoint("HolyGoat", "NONE", "^http://www\\.holygoat\\.co\\.uk", "", "", Long.valueOf(86400L)), new Endpoint("KiWi Project", "NONE", "^http://www\\.kiwi-project\\.eu/", "", "", Long.valueOf(86400L))};

    @PostConstruct
    public void initialize() {
        this.log.trace("LDEndpointService staring up...");
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        this.storeEndpoint(endpoint);
    }

    @Override
    public void updateEndpoint(Endpoint endpoint) {
        this.storeEndpoint(endpoint);
    }

    @Override
    public List<Endpoint> listEndpoints() {
        ArrayList<Endpoint> result = new ArrayList<Endpoint>();
        for (String label : this.listEndpointLabels()) {
            result.add(this.getEndpointByLabel(label));
        }
        for (Endpoint e : blacklist) {
            if (result.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public void removeEndpoint(Endpoint endpoint) {
        String label = endpoint.getName().replaceAll("[^A-Za-z0-9 ]", "").toLowerCase();
        List keys = this.configurationService.listConfigurationKeys("ldcache.endpoint." + label);
        for (String key : keys) {
            this.configurationService.removeConfiguration(key);
        }
    }

    @Override
    public Endpoint getEndpoint(String id) {
        for (Endpoint endpoint : this.listEndpoints()) {
            if (!endpoint.getName().replaceAll("[^A-Za-z0-9 ]", "").toLowerCase().equals(id)) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public Endpoint getEndpoint(URI resource) {
        for (Endpoint endpoint : this.listEndpoints()) {
            if (!endpoint.handles(resource.stringValue())) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public boolean hasEndpoint(String urlPattern) {
        for (Endpoint endpoint : this.listEndpoints()) {
            if (endpoint.getUriPattern() == null || !endpoint.getUriPattern().equals(urlPattern)) continue;
            return true;
        }
        return false;
    }

    private void storeEndpoint(Endpoint endpoint) {
        String label = endpoint.getName().replaceAll("[^A-Za-z0-9 ]", "").toLowerCase();
        this.configurationService.setConfiguration("ldcache.endpoint." + label + ".name", endpoint.getName());
        this.configurationService.setIntConfiguration("ldcache.endpoint." + label + ".prio", endpoint.getPriority());
        this.configurationService.setConfiguration("ldcache.endpoint." + label + ".provider", endpoint.getType());
        this.configurationService.setConfiguration("ldcache.endpoint." + label + ".pattern", endpoint.getUriPattern());
        this.configurationService.setConfiguration("ldcache.endpoint." + label + ".service", endpoint.getEndpointUrl());
        this.configurationService.setLongConfiguration("ldcache.endpoint." + label + ".expiry", endpoint.getDefaultExpiry().longValue());
        this.configurationService.setBooleanConfiguration("ldcache.endpoint." + label + ".active", endpoint.isActive());
        this.configurationService.setConfiguration("ldcache.endpoint." + label + ".contenttype", Joiner.on((String)",").join((Iterable)endpoint.getContentTypes()));
    }

    private Endpoint getEndpointByLabel(String label) {
        Endpoint endpoint = new Endpoint();
        endpoint.setName(this.configurationService.getStringConfiguration("ldcache.endpoint." + label + ".name"));
        endpoint.setPriority(this.configurationService.getIntConfiguration("ldcache.endpoint." + label + ".prio"));
        endpoint.setType(this.configurationService.getStringConfiguration("ldcache.endpoint." + label + ".provider"));
        endpoint.setUriPattern(this.configurationService.getStringConfiguration("ldcache.endpoint." + label + ".pattern"));
        endpoint.setEndpointUrl(this.configurationService.getStringConfiguration("ldcache.endpoint." + label + ".service"));
        endpoint.setDefaultExpiry(Long.valueOf(this.configurationService.getLongConfiguration("ldcache.endpoint." + label + ".expiry")));
        endpoint.setActive(this.configurationService.getBooleanConfiguration("ldcache.endpoint." + label + ".active"));
        endpoint.setContentTypes(new HashSet(LMFHttpUtils.parseAcceptHeader((String)this.configurationService.getStringConfiguration("ldcache.endpoint." + label + ".contenttype", ""))));
        return endpoint;
    }

    private Collection<String> listEndpointLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (String key : this.configurationService.listConfigurationKeys("ldcache.endpoint")) {
            String[] components = key.split("\\.");
            labels.add(components[2]);
        }
        return labels;
    }
}

